/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.console.client.ui.federation;

import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.ui.LayoutPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.inject.Inject;
import java.util.EnumSet;
import java.util.List;
import org.jboss.as.console.client.Console;
import org.jboss.as.console.client.shared.deployment.model.DeploymentRecord;
import org.jboss.as.console.client.shared.viewframework.AbstractEntityView;
import org.jboss.as.console.client.shared.viewframework.EntityEditor;
import org.jboss.as.console.client.shared.viewframework.EntityToDmrBridge;
import org.jboss.as.console.client.shared.viewframework.EntityToDmrBridgeImpl;
import org.jboss.as.console.client.shared.viewframework.FormItemObserver;
import org.jboss.as.console.client.shared.viewframework.FrameworkButton;
import org.jboss.as.console.client.shared.viewframework.FrameworkView;
import org.jboss.as.console.client.shared.viewframework.NamedEntity;
import org.jboss.as.console.client.widgets.forms.ApplicationMetaData;
import org.jboss.as.console.client.widgets.pages.PagedView;
import org.jboss.ballroom.client.widgets.forms.Form;
import org.jboss.ballroom.client.widgets.forms.FormAdapter;
import org.jboss.ballroom.client.widgets.tables.DefaultCellTable;
import org.jboss.ballroom.client.widgets.tabs.FakeTabPanel;
import org.jboss.dmr.client.dispatch.DispatchAsync;
import org.picketlink.as.console.client.i18n.PicketLinkUIConstants;
import org.picketlink.as.console.client.i18n.PicketLinkUIMessages;
import org.picketlink.as.console.client.shared.subsys.model.Federation;
import org.picketlink.as.console.client.shared.subsys.model.FederationWrapper;
import org.picketlink.as.console.client.ui.federation.FederationPresenter;
import org.picketlink.as.console.client.ui.federation.FederationTable;
import org.picketlink.as.console.client.ui.federation.NewFederationDetails;
import org.picketlink.as.console.client.ui.federation.idp.IdentityProviderEditor;
import org.picketlink.as.console.client.ui.federation.sp.ServiceProviderEditor;

public class NewFederationView
extends AbstractEntityView<Federation>
implements FederationPresenter.MyView {
    private EntityToDmrBridgeImpl<Federation> bridge;
    private FederationPresenter presenter;
    private PicketLinkUIConstants uiConstants;
    private PicketLinkUIMessages uiMessages;
    private PagedView pages;
    private IdentityProviderEditor identityProviderEditor;
    private FederationTable federationsTable;
    private ServiceProviderEditor serviceProviderEditor;
    private NewFederationDetails federationDetails;

    @Inject
    public NewFederationView(ApplicationMetaData propertyMetaData, DispatchAsync dispatchAsync, PicketLinkUIConstants uiConstants, PicketLinkUIMessages uiMessages) {
        super(Federation.class, propertyMetaData, EnumSet.of(FrameworkButton.EDIT_SAVE));
        this.bridge = new EntityToDmrBridgeImpl<Federation>(propertyMetaData, Federation.class, (FrameworkView)this, dispatchAsync){

            public void onRemove(Federation entity) {
                super.onRemove((NamedEntity)entity);
                NewFederationView.this.presenter.updateFederationSelection(null);
            }
        };
        this.uiConstants = uiConstants;
        this.uiMessages = uiMessages;
    }

    public Widget createWidget() {
        this.pages = new PagedView();
        Widget domainList = this.createDomainList(this.uiMessages.federationSectionDescription());
        this.pages.addPage(Console.CONSTANTS.common_label_back(), domainList);
        this.pages.addPage(this.getIdentityProviderEditor().doGetEntityName(), this.getIdentityProviderEditor().asWidget());
        this.pages.addPage(this.getServiceProviderEditor().doGetEntityName(), this.getServiceProviderEditor().asWidget());
        this.pages.showPage(0);
        LayoutPanel layout = new LayoutPanel();
        FakeTabPanel titleBar = new FakeTabPanel(this.getEntityDisplayName());
        layout.add((Widget)titleBar);
        Widget pagesWidget = this.pages.asWidget();
        layout.add(pagesWidget);
        layout.setWidgetTopHeight((Widget)titleBar, 0.0, Style.Unit.PX, 40.0, Style.Unit.PX);
        layout.setWidgetTopHeight(pagesWidget, 40.0, Style.Unit.PX, 100.0, Style.Unit.PCT);
        this.federationsTable.addSelectionChangeHandler();
        return layout;
    }

    @Override
    public void updateSelectedFederation(FederationWrapper federation) {
        this.federationDetails.updateTabs(federation);
        this.getIdentityProviderEditor().updateIdentityProviders(federation);
        this.getServiceProviderEditor().updateServiceProviders(federation);
    }

    private Widget createDomainList(String description) {
        VerticalPanel panel = new VerticalPanel();
        panel.setStyleName("rhs-content-panel");
        ScrollPanel scrollPanel = new ScrollPanel((Widget)panel);
        this.entityEditor = this.makeEntityEditor();
        this.entityEditor.setDescription(description);
        Widget editorWidget = this.entityEditor.setIncludeTools(true).asWidget();
        panel.add(editorWidget);
        return scrollPanel;
    }

    @Override
    public void updateDeployments(List<DeploymentRecord> deployments) {
        this.getIdentityProviderEditor().updateDeployments(deployments);
        this.getServiceProviderEditor().updateDeployments(deployments);
    }

    private IdentityProviderEditor getIdentityProviderEditor() {
        if (this.identityProviderEditor == null) {
            this.identityProviderEditor = new IdentityProviderEditor(this.presenter, this.uiConstants, this.uiMessages);
        }
        return this.identityProviderEditor;
    }

    private ServiceProviderEditor getServiceProviderEditor() {
        if (this.serviceProviderEditor == null) {
            this.serviceProviderEditor = new ServiceProviderEditor(this.presenter, this.uiConstants, this.uiMessages);
        }
        return this.serviceProviderEditor;
    }

    @Override
    public void setPresenter(FederationPresenter presenter) {
        this.presenter = presenter;
    }

    public EntityToDmrBridge<Federation> getEntityBridge() {
        return this.bridge;
    }

    protected EntityEditor<Federation> makeEntityEditor() {
        return super.makeEntityEditor().setIncludeTools(true);
    }

    protected FormAdapter<Federation> makeEditEntityDetailsForm() {
        if (this.federationDetails == null) {
            this.federationDetails = new NewFederationDetails(this.presenter, this.uiConstants);
        }
        return this.federationDetails;
    }

    protected DefaultCellTable<Federation> makeEntityTable() {
        this.federationsTable = new FederationTable(this.presenter, this.federationDetails, this.uiConstants);
        return this.federationsTable.getCellTable();
    }

    @Override
    public void selectFederation(FederationWrapper federation) {
        if (federation != null) {
            this.pages.showPage(1);
            this.bridge.loadEntities(federation.getName());
        } else {
            this.pages.showPage(0);
        }
        this.updateSelectedFederation(federation);
    }

    protected FormAdapter<Federation> makeAddEntityForm() {
        Form form = new Form(Federation.class);
        form.setNumColumns(1);
        form.setFields(this.formMetaData.findAttribute("name").getFormItemForAdd(new FormItemObserver[0]));
        return form;
    }

    protected String getEntityDisplayName() {
        return this.uiConstants.common_label_federation();
    }
}

