/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.console.client.ui.federation;

import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.client.ui.TabPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import java.util.Map;
import org.jboss.as.console.client.layout.FormLayout;
import org.jboss.ballroom.client.widgets.forms.EditListener;
import org.jboss.ballroom.client.widgets.forms.Form;
import org.jboss.ballroom.client.widgets.forms.FormAdapter;
import org.jboss.ballroom.client.widgets.forms.FormCallback;
import org.jboss.ballroom.client.widgets.forms.FormItem;
import org.jboss.ballroom.client.widgets.forms.FormValidation;
import org.jboss.ballroom.client.widgets.forms.FormValidator;
import org.jboss.ballroom.client.widgets.forms.TextItem;
import org.picketlink.as.console.client.i18n.PicketLinkUIConstants;
import org.picketlink.as.console.client.shared.subsys.model.Federation;
import org.picketlink.as.console.client.shared.subsys.model.FederationWrapper;
import org.picketlink.as.console.client.ui.federation.FederationPresenter;
import org.picketlink.as.console.client.ui.federation.SAMLConfigurationDetails;

public class NewFederationDetails
implements FormAdapter<Federation> {
    private final Form<Federation> form = new Form(Federation.class);
    private final FederationPresenter presenter;
    private final PicketLinkUIConstants uiConstants;
    private SAMLConfigurationDetails samlConfigurationDetails;
    private TabPanel tabPanel;

    public NewFederationDetails(FederationPresenter presenter, PicketLinkUIConstants uiConstants) {
        this.presenter = presenter;
        this.uiConstants = uiConstants;
    }

    public Widget asWidget() {
        this.tabPanel = new TabPanel();
        this.tabPanel.setStyleName("default-tabpanel");
        this.tabPanel.addStyleName("master_detail-detail");
        VerticalPanel layout = new VerticalPanel();
        TextItem aliasItem = new TextItem("name", this.uiConstants.common_label_federationName());
        this.form.setFields(new FormItem[]{aliasItem});
        this.form.setEnabled(false);
        layout.add(new FormLayout().setTools(null).setForm(this.form).build());
        this.tabPanel.add((Widget)layout, "Attributes");
        this.samlConfigurationDetails = new SAMLConfigurationDetails(this.presenter);
        this.tabPanel.add(this.samlConfigurationDetails.asWidget(), "SAML Configuration");
        this.tabPanel.selectTab(0);
        return this.tabPanel;
    }

    public void bind(CellTable<Federation> instanceTable) {
        this.form.bind(instanceTable);
    }

    public void cancel() {
        this.form.cancel();
    }

    public void edit(Federation bean) {
        this.form.edit((Object)bean);
    }

    public void editTransient(Federation federation) {
        this.form.editTransient((Object)federation);
    }

    public void addEditListener(EditListener listener) {
        this.form.addEditListener(listener);
    }

    public void removeEditListener(EditListener listener) {
        this.form.removeEditListener(listener);
    }

    public void setToolsCallback(FormCallback formCallback) {
        this.form.setToolsCallback(formCallback);
    }

    public Map<String, Object> getChangedValues() {
        return this.form.getChangedValues();
    }

    public Class<?> getConversionType() {
        return Federation.class;
    }

    public Federation getEditedEntity() {
        return (Federation)this.form.getEditedEntity();
    }

    public Federation getUpdatedEntity() {
        return (Federation)this.form.getUpdatedEntity();
    }

    public List<String> getFormItemNames() {
        return this.form.getFormItemNames();
    }

    public String getFormItemTitle(String ref) {
        return this.form.getFormItemTitle(ref);
    }

    public void setEnabled(boolean b) {
        this.form.setEnabled(b);
    }

    public FormValidation validate() {
        return this.form.validate();
    }

    public void addFormValidator(FormValidator formValidator) {
        this.form.addFormValidator(formValidator);
    }

    public void clearValues() {
        this.form.clearValues();
        this.samlConfigurationDetails.setSAMLConfiguration(null);
    }

    public void updateTabs(FederationWrapper federation) {
        this.tabPanel.setVisible(federation != null);
        if (federation != null) {
            this.samlConfigurationDetails.setSAMLConfiguration(federation.getSAMLConfiguration());
        } else {
            this.samlConfigurationDetails.setSAMLConfiguration(null);
        }
    }
}

