/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.console.client.ui.federation.idp;

import java.util.ArrayList;
import org.jboss.ballroom.client.widgets.forms.ComboBoxItem;
import org.jboss.ballroom.client.widgets.forms.FormItem;
import org.jboss.ballroom.client.widgets.forms.TextBoxItem;
import org.picketlink.as.console.client.shared.subsys.model.HandlerTypeEnum;
import org.picketlink.as.console.client.shared.subsys.model.IdentityProviderHandler;
import org.picketlink.as.console.client.ui.federation.AbstractWizard;
import org.picketlink.as.console.client.ui.federation.FederationPresenter;
import org.picketlink.as.console.client.ui.federation.idp.IdentityProviderHandlersTabEditor;

public class NewIdentityProviderHandlerWizard
extends AbstractWizard<IdentityProviderHandler> {
    private final IdentityProviderHandlersTabEditor editor;
    private TextBoxItem className;
    private ComboBoxItem code;

    public NewIdentityProviderHandlerWizard(IdentityProviderHandlersTabEditor editor, FederationPresenter presenter) {
        super(IdentityProviderHandler.class, presenter, new String[]{"identity-provider", "handler"}, "class-name", "code");
        this.editor = editor;
    }

    @Override
    protected void doSaveWizard(IdentityProviderHandler newHandler) {
        String code = newHandler.getCode();
        String className = newHandler.getClassName();
        if (!code.trim().isEmpty() || !className.trim().isEmpty()) {
            if (HandlerTypeEnum.find(code) == null) {
                newHandler.setCode(null);
            } else {
                newHandler.setClassName(null);
            }
            this.getPresenter().getFederationManager().onCreateIdentityProviderHandler(this.editor.getIdentityProvider().getIdentityProvider(), newHandler);
            this.editor.getHandlerTable().getDataProvider().getList().add(newHandler);
        }
    }

    @Override
    protected FormItem<?>[] doGetCustomFields() {
        TextBoxItem name = new TextBoxItem("name", "Name");
        name.setRequired(true);
        this.className = new TextBoxItem("className", "Class Name"){

            public void setUndefined(boolean undefined) {
                NewIdentityProviderHandlerWizard.this.code.setEnabled(undefined);
                NewIdentityProviderHandlerWizard.this.code.setRequired(undefined);
                if (!undefined) {
                    NewIdentityProviderHandlerWizard.this.code.setValue("");
                }
            }
        };
        this.className.setRequired(true);
        this.code = new ComboBoxItem("code", "Code"){

            public void setUndefined(boolean undefined) {
                NewIdentityProviderHandlerWizard.this.className.setEnabled(undefined);
                NewIdentityProviderHandlerWizard.this.className.setRequired(undefined);
                if (!undefined) {
                    NewIdentityProviderHandlerWizard.this.className.setValue("");
                }
            }
        };
        ArrayList<String> handlerTypes = new ArrayList<String>();
        for (HandlerTypeEnum handlerType : HandlerTypeEnum.values()) {
            handlerTypes.add(handlerType.getAlias());
        }
        this.code.setValueMap(handlerTypes);
        return new FormItem[]{name, this.code, this.className};
    }

    @Override
    protected String doGetTitle() {
        return "Add SAML Handler";
    }

    @Override
    public void edit(IdentityProviderHandler object) {
    }
}

