/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.console.client.ui.federation.idp;

import com.google.web.bindery.event.shared.EventBus;
import java.util.List;
import org.jboss.as.console.client.shared.subsys.security.model.SecurityDomain;
import org.jboss.ballroom.client.widgets.forms.CheckBoxItem;
import org.jboss.ballroom.client.widgets.forms.ComboBoxItem;
import org.jboss.ballroom.client.widgets.forms.FormItem;
import org.jboss.ballroom.client.widgets.forms.TextBoxItem;
import org.picketlink.as.console.client.i18n.PicketLinkUIConstants;
import org.picketlink.as.console.client.shared.subsys.model.GenericFederationEntity;
import org.picketlink.as.console.client.ui.federation.AbstractFederationDetailEditor;
import org.picketlink.as.console.client.ui.federation.AbstractFederationWizard;
import org.picketlink.as.console.client.ui.federation.FederationPresenter;
import org.picketlink.as.console.client.ui.federation.Wizard;
import org.picketlink.as.console.client.ui.federation.event.UpdateSecurityDomainEvent;
import org.picketlink.as.console.client.ui.federation.event.UpdateSecurityDomainHandler;

public class NewIdentityProviderWizard<T extends GenericFederationEntity>
extends AbstractFederationWizard<T>
implements Wizard<T> {
    private final EventBus eventBus;
    private TextBoxItem editNameItem;
    private CheckBoxItem externalIDP;
    private CheckBoxItem strictPostBinding;
    private ComboBoxItem securityDomainsItem;
    private PicketLinkUIConstants uiConstants;
    private TextBoxItem url;

    public NewIdentityProviderWizard(AbstractFederationDetailEditor<T> editor, Class<T> cls, FederationPresenter presenter, String type, PicketLinkUIConstants uiConstants, EventBus eventBus) {
        super(editor, cls, presenter, type, "external", "security-domain", "url", "strict-post-binding");
        this.uiConstants = uiConstants;
        this.eventBus = eventBus;
    }

    @Override
    protected FormItem<?>[] doGetCustomFields() {
        FormItem[] formItems = null;
        this.securityDomainsItem = new ComboBoxItem("securityDomain", "Security Domain");
        this.eventBus.addHandler(UpdateSecurityDomainEvent.TYPE, (Object)new UpdateSecurityDomainHandler(){

            @Override
            public void onUpdateSecurityDomain(List<SecurityDomain> securityDomains) {
                NewIdentityProviderWizard.this.updateSecurityDomains(securityDomains);
            }
        });
        this.updateSecurityDomains(this.getPresenter().getSecurityDomains());
        this.strictPostBinding = new CheckBoxItem("strictPostBinding", "Strict Post Binding");
        this.strictPostBinding.setEnabled(true);
        this.url = new TextBoxItem("url", this.uiConstants.common_label_URL(), false);
        if (this.isDialogue()) {
            final TextBoxItem nameItem = new TextBoxItem("name", this.uiConstants.common_label_name());
            nameItem.setRequired(true);
            this.externalIDP = new CheckBoxItem("external", "Is external?"){

                public void setModified(boolean undefined) {
                    if (this.getValue() != null && this.getValue().booleanValue()) {
                        nameItem.setEnabled(false);
                        nameItem.setRequired(false);
                        NewIdentityProviderWizard.this.securityDomainsItem.setEnabled(false);
                        NewIdentityProviderWizard.this.securityDomainsItem.setRequired(false);
                        NewIdentityProviderWizard.this.strictPostBinding.setEnabled(false);
                        NewIdentityProviderWizard.this.strictPostBinding.setRequired(false);
                        NewIdentityProviderWizard.this.url.setRequired(true);
                    } else {
                        nameItem.setEnabled(true);
                        nameItem.setRequired(true);
                        NewIdentityProviderWizard.this.securityDomainsItem.setEnabled(true);
                        NewIdentityProviderWizard.this.securityDomainsItem.setRequired(true);
                        NewIdentityProviderWizard.this.strictPostBinding.setEnabled(true);
                        NewIdentityProviderWizard.this.strictPostBinding.setRequired(true);
                        NewIdentityProviderWizard.this.url.setRequired(false);
                    }
                }
            };
            formItems = new FormItem[]{this.externalIDP, nameItem, this.securityDomainsItem, this.url};
        } else {
            this.editNameItem = new TextBoxItem("name", this.uiConstants.common_label_name());
            this.editNameItem.setEnabled(false);
            formItems = new FormItem[]{this.editNameItem, this.securityDomainsItem, this.url, this.strictPostBinding};
        }
        return formItems;
    }

    private void updateSecurityDomains(List<SecurityDomain> securityDomains) {
        if (securityDomains != null) {
            String[] names = new String[securityDomains.size()];
            for (int i = 0; i < securityDomains.size(); ++i) {
                names[i] = securityDomains.get(i).getName();
            }
            this.securityDomainsItem.setValueMap(names);
            if (!this.isDialogue() && this.getEditor().getCurrentSelection() != null) {
                this.securityDomainsItem.setValue(((GenericFederationEntity)this.getEditor().getCurrentSelection()).getSecurityDomain());
            }
        }
    }
}

