/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.console.client.ui.federation.keystore;

import com.google.gwt.user.client.ui.TabPanel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.console.client.domain.model.SimpleCallback;
import org.jboss.ballroom.client.widgets.forms.TextBoxItem;
import org.picketlink.as.console.client.i18n.PicketLinkUIConstants;
import org.picketlink.as.console.client.i18n.PicketLinkUIMessages;
import org.picketlink.as.console.client.shared.subsys.model.FederationWrapper;
import org.picketlink.as.console.client.shared.subsys.model.KeyStore;
import org.picketlink.as.console.client.shared.subsys.model.KeyStoreWrapper;
import org.picketlink.as.console.client.shared.subsys.model.ServiceProviderWrapper;
import org.picketlink.as.console.client.ui.federation.AbstractFederationDetailEditor;
import org.picketlink.as.console.client.ui.federation.FederationPresenter;
import org.picketlink.as.console.client.ui.federation.Wizard;
import org.picketlink.as.console.client.ui.federation.keystore.KeyEditor;
import org.picketlink.as.console.client.ui.federation.keystore.KeyStoreTable;
import org.picketlink.as.console.client.ui.federation.keystore.NewKeyStoreWizard;

public class KeyStoreEditor
extends AbstractFederationDetailEditor<KeyStore> {
    private PicketLinkUIConstants uiConstants;
    private PicketLinkUIMessages uiMessages;
    private KeyEditor keyEditor;

    public KeyStoreEditor(FederationPresenter presenter, PicketLinkUIConstants uiConstants, PicketLinkUIMessages uiMessages) {
        super(presenter, new KeyStoreTable(presenter), KeyStore.class);
        this.uiConstants = uiConstants;
        this.uiMessages = uiMessages;
    }

    @Override
    public String doGetEntityName() {
        return this.uiConstants.common_label_key_store();
    }

    @Override
    protected String doGetDescription() {
        return this.uiConstants.subsys_picketlink_key_store_desc();
    }

    @Override
    public String doGetTableSectionName() {
        return "Key Stores";
    }

    @Override
    protected boolean doInsert(KeyStore keyStore) {
        if (keyStore.getRelativeTo().trim().length() == 0) {
            keyStore.setRelativeTo(null);
        }
        this.getPresenter().getFederationManager().onCreateKeyStore(keyStore, new SimpleCallback<Boolean>(){

            public void onSuccess(Boolean aBoolean) {
            }
        });
        return true;
    }

    @Override
    protected String doGetName(KeyStore currentSelection) {
        return "Key Store";
    }

    @Override
    protected void addDetailsSectionTabs(TabPanel bottomTabs) {
        bottomTabs.add(this.getKeyEditor().asWidget(), "Host Keys");
    }

    @Override
    protected void doUpdateSelection(KeyStore keyStore) {
    }

    @Override
    protected void doDelete(KeyStore keyStore) {
        FederationPresenter presenter = this.getPresenter();
        FederationWrapper currentFederation = presenter.getCurrentFederation();
        presenter.getFederationManager().onRemoveKeyStore(keyStore);
        if (currentFederation.getIdentityProvider() != null) {
            currentFederation.getIdentityProvider().getIdentityProvider().setSupportsSignatures(true);
            HashMap<String, Object> changedValues = new HashMap<String, Object>();
            changedValues.put("supportsSignatures", "false");
            changedValues.put("encrypt", "false");
            presenter.getFederationManager().onUpdateIdentityProvider(currentFederation.getIdentityProvider().getIdentityProvider(), changedValues);
            List<ServiceProviderWrapper> serviceProviders = currentFederation.getServiceProviders();
            changedValues = new HashMap();
            changedValues.put("supportsSignatures", "false");
            for (ServiceProviderWrapper serviceProvider : serviceProviders) {
                presenter.getFederationManager().onUpdateServiceProvider(serviceProvider.getServiceProvider(), changedValues);
            }
        }
    }

    @Override
    public void doUpdate(KeyStore keyStore, Map<String, Object> changedValues) {
        NewKeyStoreWizard wizard = (NewKeyStoreWizard)this.getWizard();
        TextBoxItem relativeToItem = wizard.getRelativeTo();
        if (relativeToItem.getValue() != null && relativeToItem.getValue().isEmpty()) {
            keyStore.setRelativeTo(null);
        }
        this.getPresenter().getFederationManager().onUpdateKeyStore(keyStore, changedValues);
    }

    @Override
    public Wizard<KeyStore> doCreateWizard() {
        return new NewKeyStoreWizard<KeyStore>(this, this.getEntityClass(), this.getPresenter(), "key-store", this.uiConstants);
    }

    private KeyEditor getKeyEditor() {
        if (this.keyEditor == null) {
            this.keyEditor = new KeyEditor(this.getPresenter(), this.uiConstants);
        }
        return this.keyEditor;
    }

    public void updateKeyStore(FederationWrapper federation) {
        if (federation != null) {
            ArrayList<KeyStore> keyStores = new ArrayList<KeyStore>();
            if (!federation.getKeyStores().isEmpty()) {
                KeyStoreWrapper keyStoreWrapper = federation.getKeyStores().get(0);
                keyStores.add(keyStoreWrapper.getKeyStore());
                this.getKeyEditor().setEnabled(true);
                this.getKeyEditor().getKeyTable().setList(keyStoreWrapper.getKeys());
            } else {
                this.getKeyEditor().setEnabled(false);
                this.getKeyEditor().getKeyTable().setList(new ArrayList());
            }
            this.setData(federation, keyStores);
        }
    }
}

