/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.social.auth;

import java.security.Principal;
import java.security.acl.Group;
import java.util.List;
import javax.security.auth.login.LoginException;
import org.jboss.security.SimpleGroup;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.auth.spi.UsernamePasswordLoginModule;
import org.picketlink.social.facebook.FacebookProcessor;
import org.picketlink.social.openid.auth.OpenIDProcessor;

public class ExternalAuthLoginModule
extends UsernamePasswordLoginModule {
    protected Principal getIdentity() {
        Principal principal = null;
        principal = FacebookProcessor.cachedPrincipal.get();
        if (principal == null) {
            principal = OpenIDProcessor.cachedPrincipal.get();
        }
        return principal;
    }

    protected String getUsersPassword() throws LoginException {
        return OpenIDProcessor.EMPTY_PASSWORD;
    }

    protected Group[] getRoleSets() throws LoginException {
        SimpleGroup group = new SimpleGroup("Roles");
        List<String> roles = OpenIDProcessor.cachedRoles.get();
        if (roles != null) {
            for (String role : roles) {
                group.addMember((Principal)new SimplePrincipal(role));
            }
        }
        if ((roles = FacebookProcessor.cachedRoles.get()) != null) {
            for (String role : roles) {
                SimplePrincipal rolePrincipal = new SimplePrincipal(role);
                if (group.isMember((Principal)rolePrincipal)) continue;
                group.addMember((Principal)rolePrincipal);
            }
        }
        return new Group[]{group};
    }
}

