/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.social.openid.servlets;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class OpenIDYadisServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private String yadisResourceFile = "/WEB-INF/openid-yadis.xml";
    private String yadisURL = null;
    private boolean supportHTTP_HEAD = false;
    private transient InputStream yadisResourceInputStream = null;

    public void init(ServletConfig config) throws ServletException {
        String supportHead;
        super.init(config);
        ServletContext context = config.getServletContext();
        String yadisResourceFileStr = config.getInitParameter("yadisResourceFile");
        if (yadisResourceFileStr != null && yadisResourceFileStr.length() > 0) {
            this.yadisResourceFile = yadisResourceFileStr;
        }
        this.log("yadisResourceFile Location=" + this.yadisResourceFile);
        this.yadisURL = config.getInitParameter("yadisResourceURL");
        if (this.yadisURL == null || this.yadisURL.length() == 0) {
            this.yadisResourceInputStream = context.getResourceAsStream(this.yadisResourceFile);
            if (this.yadisResourceInputStream == null) {
                throw new RuntimeException("yadisResourceFile is missing");
            }
        }
        if ((supportHead = config.getInitParameter("support_HTTP_HEAD")) != null && supportHead.length() > 0) {
            this.supportHTTP_HEAD = Boolean.parseBoolean(supportHead);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.supportHTTP_HEAD) {
            this.log("GET not supported as HTTP HEAD has been configured");
            resp.sendError(405);
            return;
        }
        if (this.yadisResourceInputStream == null) {
            this.log("ERROR::yadisResourceInputStream is null");
            resp.sendError(500);
            return;
        }
        byte[] barr = new byte[1024];
        int i = 0;
        while (i < barr.length) {
            int b = this.yadisResourceInputStream.read();
            if (b == -1) break;
            barr[i] = (byte)b;
            ++i;
        }
        resp.setContentType("application/xrds+xml");
        resp.setStatus(200);
        ServletOutputStream os = resp.getOutputStream();
        os.write(barr);
        os.flush();
        os.close();
    }

    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.supportHTTP_HEAD) {
            resp.addHeader("X-XRDS-Location", this.yadisURL);
        }
        resp.setStatus(200);
    }
}

