/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.social.facebook;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Realm;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import org.picketlink.social.facebook.FacebookPrincipal;
import org.picketlink.social.facebook.FacebookUtil;
import org.picketlink.social.facebook.SecurityActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacebookProcessor {
    protected static Logger log = Logger.getLogger(FacebookProcessor.class);
    protected boolean trace = log.isTraceEnabled();
    protected FacebookUtil util = new FacebookUtil("https://www.facebook.com/dialog/oauth");
    public static ThreadLocal<Principal> cachedPrincipal = new ThreadLocal();
    public static ThreadLocal<List<String>> cachedRoles = new ThreadLocal();
    public static String EMPTY_PASSWORD = "EMPTY";
    protected List<String> roles = new ArrayList<String>();
    protected String clientID;
    protected String clientSecret;
    protected String scope;
    private String returnURL;

    public FacebookProcessor(String clientID, String clientSecret, String scope, String returnURL, List<String> requiredRoles) {
        this.clientID = clientID;
        this.clientSecret = clientSecret;
        this.scope = scope;
        this.returnURL = returnURL;
        this.roles.addAll(requiredRoles);
    }

    public void setRoleString(String roleStr) {
        if (roleStr == null) {
            throw new RuntimeException("Role String is null in configuration");
        }
        StringTokenizer st = new StringTokenizer(roleStr, ",");
        while (st.hasMoreElements()) {
            this.roles.add(st.nextToken());
        }
    }

    public boolean initialInteraction(Request request, Response response) throws IOException {
        HttpSession session = request.getSession();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("redirect_uri", this.returnURL);
        params.put("client_id", this.clientID);
        if (this.scope != null) {
            params.put("scope", this.scope);
        }
        String location = "https://www.facebook.com/dialog/oauth" + "?" + this.util.createQueryString(params);
        try {
            session.setAttribute("STATE", (Object)STATES.AUTH.name());
            if (this.trace) {
                log.trace((Object)("Redirect:" + location));
            }
            response.sendRedirect(location);
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean handleAuthStage(HttpServletRequest request, HttpServletResponse response) {
        request.getSession().setAttribute("STATE", (Object)STATES.AUTHZ.name());
        this.sendAuthorizeRequest(this.returnURL, response);
        return false;
    }

    protected void sendAuthorizeRequest(String returnUrl, HttpServletResponse response) {
        String returnUri = returnUrl;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("redirect_uri", returnUri);
        params.put("client_id", this.clientID);
        if (this.scope != null) {
            params.put("scope", this.scope);
        }
        String location = "https://graph.facebook.com/oauth/authorize" + "?" + this.util.createQueryString(params);
        try {
            response.sendRedirect(location);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Principal getPrincipal(Request request, Response response, Realm realm) {
        Principal principal = null;
        Principal facebookPrincipal = this.handleAuthenticationResponse((HttpServletRequest)request, (HttpServletResponse)response);
        request.getSession().setAttribute("PRINCIPAL", (Object)facebookPrincipal);
        cachedPrincipal.set(facebookPrincipal);
        if (this.isJBossEnv()) {
            cachedRoles.set(this.roles);
            principal = realm.authenticate(facebookPrincipal.getName(), EMPTY_PASSWORD);
        } else {
            principal = new GenericPrincipal(realm, facebookPrincipal.getName(), null, this.roles, facebookPrincipal);
        }
        return principal;
    }

    protected Principal handleAuthenticationResponse(HttpServletRequest request, HttpServletResponse response) {
        String error = request.getParameter("error");
        if (error != null) {
            throw new RuntimeException("error:" + error);
        }
        String returnUrl = this.returnURL;
        String authorizationCode = request.getParameter("code");
        if (authorizationCode == null) {
            throw new RuntimeException("Authorization code parameter not found");
        }
        URLConnection connection = this.sendAccessTokenRequest(returnUrl, authorizationCode, response);
        Map<String, String> params = this.formUrlDecode(this.readUrlContent(connection));
        String accessToken = params.get("access_token");
        String expires = params.get("expires");
        if (this.trace) {
            log.trace((Object)("Access Token=" + accessToken + " :: Expires=" + expires));
        }
        if (accessToken == null) {
            throw new RuntimeException("No access token found");
        }
        return this.readInIdentity(request, response, accessToken, returnUrl);
    }

    protected URLConnection sendAccessTokenRequest(String returnUrl, String authorizationCode, HttpServletResponse response) {
        String returnUri = this.returnURL;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("redirect_uri", returnUri);
        params.put("client_id", this.clientID);
        params.put("client_secret", this.clientSecret);
        params.put("code", authorizationCode);
        String location = "https://graph.facebook.com/oauth/access_token" + "?" + this.util.createQueryString(params);
        try {
            if (this.trace) {
                log.trace((Object)("AccessToken Request=" + location));
            }
            URL url = new URL(location);
            URLConnection connection = url.openConnection();
            return connection;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isJBossEnv() {
        ClassLoader tcl = SecurityActions.getContextClassLoader();
        Class<?> clazz = null;
        try {
            clazz = tcl.loadClass("org.jboss.system.Service");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return clazz != null;
    }

    private Principal readInIdentity(HttpServletRequest request, HttpServletResponse response, String accessToken, String returnUrl) {
        FacebookPrincipal facebookPrincipal = null;
        try {
            String urlString = "https://graph.facebook.com/me" + "?access_token=" + URLEncoder.encode(accessToken, "UTF-8");
            if (this.trace) {
                log.trace((Object)("Profile read:" + urlString));
            }
            URL profileUrl = new URL(urlString);
            String profileContent = this.readUrlContent(profileUrl.openConnection());
            JSONObject jsonObject = new JSONObject(profileContent);
            facebookPrincipal = new FacebookPrincipal();
            facebookPrincipal.setAccessToken(accessToken);
            facebookPrincipal.setId(jsonObject.getString("id"));
            facebookPrincipal.setName(jsonObject.getString("name"));
            facebookPrincipal.setFirstName(jsonObject.getString("first_name"));
            facebookPrincipal.setLastName(jsonObject.getString("last_name"));
            facebookPrincipal.setGender(jsonObject.getString("gender"));
            facebookPrincipal.setTimezone(jsonObject.getString("timezone"));
            facebookPrincipal.setLocale(jsonObject.getString("locale"));
            if (jsonObject.getString("email") != null) {
                facebookPrincipal.setEmail(jsonObject.getString("email"));
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return facebookPrincipal;
    }

    private String readUrlContent(URLConnection connection) {
        StringBuilder result = new StringBuilder();
        try {
            int nrOfChars;
            InputStreamReader reader = new InputStreamReader(connection.getInputStream());
            char[] buffer = new char[50];
            while ((nrOfChars = reader.read(buffer)) != -1) {
                result.append(buffer, 0, nrOfChars);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result.toString();
    }

    private Map<String, String> formUrlDecode(String encodedData) {
        String[] elements;
        HashMap<String, String> params = new HashMap<String, String>();
        for (String element : elements = encodedData.split("&")) {
            String paramValue;
            String paramName;
            String[] pair = element.split("=");
            if (pair.length == 2) {
                paramName = pair[0];
                try {
                    paramValue = URLDecoder.decode(pair[1], "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            } else {
                throw new RuntimeException("Unexpected name-value pair in response: " + element);
            }
            params.put(paramName, paramValue);
        }
        return params;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum STATES {
        AUTH,
        AUTHZ,
        FINISH;

    }
}

