/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.parsers.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.constants.JBossSAMLConstants;
import org.picketlink.common.constants.JBossSAMLURIConstants;
import org.picketlink.common.exceptions.ParsingException;
import org.picketlink.common.util.StaxParserUtil;
import org.picketlink.common.util.StringUtil;
import org.picketlink.identity.federation.core.saml.v2.util.SignatureUtil;
import org.picketlink.identity.federation.core.saml.v2.util.XMLTimeUtil;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeStatementType;
import org.picketlink.identity.federation.saml.v2.assertion.AttributeType;
import org.picketlink.identity.federation.saml.v2.assertion.AuthnContextClassRefType;
import org.picketlink.identity.federation.saml.v2.assertion.AuthnContextDeclRefType;
import org.picketlink.identity.federation.saml.v2.assertion.AuthnContextDeclType;
import org.picketlink.identity.federation.saml.v2.assertion.AuthnContextType;
import org.picketlink.identity.federation.saml.v2.assertion.AuthnStatementType;
import org.picketlink.identity.federation.saml.v2.assertion.NameIDType;
import org.picketlink.identity.federation.saml.v2.assertion.SubjectLocalityType;
import org.picketlink.identity.xmlsec.w3.xmldsig.DSAKeyValueType;
import org.picketlink.identity.xmlsec.w3.xmldsig.KeyInfoType;
import org.picketlink.identity.xmlsec.w3.xmldsig.KeyValueType;
import org.picketlink.identity.xmlsec.w3.xmldsig.RSAKeyValueType;
import org.picketlink.identity.xmlsec.w3.xmldsig.X509CertificateType;
import org.picketlink.identity.xmlsec.w3.xmldsig.X509DataType;
import org.w3c.dom.Element;

public class SAMLParserUtil {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();

    public static KeyInfoType parseKeyInfo(XMLEventReader xmlEventReader) throws ParsingException {
        KeyInfoType keyInfo = new KeyInfoType();
        StartElement startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
        StaxParserUtil.validate((StartElement)startElement, (String)"KeyInfo");
        XMLEvent xmlEvent = null;
        String tag = null;
        while (xmlEventReader.hasNext()) {
            xmlEvent = StaxParserUtil.peek((XMLEventReader)xmlEventReader);
            if (xmlEvent instanceof EndElement) {
                tag = StaxParserUtil.getEndElementName((EndElement)((EndElement)xmlEvent));
                if (tag.equals("KeyInfo")) {
                    xmlEvent = StaxParserUtil.getNextEndElement((XMLEventReader)xmlEventReader);
                    break;
                }
                throw logger.parserUnknownEndElement(tag);
            }
            startElement = (StartElement)xmlEvent;
            tag = StaxParserUtil.getStartElementName((StartElement)startElement);
            if (tag.equals("EncryptedKey")) {
                keyInfo.addContent(StaxParserUtil.getDOMElement((XMLEventReader)xmlEventReader));
                continue;
            }
            if (tag.equals("X509Data")) {
                startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                X509DataType x509 = new X509DataType();
                startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                StaxParserUtil.validate((StartElement)startElement, (String)"X509Certificate");
                X509CertificateType cert = new X509CertificateType();
                String certValue = StaxParserUtil.getElementText((XMLEventReader)xmlEventReader);
                cert.setEncodedCertificate(certValue.getBytes());
                x509.add(cert);
                EndElement endElement = StaxParserUtil.getNextEndElement((XMLEventReader)xmlEventReader);
                StaxParserUtil.validate((EndElement)endElement, (String)"X509Data");
                keyInfo.addContent(x509);
                continue;
            }
            if (!tag.equals("KeyValue")) continue;
            startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
            KeyValueType keyValue = null;
            startElement = StaxParserUtil.peekNextStartElement((XMLEventReader)xmlEventReader);
            tag = StaxParserUtil.getStartElementName((StartElement)startElement);
            if (tag.equals("RSAKeyValue")) {
                keyValue = SAMLParserUtil.parseRSAKeyValue(xmlEventReader);
            } else if (tag.equals("DSAKeyValue")) {
                keyValue = SAMLParserUtil.parseDSAKeyValue(xmlEventReader);
            } else {
                throw logger.parserUnknownTag(tag, startElement.getLocation());
            }
            EndElement endElement = StaxParserUtil.getNextEndElement((XMLEventReader)xmlEventReader);
            StaxParserUtil.validate((EndElement)endElement, (String)"KeyValue");
            keyInfo.addContent(keyValue);
        }
        return keyInfo;
    }

    private static RSAKeyValueType parseRSAKeyValue(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
        StaxParserUtil.validate((StartElement)startElement, (String)"RSAKeyValue");
        XMLEvent xmlEvent = null;
        String tag = null;
        RSAKeyValueType rsaKeyValue = new RSAKeyValueType();
        while (xmlEventReader.hasNext()) {
            String text;
            xmlEvent = StaxParserUtil.peek((XMLEventReader)xmlEventReader);
            if (xmlEvent instanceof EndElement) {
                tag = StaxParserUtil.getEndElementName((EndElement)((EndElement)xmlEvent));
                if (tag.equals("RSAKeyValue")) {
                    xmlEvent = StaxParserUtil.getNextEndElement((XMLEventReader)xmlEventReader);
                    break;
                }
                throw logger.parserUnknownEndElement(tag);
            }
            startElement = (StartElement)xmlEvent;
            tag = StaxParserUtil.getStartElementName((StartElement)startElement);
            if (tag.equals("Modulus")) {
                startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                text = StaxParserUtil.getElementText((XMLEventReader)xmlEventReader);
                rsaKeyValue.setModulus(text.getBytes());
                continue;
            }
            if (tag.equals("Exponent")) {
                startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                text = StaxParserUtil.getElementText((XMLEventReader)xmlEventReader);
                rsaKeyValue.setExponent(text.getBytes());
                continue;
            }
            throw logger.parserUnknownTag(tag, startElement.getLocation());
        }
        return rsaKeyValue;
    }

    private static DSAKeyValueType parseDSAKeyValue(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement startElement = StaxParserUtil.peekNextStartElement((XMLEventReader)xmlEventReader);
        StaxParserUtil.validate((StartElement)startElement, (String)"DSAKeyValue");
        Element dsaElement = StaxParserUtil.getDOMElement((XMLEventReader)xmlEventReader);
        return SignatureUtil.getDSAKeyValue(dsaElement);
    }

    public static AttributeStatementType parseAttributeStatement(XMLEventReader xmlEventReader) throws ParsingException {
        AttributeStatementType attributeStatementType = new AttributeStatementType();
        StartElement startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
        String ATTRIBSTATEMT = JBossSAMLConstants.ATTRIBUTE_STATEMENT.get();
        StaxParserUtil.validate((StartElement)startElement, (String)ATTRIBSTATEMT);
        while (xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = StaxParserUtil.peek((XMLEventReader)xmlEventReader);
            if (xmlEvent instanceof EndElement) {
                EndElement endElement = StaxParserUtil.getNextEndElement((XMLEventReader)xmlEventReader);
                StaxParserUtil.validate((EndElement)endElement, (String)JBossSAMLConstants.ATTRIBUTE_STATEMENT.get());
                break;
            }
            startElement = StaxParserUtil.peekNextStartElement((XMLEventReader)xmlEventReader);
            String tag = startElement.getName().getLocalPart();
            if (JBossSAMLConstants.ATTRIBUTE.get().equals(tag)) {
                AttributeType attribute = SAMLParserUtil.parseAttribute(xmlEventReader);
                attributeStatementType.addAttribute(new AttributeStatementType.ASTChoiceType(attribute));
                continue;
            }
            throw logger.parserUnknownTag(tag, startElement.getLocation());
        }
        return attributeStatementType;
    }

    public static AttributeType parseAttribute(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
        StaxParserUtil.validate((StartElement)startElement, (String)JBossSAMLConstants.ATTRIBUTE.get());
        AttributeType attributeType = null;
        Attribute name = startElement.getAttributeByName(new QName(JBossSAMLConstants.NAME.get()));
        if (name == null) {
            throw logger.parserRequiredAttribute("Name");
        }
        attributeType = new AttributeType(StaxParserUtil.getAttributeValue((Attribute)name));
        SAMLParserUtil.parseAttributeType(xmlEventReader, startElement, JBossSAMLConstants.ATTRIBUTE.get(), attributeType);
        return attributeType;
    }

    public static void parseAttributeType(XMLEventReader xmlEventReader, StartElement startElement, String rootTag, AttributeType attributeType) throws ParsingException {
        EndElement end;
        XMLEvent xmlEvent;
        Attribute nameFormat;
        Attribute friendlyName;
        QName x500EncodingName = new QName(JBossSAMLURIConstants.X500_NSURI.get(), JBossSAMLConstants.ENCODING.get(), JBossSAMLURIConstants.X500_PREFIX.get());
        Attribute x500EncodingAttr = startElement.getAttributeByName(x500EncodingName);
        if (x500EncodingAttr != null) {
            attributeType.getOtherAttributes().put(x500EncodingAttr.getName(), StaxParserUtil.getAttributeValue((Attribute)x500EncodingAttr));
        }
        if ((friendlyName = startElement.getAttributeByName(new QName(JBossSAMLConstants.FRIENDLY_NAME.get()))) != null) {
            attributeType.setFriendlyName(StaxParserUtil.getAttributeValue((Attribute)friendlyName));
        }
        if ((nameFormat = startElement.getAttributeByName(new QName(JBossSAMLConstants.NAME_FORMAT.get()))) != null) {
            attributeType.setNameFormat(StaxParserUtil.getAttributeValue((Attribute)nameFormat));
        }
        while (!(!xmlEventReader.hasNext() || (xmlEvent = StaxParserUtil.peek((XMLEventReader)xmlEventReader)) instanceof EndElement && StaxParserUtil.matches((EndElement)(end = StaxParserUtil.getNextEndElement((XMLEventReader)xmlEventReader)), (String)rootTag) || (startElement = StaxParserUtil.peekNextStartElement((XMLEventReader)xmlEventReader)) == null)) {
            String tag = StaxParserUtil.getStartElementName((StartElement)startElement);
            if (JBossSAMLConstants.ATTRIBUTE.get().equals(tag)) break;
            if (JBossSAMLConstants.ATTRIBUTE_VALUE.get().equals(tag)) {
                Object attributeValue = SAMLParserUtil.parseAttributeValue(xmlEventReader);
                attributeType.addAttributeValue(attributeValue);
                continue;
            }
            throw logger.parserUnknownTag(tag, startElement.getLocation());
        }
    }

    public static Object parseAttributeValue(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
        StaxParserUtil.validate((StartElement)startElement, (String)JBossSAMLConstants.ATTRIBUTE_VALUE.get());
        Attribute type = startElement.getAttributeByName(new QName(JBossSAMLURIConstants.XSI_NSURI.get(), "type", "xsi"));
        if (type == null) {
            String tag;
            if (StaxParserUtil.hasTextAhead((XMLEventReader)xmlEventReader)) {
                return StaxParserUtil.getElementText((XMLEventReader)xmlEventReader);
            }
            XMLEvent xmlEvent = StaxParserUtil.peek((XMLEventReader)xmlEventReader);
            if (xmlEvent instanceof StartElement && (tag = StaxParserUtil.getStartElementName((StartElement)(startElement = (StartElement)xmlEvent))).equals(JBossSAMLConstants.NAMEID.get())) {
                return SAMLParserUtil.parseNameIDType(xmlEventReader);
            }
            throw logger.unsupportedType(StaxParserUtil.getStartElementName((StartElement)startElement));
        }
        String typeValue = StaxParserUtil.getAttributeValue((Attribute)type);
        if (typeValue.contains(":string")) {
            return StaxParserUtil.getElementText((XMLEventReader)xmlEventReader);
        }
        if (typeValue.contains(":anyType")) {
            return StaxParserUtil.getElementText((XMLEventReader)xmlEventReader);
        }
        throw logger.parserUnknownXSI(typeValue);
    }

    public static AuthnStatementType parseAuthnStatement(XMLEventReader xmlEventReader) throws ParsingException {
        XMLEvent xmlEvent;
        StartElement startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
        String AUTHNSTATEMENT = JBossSAMLConstants.AUTHN_STATEMENT.get();
        StaxParserUtil.validate((StartElement)startElement, (String)AUTHNSTATEMENT);
        Attribute authnInstant = startElement.getAttributeByName(new QName("AuthnInstant"));
        if (authnInstant == null) {
            throw logger.parserRequiredAttribute("AuthnInstant");
        }
        XMLGregorianCalendar issueInstant = XMLTimeUtil.parse(StaxParserUtil.getAttributeValue((Attribute)authnInstant));
        AuthnStatementType authnStatementType = new AuthnStatementType(issueInstant);
        Attribute sessionIndex = startElement.getAttributeByName(new QName("SessionIndex"));
        if (sessionIndex != null) {
            authnStatementType.setSessionIndex(StaxParserUtil.getAttributeValue((Attribute)sessionIndex));
        }
        while (xmlEventReader.hasNext() && (xmlEvent = StaxParserUtil.peek((XMLEventReader)xmlEventReader)) != null) {
            if (xmlEvent instanceof EndElement) {
                xmlEvent = StaxParserUtil.getNextEvent((XMLEventReader)xmlEventReader);
                EndElement endElement = (EndElement)xmlEvent;
                String endElementTag = StaxParserUtil.getEndElementName((EndElement)endElement);
                if (endElementTag.equals(AUTHNSTATEMENT)) break;
                throw logger.parserUnknownEndElement(endElementTag);
            }
            startElement = null;
            startElement = xmlEvent instanceof StartElement ? (StartElement)xmlEvent : StaxParserUtil.peekNextStartElement((XMLEventReader)xmlEventReader);
            if (startElement == null) break;
            String tag = StaxParserUtil.getStartElementName((StartElement)startElement);
            if (JBossSAMLConstants.SUBJECT_LOCALITY.get().equals(tag)) {
                Attribute dns;
                startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                SubjectLocalityType subjectLocalityType = new SubjectLocalityType();
                Attribute address = startElement.getAttributeByName(new QName(JBossSAMLConstants.ADDRESS.get()));
                if (address != null) {
                    subjectLocalityType.setAddress(StaxParserUtil.getAttributeValue((Attribute)address));
                }
                if ((dns = startElement.getAttributeByName(new QName(JBossSAMLConstants.DNS_NAME.get()))) != null) {
                    subjectLocalityType.setDNSName(StaxParserUtil.getAttributeValue((Attribute)dns));
                }
                authnStatementType.setSubjectLocality(subjectLocalityType);
                StaxParserUtil.validate((EndElement)StaxParserUtil.getNextEndElement((XMLEventReader)xmlEventReader), (String)JBossSAMLConstants.SUBJECT_LOCALITY.get());
                continue;
            }
            if (JBossSAMLConstants.AUTHN_CONTEXT.get().equals(tag)) {
                authnStatementType.setAuthnContext(SAMLParserUtil.parseAuthnContextType(xmlEventReader));
                continue;
            }
            throw logger.parserUnknownTag(tag, startElement.getLocation());
        }
        return authnStatementType;
    }

    public static AuthnContextType parseAuthnContextType(XMLEventReader xmlEventReader) throws ParsingException {
        XMLEvent xmlEvent;
        AuthnContextType authnContextType = new AuthnContextType();
        StartElement startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
        StaxParserUtil.validate((StartElement)startElement, (String)JBossSAMLConstants.AUTHN_CONTEXT.get());
        while (xmlEventReader.hasNext() && (xmlEvent = StaxParserUtil.peek((XMLEventReader)xmlEventReader)) != null) {
            String text;
            AuthnContextType.AuthnContextTypeSequence authnContextSequence;
            if (xmlEvent instanceof EndElement) {
                xmlEvent = StaxParserUtil.getNextEvent((XMLEventReader)xmlEventReader);
                EndElement endElement = (EndElement)xmlEvent;
                String endElementTag = StaxParserUtil.getEndElementName((EndElement)endElement);
                if (endElementTag.equals(JBossSAMLConstants.AUTHN_CONTEXT.get())) break;
                throw logger.parserUnknownEndElement(endElementTag);
            }
            startElement = null;
            startElement = xmlEvent instanceof StartElement ? (StartElement)xmlEvent : StaxParserUtil.peekNextStartElement((XMLEventReader)xmlEventReader);
            if (startElement == null) break;
            String tag = StaxParserUtil.getStartElementName((StartElement)startElement);
            if (JBossSAMLConstants.AUTHN_CONTEXT_DECLARATION.get().equals(tag)) {
                startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                Element dom = StaxParserUtil.getDOMElement((XMLEventReader)xmlEventReader);
                AuthnContextDeclType authnContextDecl = new AuthnContextDeclType(dom);
                authnContextSequence = new AuthnContextType.AuthnContextTypeSequence(authnContextType);
                authnContextSequence.setAuthnContextDecl(authnContextDecl);
                authnContextType.setSequence(authnContextSequence);
                EndElement endElement = StaxParserUtil.getNextEndElement((XMLEventReader)xmlEventReader);
                StaxParserUtil.validate((EndElement)endElement, (String)JBossSAMLConstants.AUTHN_CONTEXT_DECLARATION.get());
                continue;
            }
            if (JBossSAMLConstants.AUTHN_CONTEXT_DECLARATION_REF.get().equals(tag)) {
                startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                text = StaxParserUtil.getElementText((XMLEventReader)xmlEventReader);
                AuthnContextDeclRefType aAuthnContextDeclType = new AuthnContextDeclRefType(URI.create(text));
                authnContextType.addURIType(aAuthnContextDeclType);
                continue;
            }
            if (JBossSAMLConstants.AUTHN_CONTEXT_CLASS_REF.get().equals(tag)) {
                startElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
                text = StaxParserUtil.getElementText((XMLEventReader)xmlEventReader);
                AuthnContextClassRefType aAuthnContextClassRefType = new AuthnContextClassRefType(URI.create(text));
                authnContextSequence = new AuthnContextType.AuthnContextTypeSequence(authnContextType);
                authnContextSequence.setClassRef(aAuthnContextClassRefType);
                authnContextType.setSequence(authnContextSequence);
                continue;
            }
            throw logger.parserUnknownTag(tag, startElement.getLocation());
        }
        return authnContextType;
    }

    public static NameIDType parseNameIDType(XMLEventReader xmlEventReader) throws ParsingException {
        Attribute spNameQualifier;
        Attribute spProvidedID;
        Attribute format;
        StartElement nameIDElement = StaxParserUtil.getNextStartElement((XMLEventReader)xmlEventReader);
        NameIDType nameID = new NameIDType();
        Attribute nameQualifier = nameIDElement.getAttributeByName(new QName(JBossSAMLConstants.NAME_QUALIFIER.get()));
        if (nameQualifier != null) {
            nameID.setNameQualifier(StaxParserUtil.getAttributeValue((Attribute)nameQualifier));
        }
        if ((format = nameIDElement.getAttributeByName(new QName(JBossSAMLConstants.FORMAT.get()))) != null) {
            nameID.setFormat(URI.create(StaxParserUtil.getAttributeValue((Attribute)format)));
        }
        if ((spProvidedID = nameIDElement.getAttributeByName(new QName(JBossSAMLConstants.SP_PROVIDED_ID.get()))) != null) {
            nameID.setSPProvidedID(StaxParserUtil.getAttributeValue((Attribute)spProvidedID));
        }
        if ((spNameQualifier = nameIDElement.getAttributeByName(new QName(JBossSAMLConstants.SP_NAME_QUALIFIER.get()))) != null) {
            nameID.setSPNameQualifier(StaxParserUtil.getAttributeValue((Attribute)spNameQualifier));
        }
        String nameIDValue = StaxParserUtil.getElementText((XMLEventReader)xmlEventReader);
        nameID.setValue(nameIDValue);
        return nameID;
    }

    public static List<String> parseProtocolEnumeration(StartElement startElement) {
        ArrayList<String> protocolEnum = new ArrayList<String>();
        Attribute proto = startElement.getAttributeByName(new QName(JBossSAMLConstants.PROTOCOL_SUPPORT_ENUMERATION.get()));
        String val = StaxParserUtil.getAttributeValue((Attribute)proto);
        if (StringUtil.isNotNull((String)val)) {
            StringTokenizer st = new StringTokenizer(val);
            while (st.hasMoreTokens()) {
                protocolEnum.add(st.nextToken());
            }
        }
        return protocolEnum;
    }
}

