/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.util;

import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.servlet.ServletContext;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.constants.JBossSAMLURIConstants;
import org.picketlink.common.exceptions.ConfigurationException;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.common.util.PBEUtils;
import org.picketlink.common.util.StringUtil;
import org.picketlink.config.federation.AuthPropertyType;
import org.picketlink.config.federation.ClaimsProcessorType;
import org.picketlink.config.federation.IDPType;
import org.picketlink.config.federation.KeyProviderType;
import org.picketlink.config.federation.KeyValueType;
import org.picketlink.config.federation.MetadataProviderType;
import org.picketlink.config.federation.ProviderType;
import org.picketlink.config.federation.SPType;
import org.picketlink.config.federation.TokenProviderType;
import org.picketlink.identity.federation.core.interfaces.IMetadataProvider;
import org.picketlink.identity.federation.core.interfaces.TrustKeyManager;
import org.picketlink.identity.federation.core.util.SecurityActions;
import org.picketlink.identity.federation.saml.v2.metadata.EndpointType;
import org.picketlink.identity.federation.saml.v2.metadata.EntitiesDescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.EntityDescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.IDPSSODescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.IndexedEndpointType;
import org.picketlink.identity.federation.saml.v2.metadata.SPSSODescriptorType;

public class CoreConfigUtil {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();

    public static TrustKeyManager getTrustKeyManager(ProviderType idpOrSPConfiguration) {
        KeyProviderType keyProvider = idpOrSPConfiguration.getKeyProvider();
        return CoreConfigUtil.getTrustKeyManager(keyProvider);
    }

    public static TrustKeyManager getTrustKeyManager(KeyProviderType keyProvider) {
        TrustKeyManager trustKeyManager = null;
        try {
            String keyManagerClassName = keyProvider.getClassName();
            if (keyManagerClassName == null) {
                throw logger.nullValueError("KeyManager class name");
            }
            Class<?> clazz = SecurityActions.loadClass(CoreConfigUtil.class, keyManagerClassName);
            if (clazz == null) {
                throw logger.classNotLoadedError(keyManagerClassName);
            }
            trustKeyManager = (TrustKeyManager)clazz.newInstance();
        }
        catch (Exception e) {
            logger.trustKeyManagerCreationError((Throwable)e);
        }
        return trustKeyManager;
    }

    public static PublicKey getValidatingKey(ProviderType idpSpConfiguration, String domain) throws ConfigurationException, ProcessingException {
        TrustKeyManager trustKeyManager = CoreConfigUtil.getTrustKeyManager(idpSpConfiguration);
        return CoreConfigUtil.getValidatingKey(trustKeyManager, domain);
    }

    public static PublicKey getValidatingKey(TrustKeyManager trustKeyManager, String domain) throws ConfigurationException, ProcessingException {
        if (trustKeyManager == null) {
            throw logger.nullValueError("Trust Key Manager");
        }
        return trustKeyManager.getValidatingKey(domain);
    }

    public static List<AuthPropertyType> getKeyProviderProperties(KeyProviderType keyProviderType) throws GeneralSecurityException {
        List authProperties = keyProviderType.getAuth();
        if (CoreConfigUtil.decryptionNeeded(authProperties)) {
            authProperties = CoreConfigUtil.decryptPasswords(authProperties);
        }
        return authProperties;
    }

    public static List<KeyValueType> getProperties(TokenProviderType tokenProviderType) throws GeneralSecurityException {
        List keyValueTypeList = tokenProviderType.getProperty();
        if (CoreConfigUtil.decryptionNeeded(keyValueTypeList)) {
            keyValueTypeList = CoreConfigUtil.decryptPasswords(keyValueTypeList);
        }
        return keyValueTypeList;
    }

    public static List<KeyValueType> getProperties(ClaimsProcessorType claimsProcessorType) throws GeneralSecurityException {
        List keyValueTypeList = claimsProcessorType.getProperty();
        if (CoreConfigUtil.decryptionNeeded(keyValueTypeList)) {
            keyValueTypeList = CoreConfigUtil.decryptPasswords(keyValueTypeList);
        }
        return keyValueTypeList;
    }

    public static boolean decryptionNeeded(List<? extends KeyValueType> keyValueList) {
        int length = keyValueList.size();
        for (int i = 0; i < length; ++i) {
            KeyValueType kvt = keyValueList.get(i);
            String key = kvt.getKey();
            if (!"salt".equalsIgnoreCase(key)) continue;
            return true;
        }
        return false;
    }

    private static List decryptPasswords(List keyValueList) throws GeneralSecurityException {
        String pbeAlgo = "PBEwithMD5andDES";
        String salt = null;
        int iterationCount = 0;
        int length = keyValueList.size();
        for (int i = 0; i < length; ++i) {
            KeyValueType kvt = (KeyValueType)keyValueList.get(i);
            String key = kvt.getKey();
            if ("salt".equalsIgnoreCase(key)) {
                salt = kvt.getValue();
            }
            if (!"iterationCount".equalsIgnoreCase(key)) continue;
            iterationCount = Integer.parseInt(kvt.getValue());
        }
        if (salt == null) {
            return keyValueList;
        }
        ArrayList<KeyValueType> returningList = new ArrayList<KeyValueType>();
        SecretKeyFactory factory = SecretKeyFactory.getInstance(pbeAlgo);
        char[] password = "somearbitrarycrazystringthatdoesnotmatter".toCharArray();
        PBEParameterSpec cipherSpec = new PBEParameterSpec(salt.getBytes(), iterationCount);
        PBEKeySpec keySpec = new PBEKeySpec(password);
        SecretKey cipherKey = factory.generateSecret(keySpec);
        for (int i = 0; i < length; ++i) {
            KeyValueType kvt = (KeyValueType)keyValueList.get(i);
            String val = kvt.getValue();
            if (val.startsWith("MASK-")) {
                String decodedValue;
                val = val.substring("MASK-".length());
                try {
                    decodedValue = PBEUtils.decode64((String)val, (String)pbeAlgo, (SecretKey)cipherKey, (PBEParameterSpec)cipherSpec);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                KeyValueType newKVT = new KeyValueType();
                if (keyValueList.get(0) instanceof AuthPropertyType) {
                    newKVT = new AuthPropertyType();
                }
                newKVT.setKey(kvt.getKey());
                newKVT.setValue(new String(decodedValue));
                returningList.add(newKVT);
                continue;
            }
            returningList.add(kvt);
        }
        return returningList;
    }

    public static ProviderType getSPConfiguration(EntityDescriptorType entityDescriptor, String bindingURI) {
        SPType spType = new SPType();
        String identityURL = null;
        String serviceURL = null;
        if (identityURL == null) {
            IDPSSODescriptorType idpSSO = CoreConfigUtil.getIDPDescriptor(entityDescriptor);
            if (idpSSO != null) {
                identityURL = CoreConfigUtil.getIdentityURL(idpSSO, bindingURI);
            }
            spType.setIdentityURL(identityURL);
        }
        if (serviceURL == null) {
            SPSSODescriptorType spSSO = CoreConfigUtil.getSPDescriptor(entityDescriptor);
            if (spSSO != null) {
                serviceURL = CoreConfigUtil.getServiceURL(spSSO, bindingURI);
            }
            spType.setServiceURL(serviceURL);
        }
        return spType;
    }

    public static SPType getSPConfiguration(EntitiesDescriptorType entitiesDescriptor, String bindingURI) throws ConfigurationException {
        SPType spType = new SPType();
        List<Object> list = entitiesDescriptor.getEntityDescriptor();
        IDPSSODescriptorType idpSSO = null;
        SPSSODescriptorType spSSO = null;
        if (list != null) {
            for (Object theObject : list) {
                if (theObject instanceof EntitiesDescriptorType) {
                    spType = CoreConfigUtil.getSPConfiguration((EntitiesDescriptorType)theObject, bindingURI);
                    continue;
                }
                if (!(theObject instanceof EntityDescriptorType)) continue;
                if (idpSSO == null) {
                    idpSSO = CoreConfigUtil.getIDPDescriptor((EntityDescriptorType)theObject);
                }
                if (spSSO != null) continue;
                spSSO = CoreConfigUtil.getSPDescriptor((EntityDescriptorType)theObject);
            }
            if (idpSSO == null) {
                throw logger.samlMetaDataNoIdentityProviderDefined();
            }
            if (spSSO == null) {
                throw logger.samlMetaDataNoServiceProviderDefined();
            }
            String identityURL = CoreConfigUtil.getIdentityURL(idpSSO, bindingURI);
            if (identityURL == null) {
                throw logger.samlMetaDataNoIdentityProviderDefined();
            }
            spType.setIdentityURL(identityURL);
            spType.setLogoutUrl(CoreConfigUtil.getLogoutURL(idpSSO, bindingURI));
            String serviceURL = CoreConfigUtil.getServiceURL(spSSO, bindingURI);
            if (serviceURL == null) {
                throw logger.samlMetaDataNoServiceProviderDefined();
            }
            spType.setServiceURL(serviceURL);
        }
        return spType;
    }

    public static IDPSSODescriptorType getIDPDescriptor(EntitiesDescriptorType entitiesDescriptor) {
        IDPSSODescriptorType idp = null;
        List<Object> entitiesList = entitiesDescriptor.getEntityDescriptor();
        for (Object theObject : entitiesList) {
            if (theObject instanceof EntitiesDescriptorType) {
                idp = CoreConfigUtil.getIDPDescriptor((EntitiesDescriptorType)theObject);
            } else if (theObject instanceof EntityDescriptorType) {
                idp = CoreConfigUtil.getIDPDescriptor((EntityDescriptorType)theObject);
            }
            if (idp == null) continue;
            break;
        }
        return idp;
    }

    public static IDPSSODescriptorType getIDPDescriptor(EntityDescriptorType entityDescriptor) {
        List<EntityDescriptorType.EDTChoiceType> edtChoices = entityDescriptor.getChoiceType();
        for (EntityDescriptorType.EDTChoiceType edt : edtChoices) {
            List<EntityDescriptorType.EDTDescriptorChoiceType> edtDescriptors = edt.getDescriptors();
            for (EntityDescriptorType.EDTDescriptorChoiceType edtDesc : edtDescriptors) {
                IDPSSODescriptorType idpSSO = edtDesc.getIdpDescriptor();
                if (idpSSO == null) continue;
                return idpSSO;
            }
        }
        return null;
    }

    public static SPSSODescriptorType getSPDescriptor(EntityDescriptorType entityDescriptor) {
        List<EntityDescriptorType.EDTChoiceType> edtChoices = entityDescriptor.getChoiceType();
        for (EntityDescriptorType.EDTChoiceType edt : edtChoices) {
            List<EntityDescriptorType.EDTDescriptorChoiceType> edtDescriptors = edt.getDescriptors();
            for (EntityDescriptorType.EDTDescriptorChoiceType edtDesc : edtDescriptors) {
                SPSSODescriptorType spSSO = edtDesc.getSpDescriptor();
                if (spSSO == null) continue;
                return spSSO;
            }
        }
        return null;
    }

    public static String getIdentityURL(IDPSSODescriptorType idp, String bindingURI) {
        String identityURL = null;
        List<EndpointType> endpoints = idp.getSingleSignOnService();
        for (EndpointType endpoint : endpoints) {
            if (!endpoint.getBinding().toString().equals(bindingURI)) continue;
            identityURL = endpoint.getLocation().toString();
            break;
        }
        return identityURL;
    }

    public static String getLogoutURL(IDPSSODescriptorType idp, String bindingURI) {
        String logoutURL = null;
        List<EndpointType> endpoints = idp.getSingleLogoutService();
        for (EndpointType endpoint : endpoints) {
            if (!endpoint.getBinding().toString().equals(bindingURI)) continue;
            logoutURL = endpoint.getLocation().toString();
            break;
        }
        return logoutURL;
    }

    public static String getServiceURL(SPSSODescriptorType sp, String bindingURI) {
        String serviceURL = null;
        List<IndexedEndpointType> endpoints = sp.getAssertionConsumerService();
        for (IndexedEndpointType endpoint : endpoints) {
            if (!endpoint.getBinding().toString().equals(bindingURI)) continue;
            serviceURL = endpoint.getLocation().toString();
            break;
        }
        return serviceURL;
    }

    public static IDPType getIDPType(IDPSSODescriptorType idpSSODescriptor) {
        IDPType idp = new IDPType();
        List<EndpointType> endpoints = idpSSODescriptor.getSingleSignOnService();
        if (endpoints != null) {
            for (EndpointType endpoint : endpoints) {
                if (!endpoint.getBinding().toString().equals(JBossSAMLURIConstants.SAML_HTTP_POST_BINDING.get())) continue;
                idp.setIdentityURL(endpoint.getLocation().toString());
                break;
            }
        }
        if (StringUtil.isNullOrEmpty((String)idp.getIdentityURL())) {
            throw logger.nullValueError("identity url");
        }
        return idp;
    }

    public static List<EntityDescriptorType> getMetadataConfiguration(ProviderType providerType, ServletContext servletContext) {
        IMetadataProvider metadataProvider;
        MetadataProviderType metadataProviderType = providerType.getMetaDataProvider();
        if (metadataProviderType == null) {
            return null;
        }
        String fqn = metadataProviderType.getClassName();
        Class<?> clazz = SecurityActions.loadClass(CoreConfigUtil.class, fqn);
        try {
            metadataProvider = (IMetadataProvider)clazz.newInstance();
        }
        catch (Exception iae) {
            throw new RuntimeException(iae);
        }
        List keyValues = metadataProviderType.getOption();
        HashMap<String, String> options = new HashMap<String, String>();
        if (keyValues != null) {
            for (KeyValueType kvt : keyValues) {
                options.put(kvt.getKey(), kvt.getValue());
            }
        }
        metadataProvider.init(options);
        String fileInjectionStr = metadataProvider.requireFileInjection();
        if (StringUtil.isNotNull((String)fileInjectionStr)) {
            metadataProvider.injectFileStream(servletContext.getResourceAsStream(fileInjectionStr));
        }
        ArrayList<EntityDescriptorType> resultList = new ArrayList<EntityDescriptorType>();
        if (metadataProvider.isMultiple()) {
            EntitiesDescriptorType metadatas = (EntitiesDescriptorType)metadataProvider.getMetaData();
            CoreConfigUtil.addAllEntityDescriptorsRecursively(resultList, metadatas);
        } else {
            EntityDescriptorType metadata = (EntityDescriptorType)metadataProvider.getMetaData();
            resultList.add(metadata);
        }
        return resultList;
    }

    private static void addAllEntityDescriptorsRecursively(List<EntityDescriptorType> resultList, EntitiesDescriptorType entitiesDescriptorType) {
        List<Object> entities = entitiesDescriptorType.getEntityDescriptor();
        for (Object o : entities) {
            if (o instanceof EntitiesDescriptorType) {
                CoreConfigUtil.addAllEntityDescriptorsRecursively(resultList, (EntitiesDescriptorType)o);
                continue;
            }
            if (o instanceof EntityDescriptorType) {
                resultList.add((EntityDescriptorType)o);
                continue;
            }
            throw new IllegalArgumentException("Wrong type: " + o.getClass());
        }
    }
}

