/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.handlers.saml2;

import java.net.URI;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.ParserConfigurationException;
import org.picketlink.common.constants.JBossSAMLURIConstants;
import org.picketlink.common.exceptions.ConfigurationException;
import org.picketlink.common.exceptions.ParsingException;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.config.federation.SPType;
import org.picketlink.identity.federation.api.saml.v2.request.SAML2Request;
import org.picketlink.identity.federation.api.saml.v2.response.SAML2Response;
import org.picketlink.identity.federation.core.audit.PicketLinkAuditEvent;
import org.picketlink.identity.federation.core.audit.PicketLinkAuditEventType;
import org.picketlink.identity.federation.core.audit.PicketLinkAuditHelper;
import org.picketlink.identity.federation.core.saml.v2.common.IDGenerator;
import org.picketlink.identity.federation.core.saml.v2.common.SAMLProtocolContext;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2Handler;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerRequest;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerResponse;
import org.picketlink.identity.federation.core.saml.v2.util.XMLTimeUtil;
import org.picketlink.identity.federation.core.sts.PicketLinkCoreSTS;
import org.picketlink.identity.federation.core.wstrust.plugins.saml.SAMLUtil;
import org.picketlink.identity.federation.saml.v2.SAML2Object;
import org.picketlink.identity.federation.saml.v2.assertion.AssertionType;
import org.picketlink.identity.federation.saml.v2.assertion.AuthnStatementType;
import org.picketlink.identity.federation.saml.v2.assertion.NameIDType;
import org.picketlink.identity.federation.saml.v2.assertion.StatementAbstractType;
import org.picketlink.identity.federation.saml.v2.protocol.LogoutRequestType;
import org.picketlink.identity.federation.saml.v2.protocol.ResponseType;
import org.picketlink.identity.federation.saml.v2.protocol.StatusCodeType;
import org.picketlink.identity.federation.saml.v2.protocol.StatusResponseType;
import org.picketlink.identity.federation.saml.v2.protocol.StatusType;
import org.picketlink.identity.federation.web.core.HTTPContext;
import org.picketlink.identity.federation.web.core.IdentityServer;
import org.picketlink.identity.federation.web.handlers.saml2.BaseSAML2Handler;
import org.w3c.dom.Document;

public class SAML2LogOutHandler
extends BaseSAML2Handler {
    private final IDPLogOutHandler idp = new IDPLogOutHandler();
    private final SPLogOutHandler sp = new SPLogOutHandler();

    @Override
    public void generateSAMLRequest(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        if (request.getTypeOfRequestToBeGenerated() == null) {
            return;
        }
        if (SAML2HandlerRequest.GENERATE_REQUEST_TYPE.LOGOUT != request.getTypeOfRequestToBeGenerated()) {
            return;
        }
        if (this.getType() == SAML2Handler.HANDLER_TYPE.IDP) {
            this.idp.generateSAMLRequest(request, response);
        } else {
            this.sp.generateSAMLRequest(request, response);
        }
    }

    @Override
    public void handleRequestType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        if (!(request.getSAML2Object() instanceof LogoutRequestType)) {
            return;
        }
        if (this.getType() == SAML2Handler.HANDLER_TYPE.IDP) {
            this.idp.handleRequestType(request, response);
        } else {
            this.sp.handleRequestType(request, response);
        }
    }

    @Override
    public void handleStatusResponseType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        if (request.getSAML2Object() instanceof ResponseType) {
            return;
        }
        if (!(request.getSAML2Object() instanceof StatusResponseType)) {
            return;
        }
        if (this.getType() == SAML2Handler.HANDLER_TYPE.IDP) {
            this.idp.handleStatusResponseType(request, response);
        } else {
            this.sp.handleStatusResponseType(request, response);
        }
    }

    private class SPLogOutHandler {
        private SPLogOutHandler() {
        }

        public void generateSAMLRequest(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
            SAML2Request samlRequest = new SAML2Request();
            HTTPContext httpContext = (HTTPContext)request.getContext();
            HttpServletRequest httpRequest = httpContext.getRequest();
            Principal userPrincipal = httpRequest.getUserPrincipal();
            if (userPrincipal == null) {
                throw BaseSAML2Handler.logger.samlHandlerPrincipalNotFoundError();
            }
            try {
                LogoutRequestType lot = samlRequest.createLogoutRequest(request.getIssuer().getValue());
                NameIDType nameID = new NameIDType();
                nameID.setValue(userPrincipal.getName());
                lot.setNameID(nameID);
                SPType spConfiguration = (SPType)SAML2LogOutHandler.this.getProviderconfig();
                String logoutUrl = spConfiguration.getLogoutUrl();
                if (logoutUrl == null) {
                    logoutUrl = spConfiguration.getIdentityURL();
                }
                lot.setDestination(URI.create(logoutUrl));
                this.populateSessionIndex(httpRequest, lot);
                response.setResultingDocument(samlRequest.convert(lot));
                response.setSendRequest(true);
            }
            catch (Exception e) {
                throw BaseSAML2Handler.logger.processingError((Throwable)e);
            }
        }

        private void populateSessionIndex(HttpServletRequest httpRequest, LogoutRequestType lot) throws ProcessingException, ConfigurationException, ParsingException {
            Document currentAssertion = (Document)httpRequest.getSession().getAttribute("ASSERTION_SESSION_ATTRIBUTE_NAME");
            if (currentAssertion != null) {
                AssertionType assertionType = SAMLUtil.fromElement(currentAssertion.getDocumentElement());
                Set<StatementAbstractType> statements = assertionType.getStatements();
                for (StatementAbstractType statementAbstractType : statements) {
                    if (!AuthnStatementType.class.isInstance(statementAbstractType)) continue;
                    AuthnStatementType authnStatement = (AuthnStatementType)statementAbstractType;
                    String sessionIndex = authnStatement.getSessionIndex();
                    if (sessionIndex == null) break;
                    lot.addSessionIndex(sessionIndex);
                    break;
                }
            }
        }

        public void handleStatusResponseType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
            StatusResponseType statusResponseType = (StatusResponseType)request.getSAML2Object();
            HTTPContext httpContext = (HTTPContext)request.getContext();
            HttpServletRequest servletRequest = httpContext.getRequest();
            HttpSession session = servletRequest.getSession(false);
            StatusType statusType = statusResponseType.getStatus();
            StatusCodeType statusCode = statusType.getStatusCode();
            URI statusCodeValueURI = statusCode.getValue();
            boolean success = false;
            if (statusCodeValueURI != null) {
                String statusCodeValue = statusCodeValueURI.toString();
                if (JBossSAMLURIConstants.STATUS_SUCCESS.get().equals(statusCodeValue)) {
                    success = true;
                }
            }
            if (success) {
                session.invalidate();
            } else {
                StatusCodeType secondLevelstatusCode = statusCode.getStatusCode();
                if (secondLevelstatusCode != null && secondLevelstatusCode.getValue().toString().equals(JBossSAMLURIConstants.STATUS_SUCCESS.get())) {
                    session.invalidate();
                }
            }
        }

        public void handleRequestType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
            SAML2Object samlObject = request.getSAML2Object();
            if (!(samlObject instanceof LogoutRequestType)) {
                return;
            }
            LogoutRequestType logOutRequest = (LogoutRequestType)samlObject;
            HTTPContext httpContext = (HTTPContext)request.getContext();
            HttpServletRequest servletRequest = httpContext.getRequest();
            HttpSession session = servletRequest.getSession(false);
            String relayState = servletRequest.getParameter("RelayState");
            session.invalidate();
            StatusResponseType statusResponse = null;
            try {
                statusResponse = new StatusResponseType(IDGenerator.create("ID_"), XMLTimeUtil.getIssueInstant());
            }
            catch (ConfigurationException e) {
                throw BaseSAML2Handler.logger.processingError((Throwable)e);
            }
            StatusType statusType = new StatusType();
            StatusCodeType statusCodeType = new StatusCodeType();
            statusCodeType.setValue(URI.create(JBossSAMLURIConstants.STATUS_RESPONDER.get()));
            StatusCodeType status2ndLevel = new StatusCodeType();
            status2ndLevel.setValue(URI.create(JBossSAMLURIConstants.STATUS_SUCCESS.get()));
            statusCodeType.setStatusCode(status2ndLevel);
            statusType.setStatusCode(statusCodeType);
            statusResponse.setStatus(statusType);
            statusResponse.setInResponseTo(logOutRequest.getID());
            statusResponse.setIssuer(request.getIssuer());
            SAML2Response saml2Response = new SAML2Response();
            try {
                response.setResultingDocument(saml2Response.convert(statusResponse));
            }
            catch (Exception je) {
                throw BaseSAML2Handler.logger.processingError((Throwable)je);
            }
            response.setRelayState(relayState);
            response.setDestination(logOutRequest.getIssuer().getValue());
            response.setSendRequest(false);
        }
    }

    private class IDPLogOutHandler {
        private IDPLogOutHandler() {
        }

        public void generateSAMLRequest(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
        }

        public void handleStatusResponseType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
            SAML2Object samlObject = request.getSAML2Object();
            StatusResponseType statusResponseType = (StatusResponseType)samlObject;
            HTTPContext httpContext = (HTTPContext)request.getContext();
            HttpServletRequest httpRequest = httpContext.getRequest();
            HttpSession httpSession = httpRequest.getSession(false);
            String relayState = request.getRelayState();
            ServletContext servletCtx = httpContext.getServletContext();
            IdentityServer server = (IdentityServer)servletCtx.getAttribute("IDENTITY_SERVER");
            if (server == null) {
                throw BaseSAML2Handler.logger.samlHandlerIdentityServerNotFoundError();
            }
            String sessionID = httpSession.getId();
            String statusIssuer = statusResponseType.getIssuer().getValue();
            server.stack().deRegisterTransitParticipant(sessionID, statusIssuer);
            String nextParticipant = this.getParticipant(server, sessionID, relayState);
            if (nextParticipant == null || nextParticipant.equals(relayState)) {
                AssertionType assertion = (AssertionType)httpSession.getAttribute("ASSERTION");
                if (assertion != null) {
                    PicketLinkCoreSTS sts = PicketLinkCoreSTS.instance();
                    SAMLProtocolContext samlProtocolContext = new SAMLProtocolContext();
                    samlProtocolContext.setIssuedAssertion(assertion);
                    sts.cancelToken(samlProtocolContext);
                    httpSession.removeAttribute("ASSERTION");
                }
                try {
                    this.generateSuccessStatusResponseType(statusResponseType.getInResponseTo(), request, response, relayState);
                    boolean isPost = this.isPostBindingForResponse(server, relayState, request);
                    response.setPostBindingForResponse(isPost);
                }
                catch (Exception e) {
                    throw BaseSAML2Handler.logger.processingError((Throwable)e);
                }
                Map<String, Object> requestOptions = request.getOptions();
                PicketLinkAuditHelper auditHelper = (PicketLinkAuditHelper)requestOptions.get("AUDIT_HELPER");
                if (auditHelper != null) {
                    PicketLinkAuditEvent auditEvent = new PicketLinkAuditEvent("Info");
                    auditEvent.setWhoIsAuditing((String)requestOptions.get("CONTEXT_PATH"));
                    auditEvent.setType(PicketLinkAuditEventType.INVALIDATE_HTTP_SESSION);
                    auditEvent.setHttpSessionID(httpSession.getId());
                    auditHelper.audit(auditEvent);
                }
                httpSession.invalidate();
            } else {
                server.stack().registerTransitParticipant(sessionID, nextParticipant);
                boolean isPost = this.isPostBindingForResponse(server, nextParticipant, request);
                response.setPostBindingForResponse(isPost);
                response.setRelayState(relayState);
                response.setDestination(nextParticipant);
                SAML2Request saml2Request = new SAML2Request();
                try {
                    LogoutRequestType lort = saml2Request.createLogoutRequest(request.getIssuer().getValue());
                    response.setResultingDocument(saml2Request.convert(lort));
                    response.setSendRequest(true);
                }
                catch (Exception e) {
                    throw BaseSAML2Handler.logger.processingError((Throwable)e);
                }
            }
        }

        public void handleRequestType(SAML2HandlerRequest request, SAML2HandlerResponse response) throws ProcessingException {
            HTTPContext httpContext = (HTTPContext)request.getContext();
            HttpServletRequest httpServletRequest = httpContext.getRequest();
            HttpSession session = httpServletRequest.getSession(false);
            String sessionID = session.getId();
            String relayState = httpContext.getRequest().getParameter("RelayState");
            LogoutRequestType logOutRequest = (LogoutRequestType)request.getSAML2Object();
            String issuer = logOutRequest.getIssuer().getValue();
            try {
                SAML2Request saml2Request = new SAML2Request();
                ServletContext servletCtx = httpContext.getServletContext();
                IdentityServer server = (IdentityServer)servletCtx.getAttribute("IDENTITY_SERVER");
                if (server == null) {
                    throw BaseSAML2Handler.logger.samlHandlerIdentityServerNotFoundError();
                }
                String originalIssuer = relayState == null ? issuer : relayState;
                String participant = this.getParticipant(server, sessionID, originalIssuer);
                if (participant == null || participant.equals(originalIssuer)) {
                    session.invalidate();
                    server.stack().pop(sessionID);
                    this.generateSuccessStatusResponseType(logOutRequest.getID(), request, response, originalIssuer);
                    boolean isPost = this.isPostBindingForResponse(server, participant, request);
                    response.setPostBindingForResponse(isPost);
                    response.setSendRequest(false);
                } else {
                    server.stack().registerTransitParticipant(sessionID, participant);
                    if (relayState == null) {
                        relayState = originalIssuer;
                    }
                    response.setRelayState(originalIssuer);
                    response.setDestination(participant);
                    boolean isPost = this.isPostBindingForResponse(server, participant, request);
                    response.setPostBindingForResponse(isPost);
                    LogoutRequestType lort = saml2Request.createLogoutRequest(request.getIssuer().getValue());
                    Principal userPrincipal = httpServletRequest.getUserPrincipal();
                    if (userPrincipal == null) {
                        throw BaseSAML2Handler.logger.samlHandlerPrincipalNotFoundError();
                    }
                    NameIDType nameID = new NameIDType();
                    nameID.setValue(userPrincipal.getName());
                    lort.setNameID(nameID);
                    long assertionValidity = PicketLinkCoreSTS.instance().getConfiguration().getIssuedTokenTimeout();
                    lort.setNotOnOrAfter(XMLTimeUtil.add(lort.getIssueInstant(), assertionValidity));
                    lort.setDestination(URI.create(participant));
                    response.setResultingDocument(saml2Request.convert(lort));
                    response.setSendRequest(true);
                }
            }
            catch (ParserConfigurationException pe) {
                throw BaseSAML2Handler.logger.processingError((Throwable)pe);
            }
            catch (ConfigurationException pe) {
                throw BaseSAML2Handler.logger.processingError((Throwable)pe);
            }
            catch (ParsingException e) {
                throw BaseSAML2Handler.logger.processingError((Throwable)e);
            }
        }

        private void generateSuccessStatusResponseType(String logOutRequestID, SAML2HandlerRequest request, SAML2HandlerResponse response, String originalIssuer) throws ConfigurationException, ParserConfigurationException, ProcessingException {
            BaseSAML2Handler.logger.trace("Generating Success Status Response for " + originalIssuer);
            StatusResponseType statusResponse = new StatusResponseType(IDGenerator.create("ID_"), XMLTimeUtil.getIssueInstant());
            StatusType statusType = new StatusType();
            StatusCodeType statusCodeType = new StatusCodeType();
            statusCodeType.setValue(URI.create(JBossSAMLURIConstants.STATUS_RESPONDER.get()));
            StatusCodeType status2ndLevel = new StatusCodeType();
            status2ndLevel.setValue(URI.create(JBossSAMLURIConstants.STATUS_SUCCESS.get()));
            statusCodeType.setStatusCode(status2ndLevel);
            statusType.setStatusCode(statusCodeType);
            statusResponse.setStatus(statusType);
            statusResponse.setInResponseTo(logOutRequestID);
            statusResponse.setIssuer(request.getIssuer());
            try {
                SAML2Response saml2Response = new SAML2Response();
                response.setResultingDocument(saml2Response.convert(statusResponse));
            }
            catch (ParsingException je) {
                throw BaseSAML2Handler.logger.processingError((Throwable)je);
            }
            response.setDestination(originalIssuer);
        }

        private String getParticipant(IdentityServer server, String sessionID, String originalRequestor) {
            int participants = server.stack().getParticipants(sessionID);
            String participant = originalRequestor;
            if (participants > 0) {
                do {
                    participant = server.stack().pop(sessionID);
                } while (--participants > 0 && participant.equals(originalRequestor));
            }
            return participant;
        }

        private boolean isPostBindingForResponse(IdentityServer server, String participant, SAML2HandlerRequest request) {
            Boolean isStrictPostBindingForResponse;
            Boolean isPostParticipant = server.stack().getBinding(participant);
            if (isPostParticipant == null) {
                isPostParticipant = Boolean.TRUE;
            }
            if ((isStrictPostBindingForResponse = (Boolean)request.getOptions().get("SAML_IDP_STRICT_POST_BINDING")) == null) {
                isStrictPostBindingForResponse = Boolean.FALSE;
            }
            return isPostParticipant != false || isStrictPostBindingForResponse != false;
        }
    }
}

