/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.process;

import java.io.IOException;
import java.net.URL;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import javax.servlet.http.HttpServletRequest;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.exceptions.ConfigurationException;
import org.picketlink.common.exceptions.ParsingException;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.common.exceptions.TrustKeyConfigurationException;
import org.picketlink.common.exceptions.TrustKeyProcessingException;
import org.picketlink.common.util.StringUtil;
import org.picketlink.config.federation.ProviderType;
import org.picketlink.config.federation.SPType;
import org.picketlink.identity.federation.core.audit.PicketLinkAuditHelper;
import org.picketlink.identity.federation.core.interfaces.TrustKeyManager;
import org.picketlink.identity.federation.core.saml.v2.common.SAMLDocumentHolder;
import org.picketlink.identity.federation.core.saml.v2.holders.IssuerInfoHolder;
import org.picketlink.identity.federation.core.saml.v2.impl.DefaultSAML2HandlerRequest;
import org.picketlink.identity.federation.core.saml.v2.impl.DefaultSAML2HandlerResponse;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2Handler;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerRequest;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerResponse;
import org.picketlink.identity.federation.web.core.HTTPContext;

public class ServiceProviderBaseProcessor {
    protected static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    protected boolean postBinding;
    protected String serviceURL;
    protected String identityURL;
    protected ProviderType spConfiguration;
    protected TrustKeyManager keyManager;
    protected String issuer = null;
    protected PicketLinkAuditHelper auditHelper = null;
    public static final String IDP_KEY = "idp.key";

    public ServiceProviderBaseProcessor(boolean postBinding, String serviceURL) {
        this.postBinding = postBinding;
        this.serviceURL = serviceURL;
    }

    public void setConfiguration(ProviderType sp) {
        this.spConfiguration = sp;
    }

    public void setTrustKeyManager(TrustKeyManager tkm) {
        this.keyManager = tkm;
    }

    public void setIdentityURL(String identityURL) {
        this.identityURL = identityURL;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public void setAuditHelper(PicketLinkAuditHelper helper) {
        this.auditHelper = helper;
    }

    public SAML2HandlerResponse process(HTTPContext httpContext, Set<SAML2Handler> handlers, Lock chainLock) throws ProcessingException, IOException, ParsingException, ConfigurationException {
        String logoutUrl;
        logger.trace("SAML Handlers are: " + handlers);
        SAML2HandlerRequest saml2HandlerRequest = this.getSAML2HandlerRequest(null, httpContext);
        saml2HandlerRequest.addOption("CONTEXT_PATH", httpContext.getServletContext().getContextPath());
        saml2HandlerRequest.addOption("SUPPORTS_SIGNATURES", this.spConfiguration.isSupportsSignature());
        DefaultSAML2HandlerResponse saml2HandlerResponse = new DefaultSAML2HandlerResponse();
        saml2HandlerResponse.setPostBindingForResponse(this.postBinding);
        saml2HandlerResponse.setDestination(this.identityURL);
        if (this.isLogOutRequest(httpContext) && (logoutUrl = ((SPType)this.spConfiguration).getLogoutUrl()) != null) {
            saml2HandlerResponse.setDestination(logoutUrl);
        }
        try {
            chainLock.lock();
            for (SAML2Handler handler : handlers) {
                handler.reset();
                if (saml2HandlerResponse.isInError()) {
                    httpContext.getResponse().sendError(saml2HandlerResponse.getErrorCode());
                    break;
                }
                if (this.isLogOutRequest(httpContext)) {
                    saml2HandlerRequest.setTypeOfRequestToBeGenerated(SAML2HandlerRequest.GENERATE_REQUEST_TYPE.LOGOUT);
                } else {
                    saml2HandlerRequest.setTypeOfRequestToBeGenerated(SAML2HandlerRequest.GENERATE_REQUEST_TYPE.AUTH);
                }
                handler.generateSAMLRequest(saml2HandlerRequest, saml2HandlerResponse);
                logger.trace("Finished Processing handler: " + handler.getClass().getCanonicalName());
            }
        }
        catch (ProcessingException pe) {
            logger.error((Throwable)pe);
            throw logger.samlHandlerChainProcessingError((Throwable)pe);
        }
        finally {
            chainLock.unlock();
        }
        return saml2HandlerResponse;
    }

    protected SAML2HandlerRequest getSAML2HandlerRequest(SAMLDocumentHolder documentHolder, HTTPContext httpContext) {
        IssuerInfoHolder holder = null;
        holder = this.issuer == null ? new IssuerInfoHolder(this.serviceURL) : new IssuerInfoHolder(this.issuer);
        return new DefaultSAML2HandlerRequest(httpContext, holder.getIssuer(), documentHolder, SAML2Handler.HANDLER_TYPE.SP);
    }

    protected boolean isLogOutRequest(HTTPContext httpContext) {
        HttpServletRequest request = httpContext.getRequest();
        String gloStr = request.getParameter("GLO");
        return StringUtil.isNotNull((String)gloStr) && "true".equalsIgnoreCase(gloStr);
    }

    protected URL safeURL(String urlString) {
        try {
            return new URL(urlString);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected PublicKey getIDPPublicKey() throws TrustKeyConfigurationException, TrustKeyProcessingException {
        if (this.keyManager == null) {
            throw logger.trustKeyManagerMissing();
        }
        String idpValidatingAlias = (String)this.keyManager.getAdditionalOption(IDP_KEY);
        if (StringUtil.isNullOrEmpty((String)idpValidatingAlias)) {
            idpValidatingAlias = this.safeURL(this.spConfiguration.getIdentityURL()).getHost();
        }
        return this.keyManager.getValidatingKey(idpValidatingAlias);
    }

    protected void setRequestOptions(SAML2HandlerRequest saml2HandlerRequest) throws TrustKeyConfigurationException, TrustKeyProcessingException {
        if (this.spConfiguration != null) {
            HashMap<String, Object> requestOptions = new HashMap<String, Object>();
            requestOptions.put("CONFIGURATION", this.spConfiguration);
            if (this.auditHelper != null) {
                requestOptions.put("AUDIT_HELPER", this.auditHelper);
            }
            if (this.keyManager != null) {
                PublicKey validatingKey = this.getIDPPublicKey();
                requestOptions.put("SENDER_PUBLIC_KEY", validatingKey);
                requestOptions.put("DECRYPTING_KEY", this.keyManager.getSigningKey());
            }
            requestOptions.put("SUPPORTS_SIGNATURES", this.spConfiguration.isSupportsSignature());
            saml2HandlerRequest.setOptions(requestOptions);
        }
    }
}

