/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.util.Base64;
import org.picketlink.common.util.StringUtil;
import org.picketlink.identity.federation.core.saml.v2.holders.DestinationInfoHolder;

public class PostBindingUtil {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();

    public static String base64Encode(String stringToEncode) throws IOException {
        return Base64.encodeBytes((byte[])stringToEncode.getBytes("UTF-8"), (int)8);
    }

    public static byte[] base64Decode(String encodedString) {
        if (encodedString == null) {
            throw logger.nullArgumentError("encodedString");
        }
        return Base64.decode((String)encodedString);
    }

    public static InputStream base64DecodeAsStream(String encodedString) {
        if (encodedString == null) {
            throw logger.nullArgumentError("encodedString");
        }
        return new ByteArrayInputStream(PostBindingUtil.base64Decode(encodedString));
    }

    public static void sendPost(DestinationInfoHolder holder, HttpServletResponse response, boolean request) throws IOException {
        String key = request ? "SAMLRequest" : "SAMLResponse";
        String relayState = holder.getRelayState();
        String destination = holder.getDestination();
        String samlMessage = holder.getSamlMessage();
        if (destination == null) {
            throw logger.nullValueError("Destination is null");
        }
        response.setContentType("text/html");
        PostBindingUtil.common(holder.getDestination(), response);
        StringBuilder builder = new StringBuilder();
        builder.append("<HTML>");
        builder.append("<HEAD>");
        if (request) {
            builder.append("<TITLE>HTTP Post Binding (Request)</TITLE>");
        } else {
            builder.append("<TITLE>HTTP Post Binding Response (Response)</TITLE>");
        }
        builder.append("</HEAD>");
        builder.append("<BODY Onload=\"document.forms[0].submit()\">");
        builder.append("<FORM METHOD=\"POST\" ACTION=\"" + destination + "\">");
        builder.append("<INPUT TYPE=\"HIDDEN\" NAME=\"" + key + "\"" + " VALUE=\"" + samlMessage + "\"/>");
        if (StringUtil.isNotNull((String)relayState)) {
            builder.append("<INPUT TYPE=\"HIDDEN\" NAME=\"RelayState\" VALUE=\"" + relayState + "\"/>");
        }
        builder.append("</FORM></BODY></HTML>");
        String str = builder.toString();
        logger.trace(str);
        ServletOutputStream outputStream = response.getOutputStream();
        response.resetBuffer();
        response.setContentLength(str.length());
        outputStream.println(str);
        outputStream.close();
    }

    private static void common(String destination, HttpServletResponse response) {
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache, no-store");
    }
}

