/*
 * JBoss, Home of Professional Open Source
 *
 * Copyright 2013 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.picketlink.identity.federation.core.saml.v2.impl;

import org.picketlink.identity.federation.core.interfaces.ProtocolContext;
import org.picketlink.identity.federation.core.saml.v2.common.SAMLDocumentHolder;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2Handler.HANDLER_TYPE;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerRequest;
import org.picketlink.identity.federation.saml.v2.SAML2Object;
import org.picketlink.identity.federation.saml.v2.assertion.NameIDType;
import org.w3c.dom.Document;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * Default SAML2HandlerRequest
 *
 * @author Anil.Saldhana@redhat.com
 * @since Oct 1, 2009
 */
public class DefaultSAML2HandlerRequest implements SAML2HandlerRequest {
    private ProtocolContext protocolContext = null;
    private NameIDType issuer;
    private SAMLDocumentHolder documentHolder;;
    private HANDLER_TYPE handlerType;
    private Map<String, Object> options = new HashMap<String, Object>();
    private GENERATE_REQUEST_TYPE generateRequestType;
    private String relayState;

    public DefaultSAML2HandlerRequest(ProtocolContext protocolContext, NameIDType issuer,
            SAMLDocumentHolder samlDocumentHolder, HANDLER_TYPE handlerType) {
        this.protocolContext = protocolContext;
        this.issuer = issuer;
        this.documentHolder = samlDocumentHolder;
        this.handlerType = handlerType;
    }

    public void setOptions(Map<String, Object> options) {
        this.options = options;
    }

    /**
     * @see SAML2HandlerRequest#getContext()
     */
    public ProtocolContext getContext() {
        return this.protocolContext;
    }

    /**
     * @see SAML2HandlerRequest#getIssuer()
     */
    public NameIDType getIssuer() {
        return this.issuer;
    }

    /**
     * @see SAML2HandlerRequest#getSAML2Object()
     */
    public SAML2Object getSAML2Object() {
        return (SAML2Object) this.documentHolder.getSamlObject();
    }

    /**
     * @see SAML2HandlerRequest#getType()
     */
    public HANDLER_TYPE getType() {
        return handlerType;
    }

    /**
     * @see {@code SAML2HandlerRequest#addOption(String, Object)}
     */
    public void addOption(String key, Object option) {
        this.options.put(key, option);
    }

    /**
     * @see SAML2HandlerRequest#getOptions()
     */
    public Map<String, Object> getOptions() {
        return Collections.unmodifiableMap(this.options);
    }

    /**
     * Set the type of saml2 request that need to be generated by the handler
     *
     * @param grt
     */
    public void setTypeOfRequestToBeGenerated(GENERATE_REQUEST_TYPE grt) {
        this.generateRequestType = grt;
    }

    /**
     * @see SAML2HandlerRequest#getTypeOfRequestToBeGenerated()
     */
    public GENERATE_REQUEST_TYPE getTypeOfRequestToBeGenerated() {
        return this.generateRequestType;
    }

    /**
     * @see SAML2HandlerRequest#getRelayState()
     */
    public String getRelayState() {
        return this.relayState;
    }

    public void setRelayState(String relay) {
        this.relayState = relay;
    }

    public Document getRequestDocument() {
        return this.documentHolder.getSamlDocument();
    }

}