/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.wstrust.plugins.saml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.exceptions.ConfigurationException;
import org.picketlink.common.exceptions.ParsingException;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.common.util.DocumentUtil;
import org.picketlink.common.util.StaxUtil;
import org.picketlink.identity.federation.core.parsers.saml.SAMLParser;
import org.picketlink.identity.federation.core.saml.v1.writers.SAML11AssertionWriter;
import org.picketlink.identity.federation.core.saml.v2.writers.SAMLAssertionWriter;
import org.picketlink.identity.federation.core.util.JAXPValidationUtil;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11AssertionType;
import org.picketlink.identity.federation.saml.v2.assertion.AssertionType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAMLUtil {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    public static final String SAML11_BEARER_URI = "urn:oasis:names:tc:SAML:1.0:cm:bearer";
    public static final String SAML11_HOLDER_OF_KEY_URI = "urn:oasis:names:tc:SAML:1.0:cm:holder-of-key";
    public static final String SAML11_SENDER_VOUCHES_URI = "urn:oasis:names:tc:SAML:1.0:cm:sender-vouches";
    public static final String SAML2_BEARER_URI = "urn:oasis:names:tc:SAML:2.0:cm:bearer";
    public static final String SAML2_HOLDER_OF_KEY_URI = "urn:oasis:names:tc:SAML:2.0:cm:holder-of-key";
    public static final String SAML2_SENDER_VOUCHES_URI = "urn:oasis:names:tc:SAML:2.0:cm:sender-vouches";
    public static final String SAML11_TOKEN_TYPE = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1";
    public static final String SAML11_VALUE_TYPE = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID";
    public static final String SAML2_TOKEN_TYPE = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0";
    public static final String SAML2_VALUE_TYPE = "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLID";

    public static Element toElement(AssertionType assertion) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SAMLAssertionWriter writer = new SAMLAssertionWriter(StaxUtil.getXMLStreamWriter((OutputStream)baos));
        writer.write(assertion);
        byte[] assertionBytes = baos.toByteArray();
        ByteArrayInputStream bis = new ByteArrayInputStream(assertionBytes);
        Document document = DocumentUtil.getDocument((InputStream)bis);
        if (logger.isTraceEnabled()) {
            logger.samlAssertion(DocumentUtil.asString((Document)document));
        }
        return document.getDocumentElement();
    }

    public static Element toElement(SAML11AssertionType assertion) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SAML11AssertionWriter writer = new SAML11AssertionWriter(StaxUtil.getXMLStreamWriter((OutputStream)baos));
        writer.write(assertion);
        ByteArrayInputStream bis = new ByteArrayInputStream(baos.toByteArray());
        Document document = DocumentUtil.getDocument((InputStream)bis);
        return document.getDocumentElement();
    }

    public static AssertionType fromElement(Element assertionElement) throws ProcessingException, ConfigurationException, ParsingException {
        SAMLParser samlParser = new SAMLParser();
        JAXPValidationUtil.checkSchemaValidation(assertionElement);
        AssertionType assertion = (AssertionType)samlParser.parse(DocumentUtil.getNodeAsStream((Node)assertionElement));
        return assertion;
    }

    public static SAML11AssertionType saml11FromElement(Element assertionElement) throws GeneralSecurityException {
        SAMLParser samlParser = new SAMLParser();
        JAXPValidationUtil.checkSchemaValidation(assertionElement);
        return (SAML11AssertionType)samlParser.parse(DocumentUtil.getNodeAsStream((Node)assertionElement));
    }
}

