/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.wstrust;

import org.picketlink.identity.federation.core.wstrust.STSClient;
import org.picketlink.identity.federation.core.wstrust.STSClientConfig;
import org.picketlink.identity.federation.core.wstrust.STSClientCreationCallBack;
import org.picketlink.identity.federation.core.wstrust.STSClientPool;

public final class STSClientFactory {
    private static final int INITIAL_NUMBER_OF_CLIENTS_IN_POOL = 10;
    private static STSClientFactory INSTANCE = null;
    private static STSClientPool POOL = null;

    private STSClientFactory() {
    }

    public static STSClientFactory getInstance() {
        if (INSTANCE == null) {
            return STSClientFactory.getInstance(0);
        }
        return INSTANCE;
    }

    public static STSClientFactory getInstance(int maxClientsInPool) {
        if (INSTANCE == null) {
            INSTANCE = new STSClientFactory();
            POOL = STSClientPool.instance(maxClientsInPool);
        }
        return INSTANCE;
    }

    public STSClient create(STSClientConfig config) {
        return this.create(10, config);
    }

    public STSClient create(int initialNumberOfClients, STSClientConfig config) {
        if (POOL.isPoolingDisabled()) {
            return new STSClient(config);
        }
        POOL.initialize(initialNumberOfClients, config);
        return POOL.takeOut(config);
    }

    public STSClient create(int initialNumberOfClients, STSClientCreationCallBack callBack) {
        if (POOL.isPoolingDisabled()) {
            return callBack.createClient();
        }
        POOL.initialize(initialNumberOfClients, callBack);
        return POOL.takeOut(callBack.getKey());
    }
}

