/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.core.wstrust;

import org.picketlink.identity.federation.core.wstrust.STSClient;
import org.picketlink.identity.federation.core.wstrust.STSClientConfig;
import org.picketlink.identity.federation.core.wstrust.STSClientCreationCallBack;
import org.picketlink.identity.federation.core.wstrust.STSClientPool;

public final class STSClientFactory {
    private final STSClientPool stsClientPool = new STSClientPool();

    private STSClientFactory() {
    }

    public static STSClientFactory getInstance() {
        return LazySTSClientFactory.INSTANCE;
    }

    public static STSClientFactory getInstance(int maxClientsInPool) {
        LazySTSClientFactory.INSTANCE.stsClientPool.initializePool(maxClientsInPool);
        return LazySTSClientFactory.INSTANCE;
    }

    @Deprecated
    public STSClient create(STSClientConfig config) {
        return this.createPool(0, config);
    }

    public STSClient createPool(STSClientConfig config) {
        return this.createPool(0, config);
    }

    public STSClient createPool(int initialNumberOfClients, STSClientConfig config) {
        if (this.stsClientPool.isPoolingDisabled()) {
            return new STSClient(config);
        }
        this.stsClientPool.initialize(initialNumberOfClients, config);
        return this.stsClientPool.takeOut(config);
    }

    public STSClient createPool(int initialNumberOfClients, STSClientCreationCallBack callBack) {
        if (this.stsClientPool.isPoolingDisabled()) {
            return callBack.createClient();
        }
        this.stsClientPool.initialize(initialNumberOfClients, callBack);
        return this.stsClientPool.takeOut(callBack.getKey());
    }

    public void returnClient(STSClient stsClient) {
        if (!this.stsClientPool.isPoolingDisabled()) {
            this.stsClientPool.putIn(stsClient);
        }
    }

    public STSClient getClient(STSClientConfig config) {
        if (this.stsClientPool.isPoolingDisabled()) {
            return new STSClient(config);
        }
        return this.stsClientPool.takeOut(config);
    }

    public boolean configExists(STSClientConfig config) {
        return this.stsClientPool.isConfigInitialized(config);
    }

    private static class LazySTSClientFactory {
        private static final STSClientFactory INSTANCE = new STSClientFactory();

        private LazySTSClientFactory() {
        }
    }
}

