/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.util;

import java.io.InputStream;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.exceptions.ParsingException;
import org.picketlink.config.PicketLinkConfigParser;
import org.picketlink.config.federation.IDPType;
import org.picketlink.config.federation.PicketLinkType;
import org.picketlink.config.federation.SPType;
import org.picketlink.config.federation.handler.Handlers;
import org.picketlink.config.federation.parsers.SAMLConfigParser;

public class ConfigurationUtil {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();

    public static PicketLinkType getConfiguration(InputStream is) throws ParsingException {
        if (is == null) {
            throw logger.nullArgumentError("inputstream");
        }
        PicketLinkConfigParser parser = new PicketLinkConfigParser();
        PicketLinkType picketLinkType = (PicketLinkType)parser.parse(is);
        return picketLinkType;
    }

    public static IDPType getIDPConfiguration(InputStream is) throws ParsingException {
        if (is == null) {
            throw logger.nullArgumentError("inputstream");
        }
        SAMLConfigParser parser = new SAMLConfigParser();
        return (IDPType)parser.parse(is);
    }

    public static SPType getSPConfiguration(InputStream is) throws ParsingException {
        if (is == null) {
            throw logger.nullArgumentError("inputstream");
        }
        return (SPType)new SAMLConfigParser().parse(is);
    }

    public static Handlers getHandlers(InputStream is) throws ParsingException {
        if (is == null) {
            throw logger.nullArgumentError("inputstream");
        }
        return (Handlers)new SAMLConfigParser().parse(is);
    }
}

