/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.web.filters;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.constants.JBossSAMLConstants;
import org.picketlink.common.constants.JBossSAMLURIConstants;
import org.picketlink.common.exceptions.ConfigurationException;
import org.picketlink.common.exceptions.ParsingException;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.common.exceptions.fed.IssuerNotTrustedException;
import org.picketlink.common.util.StaxUtil;
import org.picketlink.common.util.StringUtil;
import org.picketlink.common.util.SystemPropertiesUtil;
import org.picketlink.config.federation.AuthPropertyType;
import org.picketlink.config.federation.IDPType;
import org.picketlink.config.federation.KeyProviderType;
import org.picketlink.config.federation.PicketLinkType;
import org.picketlink.config.federation.ProviderType;
import org.picketlink.config.federation.handler.Handlers;
import org.picketlink.identity.federation.core.audit.PicketLinkAuditEvent;
import org.picketlink.identity.federation.core.audit.PicketLinkAuditEventType;
import org.picketlink.identity.federation.core.audit.PicketLinkAuditHelper;
import org.picketlink.identity.federation.core.impl.DelegatedAttributeManager;
import org.picketlink.identity.federation.core.interfaces.AttributeManager;
import org.picketlink.identity.federation.core.interfaces.RoleGenerator;
import org.picketlink.identity.federation.core.interfaces.TrustKeyManager;
import org.picketlink.identity.federation.core.saml.v1.SAML11ProtocolContext;
import org.picketlink.identity.federation.core.saml.v1.writers.SAML11ResponseWriter;
import org.picketlink.identity.federation.core.saml.v2.common.IDGenerator;
import org.picketlink.identity.federation.core.saml.v2.common.SAMLDocumentHolder;
import org.picketlink.identity.federation.core.saml.v2.factories.SAML2HandlerChainFactory;
import org.picketlink.identity.federation.core.saml.v2.holders.IssuerInfoHolder;
import org.picketlink.identity.federation.core.saml.v2.impl.DefaultSAML2HandlerChainConfig;
import org.picketlink.identity.federation.core.saml.v2.impl.DefaultSAML2HandlerRequest;
import org.picketlink.identity.federation.core.saml.v2.impl.DefaultSAML2HandlerResponse;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2Handler;
import org.picketlink.identity.federation.core.saml.v2.interfaces.SAML2HandlerChain;
import org.picketlink.identity.federation.core.saml.v2.util.AssertionUtil;
import org.picketlink.identity.federation.core.saml.v2.util.DocumentUtil;
import org.picketlink.identity.federation.core.saml.v2.util.HandlerUtil;
import org.picketlink.identity.federation.core.saml.v2.util.XMLTimeUtil;
import org.picketlink.identity.federation.core.sts.PicketLinkCoreSTS;
import org.picketlink.identity.federation.core.util.CoreConfigUtil;
import org.picketlink.identity.federation.core.util.XMLSignatureUtil;
import org.picketlink.identity.federation.core.wstrust.PicketLinkSTSConfiguration;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11AssertionType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11AttributeStatementType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11AttributeType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11NameIdentifierType;
import org.picketlink.identity.federation.saml.v1.assertion.SAML11SubjectType;
import org.picketlink.identity.federation.saml.v1.protocol.SAML11ResponseType;
import org.picketlink.identity.federation.saml.v1.protocol.SAML11StatusType;
import org.picketlink.identity.federation.saml.v2.SAML2Object;
import org.picketlink.identity.federation.saml.v2.metadata.EntityDescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.SPSSODescriptorType;
import org.picketlink.identity.federation.saml.v2.protocol.AuthnRequestType;
import org.picketlink.identity.federation.saml.v2.protocol.RequestAbstractType;
import org.picketlink.identity.federation.saml.v2.protocol.StatusResponseType;
import org.picketlink.identity.federation.web.config.AbstractSAMLConfigurationProvider;
import org.picketlink.identity.federation.web.core.HTTPContext;
import org.picketlink.identity.federation.web.core.IdentityParticipantStack;
import org.picketlink.identity.federation.web.core.IdentityServer;
import org.picketlink.identity.federation.web.filters.SecurityActions;
import org.picketlink.identity.federation.web.util.ConfigurationUtil;
import org.picketlink.identity.federation.web.util.IDPWebRequestUtil;
import org.picketlink.identity.federation.web.util.RedirectBindingUtil;
import org.picketlink.identity.federation.web.util.SAMLConfigurationProvider;
import org.w3c.dom.Document;

public class IDPFilter
implements Filter {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    protected ServletContext servletContext;
    protected boolean enableAudit = false;
    protected PicketLinkAuditHelper auditHelper = null;
    protected IDPType idpConfiguration = null;
    protected PicketLinkType picketLinkConfiguration = null;
    private RoleGenerator roleGenerator = null;
    private TrustKeyManager keyManager;
    private transient DelegatedAttributeManager attribManager = new DelegatedAttributeManager();
    private final List<String> attributeKeys = new ArrayList<String>();
    private transient SAML2HandlerChain chain = null;
    protected SAMLConfigurationProvider configProvider = null;
    protected int timerInterval = -1;
    protected Timer timer = null;
    protected String authMethod = "PASSWORD";
    private String configFile;
    private final Lock chainLock = new ReentrantLock();
    private Map<String, SPSSODescriptorType> spSSOMetadataMap = new HashMap<String, SPSSODescriptorType>();
    private Handlers handlers;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.servletContext = filterConfig.getServletContext();
        this.configureConfigurationProvider();
        this.configureAuditHelper();
        this.startPicketLink();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        if (this.isUnauthorized(httpServletResponse)) {
            this.handleUnauthorizedResponse(httpServletRequest, httpServletResponse);
            return;
        }
        Principal userPrincipal = this.getUserPrincipal(httpServletRequest, httpServletResponse);
        if (userPrincipal != null) {
            this.handleSAMLMessage(httpServletRequest, httpServletResponse, chain);
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }

    private void handleSAMLMessage(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.hasSAML11Target(request)) {
            this.handleSAML11(request, response);
        } else {
            HttpSession session = request.getSession();
            String samlRequestMessage = request.getParameter("SAMLRequest");
            String samlResponseMessage = request.getParameter("SAMLResponse");
            String relayState = request.getParameter("RelayState");
            String signature = request.getParameter("Signature");
            String sigAlg = request.getParameter("SigAlg");
            if (logger.isTraceEnabled()) {
                StringBuilder builder = new StringBuilder();
                builder.append("Retrieved saml messages and relay state from session");
                builder.append("saml Request message=").append(samlRequestMessage);
                builder.append("::").append("SAMLResponseMessage=");
                builder.append(samlResponseMessage).append(":").append("relay state=").append(relayState);
                builder.append("Signature=").append(signature).append("::sigAlg=").append(sigAlg);
                logger.trace(builder.toString());
            }
            if (StringUtil.isNotNull((String)samlRequestMessage)) {
                this.processSAMLRequestMessage(request, response);
            } else if (StringUtil.isNotNull((String)samlResponseMessage)) {
                this.processSAMLResponseMessage(request, response);
            } else if (request.getRequestURI().equals(request.getContextPath() + "/")) {
                this.forwardHosted(request, response);
            } else {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            }
        }
    }

    private boolean hasSAML11Target(HttpServletRequest request) {
        return StringUtil.isNotNull((String)request.getParameter(JBossSAMLConstants.UNSOLICITED_RESPONSE_TARGET.get()));
    }

    private void forwardHosted(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        logger.trace("SAML 1.1::Proceeding to IDP index page");
        RequestDispatcher dispatch = this.servletContext.getRequestDispatcher(this.idpConfiguration.getHostedURI());
        this.recycle(response);
        try {
            this.includeResource((ServletRequest)request, response, dispatch);
        }
        catch (ClassCastException cce) {
            throw new IOException(cce);
        }
    }

    private void includeResource(ServletRequest request, HttpServletResponse response, RequestDispatcher dispatch) throws ServletException, IOException {
        dispatch.include(request, (ServletResponse)response);
    }

    private void populateSessionWithSAMLParameters(HttpServletRequest request) throws IOException {
        String samlRequestMessage = request.getParameter("SAMLRequest");
        String samlResponseMessage = request.getParameter("SAMLResponse");
        boolean containsSAMLRequestMessage = StringUtil.isNotNull((String)samlRequestMessage);
        boolean containsSAMLResponseMessage = StringUtil.isNotNull((String)samlResponseMessage);
        String signature = request.getParameter("Signature");
        String sigAlg = request.getParameter("SigAlg");
        String relayState = request.getParameter("RelayState");
        if (StringUtil.isNotNull((String)relayState)) {
            relayState = RedirectBindingUtil.urlDecode(relayState);
        }
        HttpSession session = request.getSession();
        if (containsSAMLRequestMessage || containsSAMLResponseMessage) {
            logger.trace("Storing the SAMLRequest/SAMLResponse and RelayState in session");
            if (StringUtil.isNotNull((String)samlRequestMessage)) {
                session.setAttribute("SAMLRequest", (Object)samlRequestMessage);
            }
            if (StringUtil.isNotNull((String)samlResponseMessage)) {
                session.setAttribute("SAMLResponse", (Object)samlResponseMessage);
            }
            if (StringUtil.isNotNull((String)relayState)) {
                session.setAttribute("RelayState", (Object)relayState.trim());
            }
            if (StringUtil.isNotNull((String)signature)) {
                session.setAttribute("Signature", (Object)signature.trim());
            }
            if (StringUtil.isNotNull((String)sigAlg)) {
                session.setAttribute("SigAlg", (Object)sigAlg.trim());
            }
        }
    }

    private void handleUnauthorizedResponse(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        IDPWebRequestUtil webRequestUtil = new IDPWebRequestUtil(request, this.idpConfiguration, this.keyManager);
        Document samlErrorResponse = null;
        String referer = request.getHeader("Referer");
        String relayState = request.getParameter("RelayState");
        if (StringUtil.isNotNull((String)relayState)) {
            relayState = RedirectBindingUtil.urlDecode(relayState);
        }
        try {
            samlErrorResponse = webRequestUtil.getErrorResponse(referer, JBossSAMLURIConstants.STATUS_AUTHNFAILED.get(), this.getIdentityURL(), this.idpConfiguration.isSupportsSignature());
            IDPWebRequestUtil.WebRequestUtilHolder holder = webRequestUtil.getHolder();
            holder.setResponseDoc(samlErrorResponse).setDestination(referer).setRelayState(relayState).setAreWeSendingRequest(false).setPrivateKey(null).setSupportSignature(false).setServletResponse(response).setErrorResponse(true);
            holder.setPostBindingRequested(webRequestUtil.hasSAMLRequestInPostProfile());
            if (this.idpConfiguration.isSupportsSignature()) {
                holder.setSupportSignature(true).setPrivateKey(this.keyManager.getSigningKey());
            }
            holder.setStrictPostBinding(this.idpConfiguration.isStrictPostBinding());
            webRequestUtil.send(holder);
        }
        catch (GeneralSecurityException e) {
            throw new ServletException((Throwable)e);
        }
    }

    private boolean isUnauthorized(HttpServletResponse response) {
        return response.getStatus() == 403;
    }

    private Principal getUserPrincipal(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Principal userPrincipal = request.getUserPrincipal();
        if (userPrincipal == null) {
            userPrincipal = request.getUserPrincipal();
        }
        return userPrincipal;
    }

    protected void handleSAML11(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            List<String> roles;
            SAML11AttributeStatementType attributeStatement;
            IDPWebRequestUtil webRequestUtil = new IDPWebRequestUtil(request, this.idpConfiguration, this.keyManager);
            Principal userPrincipal = request.getUserPrincipal();
            String contextPath = this.servletContext.getContextPath();
            String target = request.getParameter(JBossSAMLConstants.UNSOLICITED_RESPONSE_TARGET.get());
            HttpSession session = request.getSession();
            SAML11AssertionType saml11Assertion = (SAML11AssertionType)session.getAttribute("SAML11");
            if (saml11Assertion == null) {
                SAML11ProtocolContext saml11Protocol = new SAML11ProtocolContext();
                saml11Protocol.setIssuerID(this.getIdentityURL());
                SAML11SubjectType subject = new SAML11SubjectType();
                SAML11SubjectType.SAML11SubjectTypeChoice subjectChoice = new SAML11SubjectType.SAML11SubjectTypeChoice(new SAML11NameIdentifierType(userPrincipal.getName()));
                subject.setChoice(subjectChoice);
                saml11Protocol.setSubjectType(subject);
                PicketLinkCoreSTS.instance().issueToken(saml11Protocol);
                saml11Assertion = saml11Protocol.getIssuedAssertion();
                session.setAttribute("SAML11", (Object)saml11Assertion);
                if (AssertionUtil.hasExpired(saml11Assertion)) {
                    saml11Protocol.setIssuedAssertion(saml11Assertion);
                    PicketLinkCoreSTS.instance().renewToken(saml11Protocol);
                    saml11Assertion = saml11Protocol.getIssuedAssertion();
                    session.setAttribute("SAML11", (Object)saml11Assertion);
                }
            }
            if ((attributeStatement = this.createAttributeStatement(roles = this.roleGenerator.generateRoles(userPrincipal))) != null) {
                saml11Assertion.add(attributeStatement);
            }
            String id = IDGenerator.create("ID_");
            SAML11ResponseType saml11Response = new SAML11ResponseType(id, XMLTimeUtil.getIssueInstant());
            saml11Response.add(saml11Assertion);
            saml11Response.setStatus(SAML11StatusType.successType());
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            SAML11ResponseWriter writer = new SAML11ResponseWriter(StaxUtil.getXMLStreamWriter((OutputStream)baos));
            writer.write(saml11Response);
            Document samlResponse = DocumentUtil.getDocument((InputStream)new ByteArrayInputStream(baos.toByteArray()));
            IDPWebRequestUtil.WebRequestUtilHolder holder = webRequestUtil.getHolder();
            holder.setResponseDoc(samlResponse).setDestination(target).setRelayState("").setAreWeSendingRequest(false).setPrivateKey(null).setSupportSignature(false).setServletResponse(response);
            if (this.enableAudit) {
                PicketLinkAuditEvent auditEvent = new PicketLinkAuditEvent("Info");
                auditEvent.setType(PicketLinkAuditEventType.RESPONSE_TO_SP);
                auditEvent.setDestination(target);
                auditEvent.setWhoIsAuditing(contextPath);
                this.auditHelper.audit(auditEvent);
            }
            this.recycle(response);
            webRequestUtil.send(holder);
        }
        catch (GeneralSecurityException e) {
            logger.samlIDPHandlingSAML11Error((Throwable)e);
            throw new ServletException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void processSAMLRequestMessage(HttpServletRequest request, HttpServletResponse response) throws IOException {
        block54: {
            Principal userPrincipal = request.getUserPrincipal();
            HttpSession session = request.getSession();
            SAMLDocumentHolder samlDocumentHolder = null;
            SAML2Object samlObject = null;
            Document samlResponse = null;
            boolean isErrorResponse = false;
            String destination = null;
            String destinationQueryStringWithSignature = null;
            Boolean requestedPostProfile = null;
            String samlRequestMessage = request.getParameter("SAMLRequest");
            String relayState = request.getParameter("RelayState");
            String contextPath = this.servletContext.getContextPath();
            boolean willSendRequest = false;
            String referer = request.getHeader("Referer");
            boolean isSecure = request.isSecure();
            String loginType = this.determineLoginType(isSecure);
            IDPWebRequestUtil webRequestUtil = new IDPWebRequestUtil(request, this.idpConfiguration, this.keyManager);
            samlDocumentHolder = webRequestUtil.getSAMLDocumentHolder(samlRequestMessage);
            samlObject = samlDocumentHolder.getSamlObject();
            if (!(samlObject instanceof RequestAbstractType)) {
                throw logger.wrongTypeError(samlObject.getClass().getName());
            }
            RequestAbstractType requestAbstractType = (RequestAbstractType)samlObject;
            String issuer = requestAbstractType.getIssuer().getValue();
            if (samlRequestMessage == null) {
                throw logger.samlIDPValidationCheckFailed();
            }
            IssuerInfoHolder idpIssuer = new IssuerInfoHolder(this.getIdentityURL());
            HTTPContext protocolContext = new HTTPContext(request, response, this.servletContext);
            DefaultSAML2HandlerRequest saml2HandlerRequest = new DefaultSAML2HandlerRequest(protocolContext, idpIssuer.getIssuer(), samlDocumentHolder, SAML2Handler.HANDLER_TYPE.IDP);
            saml2HandlerRequest.setRelayState(relayState);
            if (StringUtil.isNotNull((String)loginType)) {
                saml2HandlerRequest.addOption("LOGIN_TYPE", loginType);
            }
            String assertionID = (String)session.getAttribute("ASSERTION_ID");
            HashMap<String, Object> requestOptions = new HashMap<String, Object>();
            requestOptions.put("IGNORE_SIGNATURES", this.willIgnoreSignatureOfCurrentRequest(issuer));
            requestOptions.put("SP_SSO_METADATA_DESCRIPTOR", this.spSSOMetadataMap.get(issuer));
            requestOptions.put("ROLE_GENERATOR", this.roleGenerator);
            requestOptions.put("CONFIGURATION", this.idpConfiguration);
            requestOptions.put("SAML_IDP_STRICT_POST_BINDING", this.idpConfiguration.isStrictPostBinding());
            requestOptions.put("SUPPORTS_SIGNATURES", this.idpConfiguration.isSupportsSignature());
            if (assertionID != null) {
                requestOptions.put("ASSERTION_ID", assertionID);
            }
            if (this.keyManager != null) {
                PublicKey validatingKey = this.getIssuerPublicKey(request, issuer);
                requestOptions.put("SENDER_PUBLIC_KEY", validatingKey);
                requestOptions.put("DECRYPTING_KEY", this.keyManager.getSigningKey());
            }
            if (requestAbstractType instanceof AuthnRequestType) {
                List<String> roles = this.roleGenerator.generateRoles(userPrincipal);
                session.setAttribute("picketlink.roles", roles);
                Map<String, Object> attribs = this.attribManager.getAttributes(userPrincipal, this.attributeKeys);
                requestOptions.put("ATTRIBUTES", attribs);
            }
            if (this.auditHelper != null) {
                requestOptions.put("AUDIT_HELPER", this.auditHelper);
                requestOptions.put("CONTEXT_PATH", contextPath);
            }
            saml2HandlerRequest.setOptions(requestOptions);
            DefaultSAML2HandlerResponse saml2HandlerResponse = new DefaultSAML2HandlerResponse();
            Set<SAML2Handler> handlers = this.chain.handlers();
            logger.trace("Handlers are=" + handlers);
            if (handlers != null) {
                try {
                    if (this.getConfiguration().getHandlers().isLocking()) {
                        this.chainLock.lock();
                    }
                    for (SAML2Handler handler : handlers) {
                        handler.handleRequestType(saml2HandlerRequest, saml2HandlerResponse);
                        willSendRequest = saml2HandlerResponse.getSendRequest();
                    }
                }
                finally {
                    if (this.getConfiguration().getHandlers().isLocking()) {
                        this.chainLock.unlock();
                    }
                }
            }
            samlResponse = saml2HandlerResponse.getResultingDocument();
            relayState = saml2HandlerResponse.getRelayState();
            destination = saml2HandlerResponse.getDestination();
            requestedPostProfile = saml2HandlerResponse.isPostBindingForResponse();
            destinationQueryStringWithSignature = saml2HandlerResponse.getDestinationQueryStringWithSignature();
            try {
                if (destination == null && samlObject instanceof AuthnRequestType) {
                    AuthnRequestType authRequest = (AuthnRequestType)samlObject;
                    destination = authRequest.getAssertionConsumerServiceURL().toASCIIString();
                }
                if (destination == null) {
                    response.sendRedirect(this.getIdentityURL());
                    break block54;
                }
                IDPWebRequestUtil.WebRequestUtilHolder holder = webRequestUtil.getHolder();
                holder.setResponseDoc(samlResponse).setDestination(destination).setRelayState(relayState).setAreWeSendingRequest(willSendRequest).setPrivateKey(null).setSupportSignature(false).setErrorResponse(isErrorResponse).setServletResponse(response).setDestinationQueryStringWithSignature(destinationQueryStringWithSignature);
                holder.setStrictPostBinding(this.idpConfiguration.isStrictPostBinding());
                if (requestedPostProfile != null) {
                    holder.setPostBindingRequested(requestedPostProfile);
                } else {
                    holder.setPostBindingRequested(webRequestUtil.hasSAMLRequestInPostProfile());
                }
                if (this.idpConfiguration.isSupportsSignature()) {
                    holder.setPrivateKey(this.keyManager.getSigningKey()).setSupportSignature(true);
                }
                if (holder.isPostBinding()) {
                    this.recycle(response);
                }
                if (this.enableAudit) {
                    PicketLinkAuditEvent auditEvent = new PicketLinkAuditEvent("Info");
                    auditEvent.setType(PicketLinkAuditEventType.RESPONSE_TO_SP);
                    auditEvent.setDestination(destination);
                    auditEvent.setWhoIsAuditing(contextPath);
                    this.auditHelper.audit(auditEvent);
                }
                webRequestUtil.send(holder);
            }
            catch (ParsingException e) {
                logger.samlAssertionPasingFailed((Throwable)e);
            }
            catch (GeneralSecurityException e) {
                logger.trace("Security Exception:", (Throwable)e);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
            }
            break block54;
            catch (Exception e) {
                try {
                    String status = JBossSAMLURIConstants.STATUS_AUTHNFAILED.get();
                    if (e instanceof IssuerNotTrustedException || e.getCause() instanceof IssuerNotTrustedException) {
                        status = JBossSAMLURIConstants.STATUS_REQUEST_DENIED.get();
                    }
                    logger.samlIDPRequestProcessingError((Throwable)e);
                    samlResponse = webRequestUtil.getErrorResponse(referer, status, this.getIdentityURL(), this.idpConfiguration.isSupportsSignature());
                    isErrorResponse = true;
                }
                catch (Throwable throwable) {
                    try {
                        if (destination == null && samlObject instanceof AuthnRequestType) {
                            AuthnRequestType authRequest = (AuthnRequestType)samlObject;
                            destination = authRequest.getAssertionConsumerServiceURL().toASCIIString();
                        }
                        if (destination == null) {
                            response.sendRedirect(this.getIdentityURL());
                        } else {
                            IDPWebRequestUtil.WebRequestUtilHolder holder = webRequestUtil.getHolder();
                            holder.setResponseDoc(samlResponse).setDestination(destination).setRelayState(relayState).setAreWeSendingRequest(willSendRequest).setPrivateKey(null).setSupportSignature(false).setErrorResponse(isErrorResponse).setServletResponse(response).setDestinationQueryStringWithSignature(destinationQueryStringWithSignature);
                            holder.setStrictPostBinding(this.idpConfiguration.isStrictPostBinding());
                            if (requestedPostProfile != null) {
                                holder.setPostBindingRequested(requestedPostProfile);
                            } else {
                                holder.setPostBindingRequested(webRequestUtil.hasSAMLRequestInPostProfile());
                            }
                            if (this.idpConfiguration.isSupportsSignature()) {
                                holder.setPrivateKey(this.keyManager.getSigningKey()).setSupportSignature(true);
                            }
                            if (holder.isPostBinding()) {
                                this.recycle(response);
                            }
                            if (this.enableAudit) {
                                PicketLinkAuditEvent auditEvent = new PicketLinkAuditEvent("Info");
                                auditEvent.setType(PicketLinkAuditEventType.RESPONSE_TO_SP);
                                auditEvent.setDestination(destination);
                                auditEvent.setWhoIsAuditing(contextPath);
                                this.auditHelper.audit(auditEvent);
                            }
                            webRequestUtil.send(holder);
                        }
                    }
                    catch (ParsingException e2) {
                        logger.samlAssertionPasingFailed((Throwable)e2);
                    }
                    catch (GeneralSecurityException e3) {
                        logger.trace("Security Exception:", (Throwable)e3);
                    }
                    catch (Exception e4) {
                        logger.error((Throwable)e4);
                    }
                    throw throwable;
                }
                try {
                    if (destination == null && samlObject instanceof AuthnRequestType) {
                        AuthnRequestType authRequest = (AuthnRequestType)samlObject;
                        destination = authRequest.getAssertionConsumerServiceURL().toASCIIString();
                    }
                    if (destination == null) {
                        response.sendRedirect(this.getIdentityURL());
                    }
                    IDPWebRequestUtil.WebRequestUtilHolder holder = webRequestUtil.getHolder();
                    holder.setResponseDoc(samlResponse).setDestination(destination).setRelayState(relayState).setAreWeSendingRequest(willSendRequest).setPrivateKey(null).setSupportSignature(false).setErrorResponse(isErrorResponse).setServletResponse(response).setDestinationQueryStringWithSignature(destinationQueryStringWithSignature);
                    holder.setStrictPostBinding(this.idpConfiguration.isStrictPostBinding());
                    if (requestedPostProfile != null) {
                        holder.setPostBindingRequested(requestedPostProfile);
                    } else {
                        holder.setPostBindingRequested(webRequestUtil.hasSAMLRequestInPostProfile());
                    }
                    if (this.idpConfiguration.isSupportsSignature()) {
                        holder.setPrivateKey(this.keyManager.getSigningKey()).setSupportSignature(true);
                    }
                    if (holder.isPostBinding()) {
                        this.recycle(response);
                    }
                    if (this.enableAudit) {
                        PicketLinkAuditEvent auditEvent = new PicketLinkAuditEvent("Info");
                        auditEvent.setType(PicketLinkAuditEventType.RESPONSE_TO_SP);
                        auditEvent.setDestination(destination);
                        auditEvent.setWhoIsAuditing(contextPath);
                        this.auditHelper.audit(auditEvent);
                    }
                    webRequestUtil.send(holder);
                }
                catch (ParsingException e5) {
                    logger.samlAssertionPasingFailed((Throwable)e5);
                }
                catch (GeneralSecurityException e6) {
                    logger.trace("Security Exception:", (Throwable)e6);
                }
                catch (Exception e7) {
                    logger.error((Throwable)e7);
                }
            }
        }
    }

    private PublicKey getIssuerPublicKey(HttpServletRequest request, String issuer) throws ConfigurationException, ProcessingException {
        String issuerHost = null;
        PublicKey issuerPublicKey = null;
        try {
            issuerHost = new URL(issuer).getHost();
        }
        catch (MalformedURLException e) {
            logger.trace("Token issuer is not a valid URL: " + issuer, (Throwable)e);
            issuerHost = issuer;
        }
        logger.trace("Trying to find a PK for issuer: " + issuerHost);
        try {
            issuerPublicKey = CoreConfigUtil.getValidatingKey(this.keyManager, issuerHost);
        }
        catch (IllegalStateException ise) {
            logger.trace("Token issuer is not found for: " + issuer, (Throwable)ise);
        }
        if (issuerPublicKey == null) {
            issuerHost = request.getRemoteAddr();
            logger.trace("Trying to find a PK for issuer " + issuerHost);
            issuerPublicKey = CoreConfigUtil.getValidatingKey(this.keyManager, issuerHost);
        }
        logger.trace("Using Validating Alias=" + issuerHost + " to check signatures.");
        return issuerPublicKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void processSAMLResponseMessage(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block37: {
            boolean isValid;
            HttpSession session = request.getSession();
            SAMLDocumentHolder samlDocumentHolder = null;
            SAML2Object samlObject = null;
            Document samlResponse = null;
            boolean isErrorResponse = false;
            String destination = null;
            String destinationQueryStringWithSignature = null;
            String contextPath = this.servletContext.getContextPath();
            boolean requestedPostProfile = false;
            String samlResponseMessage = request.getParameter("SAMLResponse");
            String relayState = request.getParameter("RelayState");
            boolean willSendRequest = false;
            String referer = request.getHeader("Referer");
            IDPWebRequestUtil webRequestUtil = new IDPWebRequestUtil(request, this.idpConfiguration, this.keyManager);
            samlDocumentHolder = webRequestUtil.getSAMLDocumentHolder(samlResponseMessage);
            samlObject = samlDocumentHolder.getSamlObject();
            if (!(samlObject instanceof StatusResponseType)) {
                throw logger.wrongTypeError(samlObject.getClass().getName());
            }
            StatusResponseType statusResponseType = (StatusResponseType)samlObject;
            String issuer = statusResponseType.getIssuer().getValue();
            boolean bl = isValid = samlResponseMessage != null;
            if (!isValid) {
                throw logger.samlIDPValidationCheckFailed();
            }
            IssuerInfoHolder idpIssuer = new IssuerInfoHolder(this.getIdentityURL());
            HTTPContext protocolContext = new HTTPContext(request, response, this.servletContext);
            DefaultSAML2HandlerRequest saml2HandlerRequest = new DefaultSAML2HandlerRequest(protocolContext, idpIssuer.getIssuer(), samlDocumentHolder, SAML2Handler.HANDLER_TYPE.IDP);
            HashMap<String, Object> options = new HashMap<String, Object>();
            if (this.idpConfiguration.isSupportsSignature() || this.idpConfiguration.isEncrypt()) {
                PublicKey publicKey = this.getIssuerPublicKey(request, issuer);
                options.put("SENDER_PUBLIC_KEY", publicKey);
            }
            options.put("SAML_IDP_STRICT_POST_BINDING", this.idpConfiguration.isStrictPostBinding());
            options.put("SUPPORTS_SIGNATURES", this.idpConfiguration.isSupportsSignature());
            if (this.auditHelper != null) {
                options.put("AUDIT_HELPER", this.auditHelper);
                options.put("CONTEXT_PATH", contextPath);
            }
            saml2HandlerRequest.setOptions(options);
            saml2HandlerRequest.setRelayState(relayState);
            DefaultSAML2HandlerResponse saml2HandlerResponse = new DefaultSAML2HandlerResponse();
            Set<SAML2Handler> handlers = this.chain.handlers();
            if (handlers != null) {
                try {
                    this.chainLock.lock();
                    for (SAML2Handler handler : handlers) {
                        handler.reset();
                        handler.handleStatusResponseType(saml2HandlerRequest, saml2HandlerResponse);
                        willSendRequest = saml2HandlerResponse.getSendRequest();
                    }
                }
                finally {
                    this.chainLock.unlock();
                }
            }
            samlResponse = saml2HandlerResponse.getResultingDocument();
            relayState = saml2HandlerResponse.getRelayState();
            destination = saml2HandlerResponse.getDestination();
            requestedPostProfile = saml2HandlerResponse.isPostBindingForResponse();
            destinationQueryStringWithSignature = saml2HandlerResponse.getDestinationQueryStringWithSignature();
            try {
                IDPWebRequestUtil.WebRequestUtilHolder holder = webRequestUtil.getHolder();
                if (destination == null) {
                    throw new ServletException((Throwable)logger.nullValueError("Destination"));
                }
                holder.setResponseDoc(samlResponse).setDestination(destination).setRelayState(relayState).setAreWeSendingRequest(willSendRequest).setPrivateKey(null).setSupportSignature(false).setErrorResponse(isErrorResponse).setServletResponse(response).setPostBindingRequested(requestedPostProfile).setDestinationQueryStringWithSignature(destinationQueryStringWithSignature);
                if (this.idpConfiguration.isSupportsSignature()) {
                    holder.setPrivateKey(this.keyManager.getSigningKey()).setSupportSignature(true);
                }
                holder.setStrictPostBinding(this.idpConfiguration.isStrictPostBinding());
                if (holder.isPostBinding()) {
                    this.recycle(response);
                }
                if (this.enableAudit) {
                    PicketLinkAuditEvent auditEvent = new PicketLinkAuditEvent("Info");
                    auditEvent.setType(PicketLinkAuditEventType.RESPONSE_TO_SP);
                    auditEvent.setWhoIsAuditing(contextPath);
                    auditEvent.setDestination(destination);
                    this.auditHelper.audit(auditEvent);
                }
                webRequestUtil.send(holder);
            }
            catch (ParsingException e) {
                logger.samlAssertionPasingFailed((Throwable)e);
            }
            catch (GeneralSecurityException e) {
                logger.trace("Security Exception:", (Throwable)e);
            }
            break block37;
            catch (Exception e) {
                try {
                    String status = JBossSAMLURIConstants.STATUS_AUTHNFAILED.get();
                    if (e instanceof IssuerNotTrustedException) {
                        status = JBossSAMLURIConstants.STATUS_REQUEST_DENIED.get();
                    }
                    logger.samlIDPRequestProcessingError((Throwable)e);
                    samlResponse = webRequestUtil.getErrorResponse(referer, status, this.getIdentityURL(), this.idpConfiguration.isSupportsSignature());
                    isErrorResponse = true;
                }
                catch (Throwable throwable) {
                    try {
                        IDPWebRequestUtil.WebRequestUtilHolder holder = webRequestUtil.getHolder();
                        if (destination == null) {
                            throw new ServletException((Throwable)logger.nullValueError("Destination"));
                        }
                        holder.setResponseDoc(samlResponse).setDestination(destination).setRelayState(relayState).setAreWeSendingRequest(willSendRequest).setPrivateKey(null).setSupportSignature(false).setErrorResponse(isErrorResponse).setServletResponse(response).setPostBindingRequested(requestedPostProfile).setDestinationQueryStringWithSignature(destinationQueryStringWithSignature);
                        if (this.idpConfiguration.isSupportsSignature()) {
                            holder.setPrivateKey(this.keyManager.getSigningKey()).setSupportSignature(true);
                        }
                        holder.setStrictPostBinding(this.idpConfiguration.isStrictPostBinding());
                        if (holder.isPostBinding()) {
                            this.recycle(response);
                        }
                        if (this.enableAudit) {
                            PicketLinkAuditEvent auditEvent = new PicketLinkAuditEvent("Info");
                            auditEvent.setType(PicketLinkAuditEventType.RESPONSE_TO_SP);
                            auditEvent.setWhoIsAuditing(contextPath);
                            auditEvent.setDestination(destination);
                            this.auditHelper.audit(auditEvent);
                        }
                        webRequestUtil.send(holder);
                    }
                    catch (ParsingException e2) {
                        logger.samlAssertionPasingFailed((Throwable)e2);
                    }
                    catch (GeneralSecurityException e3) {
                        logger.trace("Security Exception:", (Throwable)e3);
                    }
                    throw throwable;
                }
                try {
                    IDPWebRequestUtil.WebRequestUtilHolder holder = webRequestUtil.getHolder();
                    if (destination == null) {
                        throw new ServletException((Throwable)logger.nullValueError("Destination"));
                    }
                    holder.setResponseDoc(samlResponse).setDestination(destination).setRelayState(relayState).setAreWeSendingRequest(willSendRequest).setPrivateKey(null).setSupportSignature(false).setErrorResponse(isErrorResponse).setServletResponse(response).setPostBindingRequested(requestedPostProfile).setDestinationQueryStringWithSignature(destinationQueryStringWithSignature);
                    if (this.idpConfiguration.isSupportsSignature()) {
                        holder.setPrivateKey(this.keyManager.getSigningKey()).setSupportSignature(true);
                    }
                    holder.setStrictPostBinding(this.idpConfiguration.isStrictPostBinding());
                    if (holder.isPostBinding()) {
                        this.recycle(response);
                    }
                    if (this.enableAudit) {
                        PicketLinkAuditEvent auditEvent = new PicketLinkAuditEvent("Info");
                        auditEvent.setType(PicketLinkAuditEventType.RESPONSE_TO_SP);
                        auditEvent.setWhoIsAuditing(contextPath);
                        auditEvent.setDestination(destination);
                        this.auditHelper.audit(auditEvent);
                    }
                    webRequestUtil.send(holder);
                }
                catch (ParsingException e4) {
                    logger.samlAssertionPasingFailed((Throwable)e4);
                }
                catch (GeneralSecurityException e5) {
                    logger.trace("Security Exception:", (Throwable)e5);
                }
            }
        }
    }

    protected void cleanUpSessionNote(HttpServletRequest request) {
        HttpSession session = request.getSession();
        String samlRequestMessage = (String)session.getAttribute("SAMLRequest");
        String samlResponseMessage = (String)session.getAttribute("SAMLResponse");
        String relayState = (String)session.getAttribute("RelayState");
        String signature = (String)session.getAttribute("Signature");
        String sigAlg = (String)session.getAttribute("SigAlg");
        if (logger.isTraceEnabled()) {
            StringBuilder builder = new StringBuilder();
            builder.append("Retrieved saml messages and relay state from session");
            builder.append("saml Request message=").append(samlRequestMessage);
            builder.append("::").append("SAMLResponseMessage=");
            builder.append(samlResponseMessage).append(":").append("relay state=").append(relayState);
            builder.append("Signature=").append(signature).append("::sigAlg=").append(sigAlg);
            logger.trace(builder.toString());
        }
        if (StringUtil.isNotNull((String)samlRequestMessage)) {
            session.removeAttribute("SAMLRequest");
        }
        if (StringUtil.isNotNull((String)samlResponseMessage)) {
            session.removeAttribute("SAMLResponse");
        }
        if (StringUtil.isNotNull((String)relayState)) {
            session.removeAttribute("RelayState");
        }
        if (StringUtil.isNotNull((String)signature)) {
            session.removeAttribute("Signature");
        }
        if (StringUtil.isNotNull((String)sigAlg)) {
            session.removeAttribute("SigAlg");
        }
    }

    protected void sendErrorResponseToSP(String referrer, HttpServletResponse response, String relayState, IDPWebRequestUtil webRequestUtil) throws ServletException, IOException, ConfigurationException {
        logger.trace("About to send error response to SP:" + referrer);
        String contextPath = this.servletContext.getContextPath();
        Document samlResponse = webRequestUtil.getErrorResponse(referrer, JBossSAMLURIConstants.STATUS_RESPONDER.get(), this.getIdentityURL(), this.idpConfiguration.isSupportsSignature());
        try {
            IDPWebRequestUtil.WebRequestUtilHolder holder = webRequestUtil.getHolder();
            holder.setResponseDoc(samlResponse).setDestination(referrer).setRelayState(relayState).setAreWeSendingRequest(false).setPrivateKey(null).setSupportSignature(false).setServletResponse(response);
            holder.setPostBindingRequested(webRequestUtil.hasSAMLRequestInPostProfile());
            if (this.idpConfiguration.isSupportsSignature()) {
                holder.setPrivateKey(this.keyManager.getSigningKey()).setSupportSignature(true);
            }
            holder.setStrictPostBinding(this.idpConfiguration.isStrictPostBinding());
            if (holder.isPostBinding()) {
                this.recycle(response);
            }
            if (this.enableAudit) {
                PicketLinkAuditEvent auditEvent = new PicketLinkAuditEvent("Info");
                auditEvent.setType(PicketLinkAuditEventType.ERROR_RESPONSE_TO_SP);
                auditEvent.setWhoIsAuditing(contextPath);
                auditEvent.setDestination(referrer);
                this.auditHelper.audit(auditEvent);
            }
            webRequestUtil.send(holder);
        }
        catch (ParsingException e1) {
            throw new ServletException((Throwable)e1);
        }
        catch (GeneralSecurityException e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected void initIdentityServer() {
        IdentityServer identityServer = (IdentityServer)this.servletContext.getAttribute("IDENTITY_SERVER");
        if (identityServer == null) {
            identityServer = new IdentityServer();
            this.servletContext.setAttribute("IDENTITY_SERVER", (Object)identityServer);
            if (StringUtil.isNotNull((String)this.idpConfiguration.getIdentityParticipantStack())) {
                try {
                    Class<?> clazz = SecurityActions.loadClass(this.getClass(), this.idpConfiguration.getIdentityParticipantStack());
                    if (clazz == null) {
                        throw logger.classNotLoadedError(this.idpConfiguration.getIdentityParticipantStack());
                    }
                    identityServer.setStack((IdentityParticipantStack)clazz.newInstance());
                }
                catch (Exception e) {
                    logger.samlIDPUnableToSetParticipantStackUsingDefault((Throwable)e);
                }
            }
        }
    }

    protected void initHandlersChain() {
        try {
            if (this.picketLinkConfiguration != null) {
                this.handlers = this.picketLinkConfiguration.getHandlers();
            } else {
                String handlerConfigFileName = "/WEB-INF/picketlink-handlers.xml";
                this.handlers = ConfigurationUtil.getHandlers(this.servletContext.getResourceAsStream(handlerConfigFileName));
            }
            String handlerChainClass = this.handlers.getHandlerChainClass();
            if (StringUtil.isNullOrEmpty((String)handlerChainClass)) {
                this.chain = SAML2HandlerChainFactory.createChain();
            } else {
                try {
                    this.chain = SAML2HandlerChainFactory.createChain(handlerChainClass);
                }
                catch (ProcessingException e1) {
                    throw new RuntimeException(e1);
                }
            }
            this.chain.addAll(HandlerUtil.getHandlers(this.handlers));
            HashMap<String, Object> chainConfigOptions = new HashMap<String, Object>();
            chainConfigOptions.put("ROLE_GENERATOR", this.roleGenerator);
            chainConfigOptions.put("CONFIGURATION", this.idpConfiguration);
            if (this.keyManager != null) {
                chainConfigOptions.put("KEYPAIR", this.keyManager.getSigningKeyPair());
            }
            DefaultSAML2HandlerChainConfig handlerChainConfig = new DefaultSAML2HandlerChainConfig(chainConfigOptions);
            Set<SAML2Handler> samlHandlers = this.chain.handlers();
            for (SAML2Handler handler : samlHandlers) {
                handler.initChainConfig(handlerChainConfig);
            }
        }
        catch (Exception e) {
            logger.samlHandlerConfigurationError((Throwable)e);
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    protected void initKeyManager() {
        if (this.idpConfiguration.isSupportsSignature() || this.idpConfiguration.isEncrypt()) {
            KeyProviderType keyProvider = this.idpConfiguration.getKeyProvider();
            if (keyProvider == null) {
                throw new RuntimeException(logger.nullValueError("Key Provider is null for context=" + this.servletContext.getContextPath()));
            }
            try {
                this.keyManager = CoreConfigUtil.getTrustKeyManager(keyProvider);
                List<AuthPropertyType> authProperties = CoreConfigUtil.getKeyProviderProperties(keyProvider);
                this.keyManager.setAuthProperties(authProperties);
                this.keyManager.setValidatingAlias(keyProvider.getValidatingAlias());
            }
            catch (Exception e) {
                logger.trustKeyManagerCreationError((Throwable)e);
                throw new RuntimeException(e.getLocalizedMessage());
            }
            logger.samlIDPSettingCanonicalizationMethod(this.idpConfiguration.getCanonicalizationMethod());
            XMLSignatureUtil.setCanonicalizationMethodType(this.idpConfiguration.getCanonicalizationMethod());
            logger.trace("Key Provider=" + keyProvider.getClassName());
        }
    }

    protected void initIDPConfiguration() {
        InputStream is = null;
        if (StringUtil.isNullOrEmpty((String)this.configFile)) {
            is = this.servletContext.getResourceAsStream("/WEB-INF/picketlink.xml");
        } else {
            try {
                is = new FileInputStream(this.configFile);
            }
            catch (FileNotFoundException e) {
                throw logger.samlIDPConfigurationError((Throwable)e);
            }
        }
        if (this.configProvider != null) {
            try {
                if (is == null) {
                    is = this.servletContext.getResourceAsStream("/WEB-INF/picketlink-idfed.xml");
                    if (is != null && this.configProvider instanceof AbstractSAMLConfigurationProvider) {
                        ((AbstractSAMLConfigurationProvider)this.configProvider).setConfigFile(is);
                    }
                } else if (is != null && this.configProvider instanceof AbstractSAMLConfigurationProvider) {
                    ((AbstractSAMLConfigurationProvider)this.configProvider).setConsolidatedConfigFile(is);
                }
                this.picketLinkConfiguration = this.configProvider.getPicketLinkConfiguration();
                this.idpConfiguration = this.configProvider.getIDPConfiguration();
            }
            catch (ProcessingException e) {
                throw logger.samlIDPConfigurationError((Throwable)e);
            }
            catch (ParsingException e) {
                throw logger.samlIDPConfigurationError((Throwable)e);
            }
        }
        if (this.idpConfiguration == null) {
            if (is != null) {
                try {
                    this.picketLinkConfiguration = ConfigurationUtil.getConfiguration(is);
                    this.idpConfiguration = (IDPType)this.picketLinkConfiguration.getIdpOrSP();
                }
                catch (ParsingException e) {
                    logger.trace((Throwable)e);
                    logger.samlIDPConfigurationError((Throwable)e);
                }
            }
            if (is == null) {
                is = this.servletContext.getResourceAsStream("/WEB-INF/picketlink-idfed.xml");
                if (is == null) {
                    throw logger.configurationFileMissing("/WEB-INF/picketlink-idfed.xml");
                }
                try {
                    this.idpConfiguration = ConfigurationUtil.getIDPConfiguration(is);
                }
                catch (ParsingException e) {
                    logger.samlIDPConfigurationError((Throwable)e);
                }
            }
        }
        try {
            List<EntityDescriptorType> entityDescriptors;
            String roleGeneratorAttribute;
            if (this.picketLinkConfiguration != null) {
                String sysProp;
                this.enableAudit = this.picketLinkConfiguration.isEnableAudit();
                if (!this.enableAudit && !"NULL".equals(sysProp = SecurityActions.getSystemProperty("picketlink.audit.enable", "NULL"))) {
                    this.enableAudit = Boolean.parseBoolean(sysProp);
                }
                if (this.enableAudit && this.auditHelper == null) {
                    String securityDomainName = PicketLinkAuditHelper.getSecurityDomainName(this.servletContext);
                    this.auditHelper = new PicketLinkAuditHelper(securityDomainName);
                }
            }
            logger.trace("Identity Provider URL=" + this.getIdentityURL());
            String attributeManager = this.idpConfiguration.getAttributeManager();
            if (attributeManager != null && !"".equals(attributeManager)) {
                Class<?> clazz = SecurityActions.loadClass(this.getClass(), attributeManager);
                if (clazz == null) {
                    throw new RuntimeException(logger.classNotLoadedError(attributeManager));
                }
                AttributeManager delegate = (AttributeManager)clazz.newInstance();
                this.attribManager.setDelegate(delegate);
            }
            if ((roleGeneratorAttribute = this.idpConfiguration.getRoleGenerator()) != null && !"".equals(roleGeneratorAttribute)) {
                Class<?> clazz = SecurityActions.loadClass(this.getClass(), roleGeneratorAttribute);
                if (clazz == null) {
                    throw new RuntimeException(logger.classNotLoadedError(roleGeneratorAttribute));
                }
                this.roleGenerator = (RoleGenerator)clazz.newInstance();
            }
            if ((entityDescriptors = CoreConfigUtil.getMetadataConfiguration((ProviderType)this.idpConfiguration, this.servletContext)) != null) {
                for (EntityDescriptorType entityDescriptorType : entityDescriptors) {
                    SPSSODescriptorType spSSODescriptor = CoreConfigUtil.getSPDescriptor(entityDescriptorType);
                    if (spSSODescriptor == null) continue;
                    this.spSSOMetadataMap.put(entityDescriptorType.getEntityID(), spSSODescriptor);
                }
            }
        }
        catch (Exception e) {
            throw logger.samlIDPConfigurationError((Throwable)e);
        }
        this.initHostedURI();
    }

    protected void initSTSConfiguration() {
        if (this.picketLinkConfiguration != null && this.picketLinkConfiguration.getStsType() != null) {
            PicketLinkCoreSTS sts = PicketLinkCoreSTS.instance();
            sts.initialize(new PicketLinkSTSConfiguration(this.picketLinkConfiguration.getStsType()));
        } else {
            File stsTokenConfigFile;
            PicketLinkCoreSTS sts = PicketLinkCoreSTS.instance();
            String configPath = this.servletContext.getRealPath("/WEB-INF/picketlink-sts.xml");
            File file = stsTokenConfigFile = configPath != null ? new File(configPath) : null;
            if (stsTokenConfigFile == null || !stsTokenConfigFile.exists()) {
                logger.samlIDPInstallingDefaultSTSConfig();
                sts.installDefaultConfiguration(new String[0]);
            } else {
                sts.installDefaultConfiguration(stsTokenConfigFile.toURI().toString());
            }
        }
    }

    protected String getIdentityURL() {
        return this.idpConfiguration.getIdentityURL();
    }

    protected String determineLoginType(boolean isSecure) {
        String result = JBossSAMLURIConstants.AC_PASSWORD.get();
        if (this.authMethod != null && StringUtil.isNotNull((String)this.authMethod)) {
            if ("CLIENT-CERT".equals(this.authMethod)) {
                result = JBossSAMLURIConstants.AC_TLS_CLIENT.get();
            } else if (isSecure) {
                result = JBossSAMLURIConstants.AC_PASSWORD_PROTECTED_TRANSPORT.get();
            }
        }
        return result;
    }

    protected void startPicketLink() {
        SystemPropertiesUtil.ensure();
        if (this.timerInterval > 0) {
            if (this.timer == null) {
                this.timer = new Timer();
            }
            this.timer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    IDPFilter.this.picketLinkConfiguration = null;
                    IDPFilter.this.idpConfiguration = null;
                    IDPFilter.this.initIDPConfiguration();
                    IDPFilter.this.initKeyManager();
                    IDPFilter.this.initHandlersChain();
                }
            }, this.timerInterval, (long)this.timerInterval);
        }
        this.initIDPConfiguration();
        this.initSTSConfiguration();
        this.initKeyManager();
        this.initHandlersChain();
        this.initIdentityServer();
        String[] ak = new String[]{"mail", "cn", "commonname", "givenname", "surname", "employeeType", "employeeNumber", "facsimileTelephoneNumber"};
        this.attributeKeys.addAll(Arrays.asList(ak));
        if (this.picketLinkConfiguration == null) {
            this.picketLinkConfiguration = new PicketLinkType();
            this.picketLinkConfiguration.setIdpOrSP((ProviderType)this.idpConfiguration);
            this.picketLinkConfiguration.setHandlers(this.handlers);
        }
    }

    private SAML11AttributeStatementType createAttributeStatement(List<String> roles) {
        SAML11AttributeStatementType attrStatement = null;
        for (String role : roles) {
            if (attrStatement == null) {
                attrStatement = new SAML11AttributeStatementType();
            }
            SAML11AttributeType attr = new SAML11AttributeType("Role", URI.create("urn:picketlink:role"));
            attr.add(role);
            attrStatement.add(attr);
        }
        return attrStatement;
    }

    private Boolean willIgnoreSignatureOfCurrentRequest(String spIssuer) {
        SPSSODescriptorType currentSPMetadata = this.spSSOMetadataMap.get(spIssuer);
        if (currentSPMetadata == null) {
            return false;
        }
        Boolean isRequestSigned = currentSPMetadata.isAuthnRequestsSigned();
        if (isRequestSigned == null) {
            isRequestSigned = Boolean.FALSE;
        }
        logger.trace("Issuer: " + spIssuer + ", isRequestSigned: " + isRequestSigned);
        return isRequestSigned == false;
    }

    private void initHostedURI() {
        String hostedURI = this.idpConfiguration.getHostedURI();
        if (StringUtil.isNullOrEmpty((String)hostedURI)) {
            hostedURI = "/hosted/";
        } else if (!hostedURI.contains(".") && !hostedURI.endsWith("/")) {
            hostedURI = hostedURI + "/";
        }
        this.idpConfiguration.setHostedURI(hostedURI);
    }

    protected void recycle(HttpServletResponse response) {
        response.reset();
    }

    protected PicketLinkType getConfiguration() {
        return this.picketLinkConfiguration;
    }

    private void configureAuditHelper() throws ServletException {
        String auditHelperType;
        this.auditHelper = (PicketLinkAuditHelper)this.servletContext.getAttribute("AUDIT_HELPER");
        if (this.auditHelper == null && (auditHelperType = this.servletContext.getInitParameter("AUDIT_HELPER")) != null) {
            try {
                this.auditHelper = (PicketLinkAuditHelper)SecurityActions.loadClass(Thread.currentThread().getContextClassLoader(), auditHelperType).newInstance();
            }
            catch (Exception e) {
                throw new ServletException("Could not create audit helper [" + auditHelperType + "].", (Throwable)e);
            }
        }
    }

    private void configureConfigurationProvider() throws ServletException {
        String configProviderType;
        this.configProvider = (SAMLConfigurationProvider)this.servletContext.getAttribute("CONFIG_PROVIDER");
        if (this.configProvider == null && (configProviderType = this.servletContext.getInitParameter("CONFIG_PROVIDER")) != null) {
            try {
                this.configProvider = (SAMLConfigurationProvider)SecurityActions.loadClass(Thread.currentThread().getContextClassLoader(), configProviderType).newInstance();
            }
            catch (Exception e) {
                throw new ServletException("Could not create config provider [" + configProviderType + "].", (Throwable)e);
            }
        }
    }

    public SAMLConfigurationProvider getConfigProvider() {
        return this.configProvider;
    }
}

