/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.config.AbstractIdentityConfigurationChildBuilder;
import org.picketlink.idm.config.Builder;
import org.picketlink.idm.config.FeatureSet;
import org.picketlink.idm.config.FileStoreConfigurationBuilder;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.config.IdentityStoreConfigurationBuilder;
import org.picketlink.idm.config.IdentityStoresConfigurationBuilder;
import org.picketlink.idm.config.JPAStoreConfigurationBuilder;
import org.picketlink.idm.config.LDAPStoreConfigurationBuilder;
import org.picketlink.idm.config.SecurityConfigurationException;
import org.picketlink.idm.credential.spi.CredentialHandler;
import org.picketlink.idm.model.Grant;
import org.picketlink.idm.model.GroupMembership;
import org.picketlink.idm.model.GroupRole;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.spi.ContextInitializer;

public abstract class AbstractIdentityStoreConfigurationBuilder<T extends IdentityStoreConfiguration, S extends IdentityStoreConfigurationBuilder<T, S>>
extends AbstractIdentityConfigurationChildBuilder
implements IdentityStoreConfigurationBuilder<T, S> {
    private final Map<FeatureSet.FeatureGroup, Set<FeatureSet.FeatureOperation>> supportedFeatures = new HashMap<FeatureSet.FeatureGroup, Set<FeatureSet.FeatureOperation>>();
    private final Map<Class<? extends Relationship>, Set<FeatureSet.FeatureOperation>> supportedRelationships = new HashMap<Class<? extends Relationship>, Set<FeatureSet.FeatureOperation>>();
    private Set<String> realms = new HashSet<String>();
    private Set<String> tiers = new HashSet<String>();
    private List<ContextInitializer> contextInitializers = new ArrayList<ContextInitializer>();
    private Map<String, Object> credentialHandlerProperties = new HashMap<String, Object>();
    private List<Class<? extends CredentialHandler>> credentialHandlers = new ArrayList<Class<? extends CredentialHandler>>();
    private IdentityStoresConfigurationBuilder identityStoresConfigurationBuilder;

    public AbstractIdentityStoreConfigurationBuilder(IdentityStoresConfigurationBuilder builder) {
        super(builder);
        this.identityStoresConfigurationBuilder = builder;
    }

    public FileStoreConfigurationBuilder file() {
        return this.identityStoresConfigurationBuilder.file();
    }

    public JPAStoreConfigurationBuilder jpa() {
        return this.identityStoresConfigurationBuilder.jpa();
    }

    public LDAPStoreConfigurationBuilder ldap() {
        return this.identityStoresConfigurationBuilder.ldap();
    }

    @Override
    public S supportFeature(FeatureSet.FeatureGroup ... groups) {
        FeatureSet.FeatureGroup[] features;
        block11: for (FeatureSet.FeatureGroup feature : features = groups != null && groups.length > 0 ? groups : FeatureSet.FeatureGroup.values()) {
            switch (feature) {
                case agent: {
                    this.addBasicOperations(feature);
                    continue block11;
                }
                case user: {
                    this.addBasicOperations(feature);
                    continue block11;
                }
                case group: {
                    this.addBasicOperations(feature);
                    continue block11;
                }
                case role: {
                    this.addBasicOperations(feature);
                    continue block11;
                }
                case relationship: {
                    this.supportRelationshipType(null);
                    this.addBasicOperations(feature);
                    continue block11;
                }
                case attribute: {
                    this.addBasicOperations(feature);
                    continue block11;
                }
                case realm: {
                    this.addBasicOperations(feature);
                    continue block11;
                }
                case tier: {
                    this.addBasicOperations(feature);
                    continue block11;
                }
                case credential: {
                    this.supportFeature(feature, FeatureSet.FeatureOperation.update);
                    this.supportFeature(feature, FeatureSet.FeatureOperation.validate);
                }
            }
        }
        return (S)this;
    }

    public S supportFeature(FeatureSet.FeatureGroup feature, FeatureSet.FeatureOperation operation) {
        this.getFeatureOperations(feature).add(operation);
        return (S)this;
    }

    @Override
    public S supportRelationshipType(Class<? extends Relationship> ... relationshipClass) {
        List<Class<Relationship>> classes = relationshipClass != null && relationshipClass.length > 0 ? Arrays.asList(relationshipClass) : AbstractIdentityStoreConfigurationBuilder.getDefaultRelationshipClasses();
        for (Class<Relationship> cls : classes) {
            this.getRelationshipOperations(cls).add(FeatureSet.FeatureOperation.create);
            this.getRelationshipOperations(cls).add(FeatureSet.FeatureOperation.read);
            this.getRelationshipOperations(cls).add(FeatureSet.FeatureOperation.update);
            this.getRelationshipOperations(cls).add(FeatureSet.FeatureOperation.delete);
        }
        return (S)this;
    }

    @Override
    public S removeRelationship(Class<? extends Relationship> ... relationshipClasses) {
        if (relationshipClasses != null) {
            for (Class<? extends Relationship> relationshipClass : relationshipClasses) {
                this.removeRelationshipFeature(relationshipClass, FeatureSet.FeatureOperation.create);
                this.removeRelationshipFeature(relationshipClass, FeatureSet.FeatureOperation.read);
                this.removeRelationshipFeature(relationshipClass, FeatureSet.FeatureOperation.update);
                this.removeRelationshipFeature(relationshipClass, FeatureSet.FeatureOperation.delete);
            }
        }
        return (S)this;
    }

    @Override
    public S removeRelationshipFeature(Class<? extends Relationship> relationshipClass, FeatureSet.FeatureOperation operation) {
        if (this.supportedRelationships.containsKey(relationshipClass)) {
            this.supportedRelationships.get(relationshipClass).remove((Object)operation);
        }
        return (S)this;
    }

    @Override
    public S supportAllFeatures() {
        this.supportFeature(FeatureSet.FeatureGroup.agent);
        this.supportFeature(FeatureSet.FeatureGroup.attribute);
        this.supportFeature(FeatureSet.FeatureGroup.credential);
        this.supportFeature(FeatureSet.FeatureGroup.group);
        this.supportFeature(FeatureSet.FeatureGroup.realm);
        this.supportFeature(FeatureSet.FeatureGroup.relationship);
        this.supportFeature(FeatureSet.FeatureGroup.role);
        this.supportFeature(FeatureSet.FeatureGroup.tier);
        this.supportFeature(FeatureSet.FeatureGroup.user);
        return (S)this;
    }

    @Override
    public S addRealm(String ... realmNames) {
        if (realmNames != null) {
            this.realms.addAll(Arrays.asList(realmNames));
        }
        return (S)this;
    }

    @Override
    public S addTier(String ... tierNames) {
        if (tierNames != null) {
            this.tiers.addAll(Arrays.asList(tierNames));
        }
        return (S)this;
    }

    @Override
    public S addContextInitializer(ContextInitializer contextInitializer) {
        this.contextInitializers.add(contextInitializer);
        return (S)this;
    }

    @Override
    public S setCredentialHandlerProperty(String propertyName, Object value) {
        this.credentialHandlerProperties.put(propertyName, value);
        return (S)this;
    }

    @Override
    public S addCredentialHandler(Class<? extends CredentialHandler> credentialHandler) {
        this.credentialHandlers.add(credentialHandler);
        return (S)this;
    }

    @Override
    public S removeFeature(FeatureSet.FeatureGroup feature) throws SecurityConfigurationException {
        this.supportedFeatures.remove((Object)feature);
        if (FeatureSet.FeatureGroup.relationship.equals((Object)feature)) {
            this.supportedRelationships.clear();
        }
        return (S)this;
    }

    @Override
    public S removeFeature(FeatureSet.FeatureGroup feature, FeatureSet.FeatureOperation operation) {
        this.getFeatureOperations(feature).remove((Object)operation);
        if (FeatureSet.FeatureGroup.relationship.equals((Object)feature)) {
            Set<Map.Entry<Class<? extends Relationship>, Set<FeatureSet.FeatureOperation>>> relationShipsEntrySet = this.supportedRelationships.entrySet();
            for (Map.Entry<Class<? extends Relationship>, Set<FeatureSet.FeatureOperation>> entry : relationShipsEntrySet) {
                this.getRelationshipOperations(entry.getKey()).remove((Object)operation);
            }
        }
        return (S)this;
    }

    @Override
    public void validate() {
        if (this.supportedFeatures.isEmpty()) {
            throw new SecurityConfigurationException("You must provide which features should be supported by the identity store.");
        }
    }

    @Override
    public Builder<?> readFrom(T configuration) {
        if (configuration == null) {
            throw IDMMessages.MESSAGES.nullArgument("Configuration to read.");
        }
        this.realms.addAll(configuration.getRealms());
        this.tiers.addAll(configuration.getTiers());
        this.supportedFeatures.putAll(configuration.getSupportedFeatures());
        this.supportedRelationships.putAll(configuration.getSupportedRelationships());
        return this;
    }

    protected Map<FeatureSet.FeatureGroup, Set<FeatureSet.FeatureOperation>> getSupportedFeatures() {
        return this.supportedFeatures;
    }

    protected Map<Class<? extends Relationship>, Set<FeatureSet.FeatureOperation>> getSupportedRelationships() {
        return this.supportedRelationships;
    }

    protected Set<String> getRealms() {
        return this.realms;
    }

    protected Set<String> getTiers() {
        return this.tiers;
    }

    protected List<ContextInitializer> getContextInitializers() {
        return this.contextInitializers;
    }

    protected Map<String, Object> getCredentialHandlerProperties() {
        return this.credentialHandlerProperties;
    }

    protected List<Class<? extends CredentialHandler>> getCredentialHandlers() {
        return this.credentialHandlers;
    }

    private Set<FeatureSet.FeatureOperation> getFeatureOperations(FeatureSet.FeatureGroup group) {
        if (!this.supportedFeatures.containsKey((Object)group)) {
            this.supportedFeatures.put(group, new HashSet());
        }
        return this.supportedFeatures.get((Object)group);
    }

    private Set<FeatureSet.FeatureOperation> getRelationshipOperations(Class<? extends Relationship> relationshipClass) {
        if (!this.supportedRelationships.containsKey(relationshipClass)) {
            this.supportedRelationships.put(relationshipClass, new HashSet());
        }
        return this.supportedRelationships.get(relationshipClass);
    }

    private void addBasicOperations(FeatureSet.FeatureGroup feature) {
        this.supportFeature(feature, FeatureSet.FeatureOperation.create);
        this.supportFeature(feature, FeatureSet.FeatureOperation.read);
        this.supportFeature(feature, FeatureSet.FeatureOperation.update);
        this.supportFeature(feature, FeatureSet.FeatureOperation.delete);
    }

    protected static List<Class<? extends Relationship>> getDefaultRelationshipClasses() {
        ArrayList<Class> classes = new ArrayList<Class>();
        classes.add(Relationship.class);
        classes.add(Grant.class);
        classes.add(GroupMembership.class);
        classes.add(GroupRole.class);
        return Collections.unmodifiableList(classes);
    }
}

