/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.config;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.picketlink.idm.config.BaseAbstractStoreConfiguration;
import org.picketlink.idm.config.FeatureSet;
import org.picketlink.idm.config.SecurityConfigurationException;
import org.picketlink.idm.credential.spi.CredentialHandler;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.spi.ContextInitializer;

public class LDAPIdentityStoreConfiguration
extends BaseAbstractStoreConfiguration {
    private String ldapURL;
    private String userDNSuffix;
    private String roleDNSuffix;
    private String groupDNSuffix;
    private String factoryName = "com.sun.jndi.ldap.LdapCtxFactory";
    private String authType = "simple";
    private String protocol;
    private String bindDN;
    private String bindCredential;
    private String standardAttributesFileName = "standardattributes.txt";
    private boolean isActiveDirectory = false;
    private Properties additionalProperties = new Properties();
    private String agentDNSuffix;
    private String baseDN;
    private Map<String, String> groupMapping = new HashMap<String, String>();

    LDAPIdentityStoreConfiguration(String url, String bindDN, String bindCredential, String baseDN, String agentDNSuffix, String userDNSuffix, String roleDNSuffix, String groupDNSuffix, Map<String, String> groupMapping, Map<FeatureSet.FeatureGroup, Set<FeatureSet.FeatureOperation>> supportedFeatures, Map<Class<? extends Relationship>, Set<FeatureSet.FeatureOperation>> supportedRelationships, Set<String> realms, Set<String> tiers, List<ContextInitializer> contextInitializers, Map<String, Object> credentialHandlerProperties, List<Class<? extends CredentialHandler>> credentialHandlers) {
        super(supportedFeatures, supportedRelationships, realms, tiers, contextInitializers, credentialHandlerProperties, credentialHandlers);
        this.ldapURL = url;
        this.bindDN = bindDN;
        this.bindCredential = bindCredential;
        this.baseDN = baseDN;
        this.agentDNSuffix = agentDNSuffix;
        this.userDNSuffix = userDNSuffix;
        this.roleDNSuffix = roleDNSuffix;
        this.groupDNSuffix = groupDNSuffix;
        this.groupMapping = groupMapping;
    }

    @Override
    protected void initConfig() throws SecurityConfigurationException {
        this.removeFeature(FeatureSet.FeatureGroup.realm);
        this.removeFeature(FeatureSet.FeatureGroup.tier);
    }

    public String getStandardAttributesFileName() {
        return this.standardAttributesFileName;
    }

    public String getLdapURL() {
        return this.ldapURL;
    }

    public String getUserDNSuffix() {
        return this.userDNSuffix;
    }

    public String getRoleDNSuffix() {
        return this.roleDNSuffix;
    }

    public String getGroupDNSuffix() {
        return this.groupDNSuffix;
    }

    public String getFactoryName() {
        return this.factoryName;
    }

    public String getAuthType() {
        return this.authType;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getBindDN() {
        return this.bindDN;
    }

    public String getBindCredential() {
        return this.bindCredential;
    }

    public boolean isActiveDirectory() {
        return this.isActiveDirectory;
    }

    public Properties getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getAgentDNSuffix() {
        return this.agentDNSuffix;
    }

    public String getBaseDN() {
        return this.baseDN;
    }

    public String getGroupMappingDN(String groupPath) {
        Set<Map.Entry<String, String>> entrySet = this.groupMapping.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            if (!groupPath.contains(entry.getKey())) continue;
            return entry.getValue();
        }
        return this.groupMapping.get(groupPath);
    }

    public boolean isGroupNamespace(String nameInNamespace) {
        if (nameInNamespace.endsWith(this.getGroupDNSuffix())) {
            return true;
        }
        Set<Map.Entry<String, String>> entrySet = this.groupMapping.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            if (!nameInNamespace.endsWith(entry.getValue())) continue;
            return true;
        }
        return false;
    }
}

