/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.credential.spi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.spi.CredentialHandler;
import org.picketlink.idm.credential.spi.annotations.CredentialHandlers;
import org.picketlink.idm.credential.spi.annotations.SupportsCredentials;
import org.picketlink.idm.spi.IdentityStore;

public class CredentialHandlerFactory {
    private Map<Class<? extends CredentialHandler>, CredentialHandler> handlerInstances = new HashMap<Class<? extends CredentialHandler>, CredentialHandler>();

    public CredentialHandler getCredentialValidator(Class<? extends Credentials> credentialsClass, IdentityStore<?> identityStore) {
        return this.getCredentialHandler(credentialsClass, identityStore);
    }

    public CredentialHandler getCredentialUpdater(Class<?> credentialClass, IdentityStore<?> identityStore) {
        return this.getCredentialHandler(credentialClass, identityStore);
    }

    private CredentialHandler getCredentialHandler(Class<?> credentialsClass, IdentityStore<?> identityStore) {
        List<Class<? extends CredentialHandler>> handlers = this.getHandlersForStore(identityStore);
        CredentialHandler handlerInstance = null;
        for (Class<? extends CredentialHandler> handlerClass : handlers) {
            SupportsCredentials sc = handlerClass.getAnnotation(SupportsCredentials.class);
            if (sc == null) {
                throw IDMMessages.MESSAGES.credentialSupportedCredentialsNotProvided(handlerClass);
            }
            for (Class<?> cls : sc.value()) {
                if (!cls.isAssignableFrom(credentialsClass)) continue;
                handlerInstance = this.createHandlerInstance(handlerClass, identityStore);
                if (!cls.equals(credentialsClass)) continue;
                return handlerInstance;
            }
        }
        return handlerInstance;
    }

    private List<Class<? extends CredentialHandler>> getHandlersForStore(IdentityStore<?> identityStore) {
        CredentialHandlers annotatedHandlers = identityStore.getClass().getAnnotation(CredentialHandlers.class);
        ArrayList<Class<? extends CredentialHandler>> handlers = new ArrayList<Class<? extends CredentialHandler>>(Arrays.asList(annotatedHandlers.value()));
        List<Class<? extends CredentialHandler>> customHandlers = identityStore.getConfig().getCredentialHandlers();
        if (customHandlers != null) {
            handlers.addAll(customHandlers);
        }
        return handlers;
    }

    private synchronized CredentialHandler createHandlerInstance(Class<? extends CredentialHandler> handlerClass, IdentityStore<?> identityStore) {
        if (!this.handlerInstances.containsKey(handlerClass)) {
            try {
                CredentialHandler handler = handlerClass.newInstance();
                handler.setup(identityStore);
                this.handlerInstances.put(handlerClass, handler);
            }
            catch (Exception ex) {
                throw IDMMessages.MESSAGES.credentialCredentialHandlerInstantiationError(handlerClass, ex);
            }
        }
        return this.handlerInstances.get(handlerClass);
    }
}

