/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.config;

import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.config.AbstractIdentityStoreConfigurationBuilder;
import org.picketlink.idm.config.IdentityStoresConfigurationBuilder;
import org.picketlink.idm.config.JPAIdentityStoreConfiguration;

public class JPAStoreConfigurationBuilder
extends AbstractIdentityStoreConfigurationBuilder<JPAIdentityStoreConfiguration, JPAStoreConfigurationBuilder> {
    private Class<?> identityClass;
    private Class<?> attributeClass;
    private Class<?> credentialClass;
    private Class<?> credentialAttributeClass;
    private Class<?> relationshipClass;
    private Class<?> relationshipIdentityClass;
    private Class<?> relationshipAttributeClass;
    private Class<?> partitionClass;

    public JPAStoreConfigurationBuilder(IdentityStoresConfigurationBuilder builder) {
        super(builder);
    }

    public JPAStoreConfigurationBuilder identityClass(Class<?> identityClass) {
        this.identityClass = identityClass;
        return this;
    }

    public JPAStoreConfigurationBuilder attributeClass(Class<?> attributeClass) {
        this.attributeClass = attributeClass;
        return this;
    }

    public JPAStoreConfigurationBuilder credentialClass(Class<?> credentialClass) {
        this.credentialClass = credentialClass;
        return this;
    }

    public JPAStoreConfigurationBuilder credentialAttributeClass(Class<?> credentialAttributeClass) {
        this.credentialAttributeClass = credentialAttributeClass;
        return this;
    }

    public JPAStoreConfigurationBuilder relationshipClass(Class<?> relationshipClass) {
        this.relationshipClass = relationshipClass;
        return this;
    }

    public JPAStoreConfigurationBuilder relationshipIdentityClass(Class<?> relationshipIdentityClass) {
        this.relationshipIdentityClass = relationshipIdentityClass;
        return this;
    }

    public JPAStoreConfigurationBuilder relationshipAttributeClass(Class<?> relationshipAttributeClass) {
        this.relationshipAttributeClass = relationshipAttributeClass;
        return this;
    }

    public JPAStoreConfigurationBuilder partitionClass(Class<?> partitionClass) {
        this.partitionClass = partitionClass;
        return this;
    }

    @Override
    public JPAIdentityStoreConfiguration create() {
        return new JPAIdentityStoreConfiguration(this.identityClass, this.attributeClass, this.credentialClass, this.credentialAttributeClass, this.relationshipClass, this.relationshipIdentityClass, this.relationshipAttributeClass, this.partitionClass, this.getSupportedFeatures(), this.getSupportedRelationships(), this.getRealms(), this.getTiers(), this.getContextInitializers(), this.getCredentialHandlerProperties(), this.getCredentialHandlers());
    }

    @Override
    public void validate() {
        super.validate();
        if (this.identityClass == null) {
            throw IDMMessages.MESSAGES.jpaConfigIdentityClassNotProvided();
        }
        if (this.partitionClass == null) {
            throw IDMMessages.MESSAGES.jpaConfigPartitionClassNotProvided();
        }
    }

    public JPAStoreConfigurationBuilder readFrom(JPAIdentityStoreConfiguration configuration) {
        super.readFrom(configuration);
        this.attributeClass = configuration.getAttributeClass();
        this.credentialAttributeClass = configuration.getCredentialAttributeClass();
        this.credentialClass = configuration.getCredentialClass();
        this.identityClass = configuration.getIdentityClass();
        this.partitionClass = configuration.getPartitionClass();
        this.relationshipAttributeClass = configuration.getRelationshipAttributeClass();
        this.relationshipClass = configuration.getRelationshipClass();
        this.relationshipIdentityClass = configuration.getRelationshipIdentityClass();
        return this;
    }
}

