/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.picketlink.idm.IDMLogger;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.config.SecurityConfigurationException;
import org.picketlink.idm.credential.handler.CredentialHandler;
import org.picketlink.idm.credential.handler.annotations.CredentialHandlers;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.spi.ContextInitializer;
import org.picketlink.idm.spi.IdentityContext;
import org.picketlink.idm.spi.IdentityStore;
import org.picketlink.idm.util.IDMUtil;

public abstract class AbstractIdentityStoreConfiguration
implements IdentityStoreConfiguration {
    private final Map<Class<? extends AttributedType>, Set<IdentityStoreConfiguration.IdentityOperation>> supportedTypes;
    private final Map<Class<? extends AttributedType>, Set<IdentityStoreConfiguration.IdentityOperation>> unsupportedTypes;
    private final List<ContextInitializer> contextInitializers;
    private final Map<String, Object> credentialHandlerProperties;
    private final List<Class<? extends CredentialHandler>> credentialHandlers;
    private Class<? extends IdentityStore> identityStoreType;

    protected AbstractIdentityStoreConfiguration(Map<Class<? extends AttributedType>, Set<IdentityStoreConfiguration.IdentityOperation>> supportedTypes, Map<Class<? extends AttributedType>, Set<IdentityStoreConfiguration.IdentityOperation>> unsupportedTypes, List<ContextInitializer> contextInitializers, Map<String, Object> credentialHandlerProperties, List<Class<? extends CredentialHandler>> credentialHandlers) {
        this.supportedTypes = Collections.unmodifiableMap(supportedTypes);
        this.unsupportedTypes = Collections.unmodifiableMap(unsupportedTypes);
        this.contextInitializers = Collections.unmodifiableList(contextInitializers);
        this.credentialHandlerProperties = Collections.unmodifiableMap(credentialHandlerProperties);
        this.credentialHandlers = Collections.unmodifiableList(credentialHandlers);
    }

    @Override
    public final void init() throws SecurityConfigurationException {
        this.initConfig();
        if (IDMLogger.LOGGER.isDebugEnabled()) {
            IDMLogger.LOGGER.debugf("FeatureSet for %s", this);
            IDMLogger.LOGGER.debug("Features [");
            IDMLogger.LOGGER.debug("]");
            IDMLogger.LOGGER.debug("Relationships [");
            IDMLogger.LOGGER.debug("]");
        }
    }

    protected abstract void initConfig();

    @Override
    public void addContextInitializer(ContextInitializer contextInitializer) {
        this.contextInitializers.add(contextInitializer);
    }

    @Override
    public void initializeContext(IdentityContext context, IdentityStore<?> store) {
        for (ContextInitializer initializer : this.contextInitializers) {
            initializer.initContextForStore(context, store);
        }
    }

    @Override
    public List<Class<? extends CredentialHandler>> getCredentialHandlers() {
        CredentialHandlers credentialHandlers;
        ArrayList<Class<? extends CredentialHandler>> supportedCredentialHandlers = new ArrayList<Class<? extends CredentialHandler>>(this.credentialHandlers);
        if (this.getIdentityStoreType() != null && (credentialHandlers = this.getIdentityStoreType().getAnnotation(CredentialHandlers.class)) != null) {
            supportedCredentialHandlers.addAll(Arrays.asList(credentialHandlers.value()));
        }
        return supportedCredentialHandlers;
    }

    @Override
    public Map<String, Object> getCredentialHandlerProperties() {
        return this.credentialHandlerProperties;
    }

    @Override
    public boolean supportsType(Class<? extends AttributedType> type, IdentityStoreConfiguration.IdentityOperation operation) {
        if (operation == null) {
            throw IDMMessages.MESSAGES.nullArgument("TypeOperation");
        }
        return IDMUtil.isTypeOperationSupported(type, operation, this.supportedTypes, this.unsupportedTypes) != -1;
    }

    @Override
    public boolean supportsPartition() {
        return this.supportsType(Partition.class, IdentityStoreConfiguration.IdentityOperation.create);
    }

    @Override
    public Class<? extends IdentityStore> getIdentityStoreType() {
        return this.identityStoreType;
    }

    public <T extends IdentityStore> void setIdentityStoreType(Class<T> identityStoreType) {
        this.identityStoreType = identityStoreType;
    }

    @Override
    public Map<Class<? extends AttributedType>, Set<IdentityStoreConfiguration.IdentityOperation>> getSupportedTypes() {
        return this.supportedTypes;
    }

    @Override
    public Map<Class<? extends AttributedType>, Set<IdentityStoreConfiguration.IdentityOperation>> getUnsupportedTypes() {
        return this.unsupportedTypes;
    }

    @Override
    public List<ContextInitializer> getContextInitializers() {
        return this.contextInitializers;
    }
}

