/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.config;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.config.AbstractIdentityConfigurationChildBuilder;
import org.picketlink.idm.config.FileIdentityStoreConfiguration;
import org.picketlink.idm.config.FileStoreConfigurationBuilder;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.config.IdentityStoreConfigurationBuilder;
import org.picketlink.idm.config.IdentityStoreConfigurationChildBuilder;
import org.picketlink.idm.config.JPAIdentityStoreConfiguration;
import org.picketlink.idm.config.JPAStoreConfigurationBuilder;
import org.picketlink.idm.config.LDAPIdentityStoreConfiguration;
import org.picketlink.idm.config.LDAPStoreConfigurationBuilder;
import org.picketlink.idm.config.NamedIdentityConfigurationBuilder;
import org.picketlink.idm.config.SecurityConfigurationException;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.model.Relationship;

public class IdentityStoresConfigurationBuilder
extends AbstractIdentityConfigurationChildBuilder<List<? extends IdentityStoreConfiguration>>
implements IdentityStoreConfigurationChildBuilder {
    private final List<IdentityStoreConfigurationBuilder<?, ?>> identityStoresConfiguration = new ArrayList();
    private final Map<Class<? extends IdentityStoreConfiguration>, Class<? extends IdentityStoreConfigurationBuilder<?, ?>>> supportedStoreBuilders = new HashMap();
    private Set<Class<? extends Relationship>> globalRelationships = new HashSet<Class<? extends Relationship>>();
    private Set<Class<? extends Relationship>> selfRelationships = new HashSet<Class<? extends Relationship>>();

    public IdentityStoresConfigurationBuilder(NamedIdentityConfigurationBuilder builder) {
        super(builder);
        this.supportedStoreBuilders.put(FileIdentityStoreConfiguration.class, FileStoreConfigurationBuilder.class);
        this.supportedStoreBuilders.put(JPAIdentityStoreConfiguration.class, JPAStoreConfigurationBuilder.class);
        this.supportedStoreBuilders.put(LDAPIdentityStoreConfiguration.class, LDAPStoreConfigurationBuilder.class);
    }

    @Override
    public FileStoreConfigurationBuilder file() {
        return (FileStoreConfigurationBuilder)this.forIdentityStoreConfig(FileIdentityStoreConfiguration.class, true);
    }

    @Override
    public JPAStoreConfigurationBuilder jpa() {
        return (JPAStoreConfigurationBuilder)this.forIdentityStoreConfig(JPAIdentityStoreConfiguration.class, true);
    }

    @Override
    public LDAPStoreConfigurationBuilder ldap() {
        return (LDAPStoreConfigurationBuilder)this.forIdentityStoreConfig(LDAPIdentityStoreConfiguration.class, true);
    }

    public <T extends IdentityStoreConfigurationBuilder<?, ?>> T add(Class<? extends IdentityStoreConfiguration> identityStoreConfiguration, Class<T> builder) {
        this.supportedStoreBuilders.put(identityStoreConfiguration, builder);
        return (T)this.forIdentityStoreConfig(identityStoreConfiguration, true);
    }

    @Override
    protected List<? extends IdentityStoreConfiguration> create() {
        ArrayList<IdentityStoreConfiguration> configurations = new ArrayList<IdentityStoreConfiguration>();
        boolean hasPartitionStore = false;
        HashSet<Class<AttributedType>> supportedTypes = new HashSet<Class<AttributedType>>();
        for (IdentityStoreConfigurationBuilder<?, ?> storeConfigurationBuilder : this.identityStoresConfiguration) {
            IdentityStoreConfiguration storeConfiguration = (IdentityStoreConfiguration)storeConfigurationBuilder.create();
            if (storeConfiguration.supportsPartition()) {
                if (hasPartitionStore) {
                    throw new SecurityConfigurationException("Only one store configuration must be able to store partitions.");
                }
                hasPartitionStore = true;
            }
            try {
                supportedTypes.addAll(storeConfigurationBuilder.getSupportedTypes().keySet());
            }
            catch (IllegalArgumentException iae) {
                throw new SecurityConfigurationException("Duplicated supported types found for [" + storeConfiguration + "].");
            }
            for (Class<Relationship> relType : storeConfigurationBuilder.getGlobalRelationshipTypes()) {
                this.globalRelationships.add(relType);
            }
            for (Class<Relationship> relType : storeConfigurationBuilder.getSelfRelationshipTypes()) {
                this.selfRelationships.add(relType);
            }
            configurations.add(storeConfiguration);
        }
        if (!hasPartitionStore) {
            // empty if block
        }
        return configurations;
    }

    @Override
    protected void validate() {
        if (this.identityStoresConfiguration.isEmpty()) {
            throw new SecurityConfigurationException("You must configure at least one identity store.");
        }
        for (IdentityStoreConfigurationBuilder<?, ?> storeConfigurationBuilder : this.identityStoresConfiguration) {
            storeConfigurationBuilder.validate();
        }
    }

    protected IdentityStoresConfigurationBuilder readFrom(List<? extends IdentityStoreConfiguration> fromConfiguration) {
        if (fromConfiguration == null) {
            throw IDMMessages.MESSAGES.nullArgument("Configurations to read");
        }
        for (IdentityStoreConfiguration identityStoreConfiguration : fromConfiguration) {
            Object storeConfigBuilder = this.forIdentityStoreConfig(identityStoreConfiguration.getClass(), true);
            ((IdentityStoreConfigurationBuilder)storeConfigBuilder).readFrom((IdentityStoreConfiguration)identityStoreConfiguration);
        }
        return this;
    }

    private <S extends IdentityStoreConfigurationBuilder<?, ?>> S forIdentityStoreConfig(Class<? extends IdentityStoreConfiguration> configurationType, boolean createIfNotExists) {
        IdentityStoreConfigurationBuilder<?, ?> instance;
        Class<IdentityStoreConfigurationBuilder<?, ?>> builderType = this.supportedStoreBuilders.get(configurationType);
        for (IdentityStoreConfigurationBuilder<?, ?> registeredStoreConfig : this.identityStoresConfiguration) {
            if (!registeredStoreConfig.getClass().equals(builderType)) continue;
            return (S)registeredStoreConfig;
        }
        if (!createIfNotExists) {
            return null;
        }
        try {
            instance = builderType.getConstructor(IdentityStoresConfigurationBuilder.class).newInstance(this);
        }
        catch (Exception e) {
            throw new SecurityConfigurationException("Could not instantiate IdentityStoreConfigurationBuilder [" + builderType.getName() + "]", e);
        }
        this.identityStoresConfiguration.add(instance);
        return (S)instance;
    }

    protected Set<Class<? extends Relationship>> getGlobalRelationships() {
        return this.globalRelationships;
    }

    protected Set<Class<? extends Relationship>> getSelfRelationships() {
        return this.selfRelationships;
    }
}

