/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.config;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.picketlink.common.properties.Property;
import org.picketlink.common.properties.query.AnnotatedPropertyCriteria;
import org.picketlink.common.properties.query.PropertyCriteria;
import org.picketlink.common.properties.query.PropertyQueries;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.config.AbstractIdentityStoreConfiguration;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.credential.handler.CredentialHandler;
import org.picketlink.idm.jpa.annotations.Identifier;
import org.picketlink.idm.jpa.annotations.OwnerReference;
import org.picketlink.idm.jpa.annotations.RelationshipClass;
import org.picketlink.idm.jpa.annotations.RelationshipDescriptor;
import org.picketlink.idm.jpa.annotations.RelationshipMember;
import org.picketlink.idm.model.AttributedType;
import org.picketlink.idm.spi.ContextInitializer;

public class JPAIdentityStoreConfiguration
extends AbstractIdentityStoreConfiguration {
    private final List<Class<?>> entityTypes;
    private final RelationshipIdentityMapping relationshipIdentityMapping;
    private final RelationshipMapping relationshipMapping;

    protected JPAIdentityStoreConfiguration(List<Class<?>> entityTypes, Map<Class<? extends AttributedType>, Set<IdentityStoreConfiguration.IdentityOperation>> supportedTypes, Map<Class<? extends AttributedType>, Set<IdentityStoreConfiguration.IdentityOperation>> unsupportedTypes, List<ContextInitializer> contextInitializers, Map<String, Object> credentialHandlerProperties, List<Class<? extends CredentialHandler>> credentialHandlers) {
        super(supportedTypes, unsupportedTypes, contextInitializers, credentialHandlerProperties, credentialHandlers);
        if (entityTypes == null) {
            throw IDMMessages.MESSAGES.jpaConfigNoEntityClassesProvided();
        }
        this.entityTypes = entityTypes;
        RelationshipMapping relationshipMapping = null;
        RelationshipIdentityMapping relationshipIdentityMapping = null;
        for (Class<?> entityType : this.entityTypes) {
            Property property = null;
            property = PropertyQueries.createQuery(entityType).addCriteria((PropertyCriteria)new AnnotatedPropertyCriteria(RelationshipClass.class)).getFirstResult();
            if (property != null) {
                relationshipMapping = new RelationshipMapping(entityType);
            }
            if ((property = PropertyQueries.createQuery(entityType).addCriteria((PropertyCriteria)new AnnotatedPropertyCriteria(RelationshipDescriptor.class)).getFirstResult()) == null) continue;
            relationshipIdentityMapping = new RelationshipIdentityMapping(entityType);
        }
        this.relationshipMapping = relationshipMapping;
        this.relationshipIdentityMapping = relationshipIdentityMapping;
    }

    @Override
    protected void initConfig() {
    }

    public List<Class<?>> getEntityTypes() {
        return this.entityTypes;
    }

    public RelationshipIdentityMapping getRelationshipIdentityMapping() {
        return this.relationshipIdentityMapping;
    }

    public RelationshipMapping getRelationshipMapping() {
        return this.relationshipMapping;
    }

    public static class RelationshipIdentityMapping {
        private final Class<?> entityClass;
        private final Property<String> relationshipDescriptor;
        private final Property<Object> relationshipMember;
        private final Property<Object> relationshipOwner;

        private RelationshipIdentityMapping(Class<?> entityClass) {
            this.entityClass = entityClass;
            this.relationshipDescriptor = PropertyQueries.createQuery(this.entityClass).addCriteria((PropertyCriteria)new AnnotatedPropertyCriteria(RelationshipDescriptor.class)).getSingleResult();
            this.relationshipMember = PropertyQueries.createQuery(this.entityClass).addCriteria((PropertyCriteria)new AnnotatedPropertyCriteria(RelationshipMember.class)).getSingleResult();
            this.relationshipOwner = PropertyQueries.createQuery(this.entityClass).addCriteria((PropertyCriteria)new AnnotatedPropertyCriteria(OwnerReference.class)).getSingleResult();
        }

        public Class<?> getEntityClass() {
            return this.entityClass;
        }

        public Property<String> getRelationshipDescriptor() {
            return this.relationshipDescriptor;
        }

        public Property<Object> getRelationshipMember() {
            return this.relationshipMember;
        }

        public Property<Object> getRelationshipOwner() {
            return this.relationshipOwner;
        }
    }

    public static class RelationshipMapping {
        private final Class<?> entityClass;
        private final Property<String> relationshipIdentifier;
        private final Property<String> relationshipClass;

        private RelationshipMapping(Class<?> entityClass) {
            this.entityClass = entityClass;
            this.relationshipIdentifier = PropertyQueries.createQuery(this.entityClass).addCriteria((PropertyCriteria)new AnnotatedPropertyCriteria(Identifier.class)).getSingleResult();
            this.relationshipClass = PropertyQueries.createQuery(this.entityClass).addCriteria((PropertyCriteria)new AnnotatedPropertyCriteria(RelationshipClass.class)).getSingleResult();
        }

        public Class<?> getEntityClass() {
            return this.entityClass;
        }

        public Property<String> getRelationshipIdentifier() {
            return this.relationshipIdentifier;
        }

        public Property<String> getRelationshipClass() {
            return this.relationshipClass;
        }
    }
}

