/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.credential.handler;

import java.util.Date;
import java.util.List;
import org.picketlink.common.util.Base64;
import org.picketlink.common.util.StringUtil;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.Digest;
import org.picketlink.idm.credential.DigestCredentials;
import org.picketlink.idm.credential.handler.AbstractCredentialHandler;
import org.picketlink.idm.credential.handler.annotations.SupportsCredentials;
import org.picketlink.idm.credential.storage.DigestCredentialStorage;
import org.picketlink.idm.credential.util.CredentialUtils;
import org.picketlink.idm.credential.util.DigestUtil;
import org.picketlink.idm.model.Account;
import org.picketlink.idm.model.sample.Agent;
import org.picketlink.idm.spi.CredentialStore;
import org.picketlink.idm.spi.IdentityContext;

@SupportsCredentials(value={DigestCredentials.class, Digest.class})
public class DigestCredentialHandler<S, V, U>
extends AbstractCredentialHandler<CredentialStore<?>, DigestCredentials, Digest> {
    @Override
    public void setup(CredentialStore<?> identityStore) {
    }

    @Override
    public void validate(IdentityContext context, DigestCredentials credentials, CredentialStore<?> store) {
        DigestCredentials digestCredential = credentials;
        digestCredential.setStatus(Credentials.Status.INVALID);
        digestCredential.setValidatedAccount(null);
        Digest digest = digestCredential.getDigest();
        Agent agent = (Agent)this.getAccount(context, digest.getUsername());
        if (agent != null) {
            if (agent.isEnabled()) {
                List<DigestCredentialStorage> storages = store.retrieveCredentials(context, agent, DigestCredentialStorage.class);
                DigestCredentialStorage currentCredential = null;
                for (DigestCredentialStorage storage : storages) {
                    if (!storage.getRealm().equals(digest.getRealm()) || !CredentialUtils.isCurrentCredential(storage)) continue;
                    currentCredential = storage;
                    break;
                }
                if (currentCredential != null) {
                    if (digest.getMethod() != null && digest.getUri() != null) {
                        byte[] ha2;
                        byte[] storedHA1 = currentCredential.getHa1();
                        String calculateDigest = DigestUtil.calculateDigest(digest, storedHA1, ha2 = DigestUtil.calculateA2(digest.getMethod(), digest.getUri()));
                        if (calculateDigest.equals(digest.getDigest())) {
                            digestCredential.setStatus(Credentials.Status.VALID);
                        }
                    } else {
                        String storedDigestPassword = Base64.encodeBytes((byte[])currentCredential.getHa1());
                        String providedDigest = digest.getDigest();
                        if (String.valueOf(storedDigestPassword).equals(providedDigest)) {
                            digestCredential.setStatus(Credentials.Status.VALID);
                        }
                    }
                } else if (CredentialUtils.isLastCredentialExpired(context, agent, store, DigestCredentialStorage.class)) {
                    digestCredential.setStatus(Credentials.Status.EXPIRED);
                }
            } else {
                digestCredential.setStatus(Credentials.Status.ACCOUNT_DISABLED);
            }
            if (digestCredential.getStatus().equals((Object)Credentials.Status.VALID)) {
                digestCredential.setValidatedAccount(agent);
            }
        }
    }

    @Override
    public void update(IdentityContext context, Account account, Digest digest, CredentialStore<?> store, Date effectiveDate, Date expiryDate) {
        if (StringUtil.isNullOrEmpty((String)digest.getRealm())) {
            throw IDMMessages.MESSAGES.credentialDigestInvalidRealm();
        }
        if (StringUtil.isNullOrEmpty((String)digest.getPassword())) {
            throw IDMMessages.MESSAGES.credentialInvalidPassword();
        }
        Agent agent = (Agent)account;
        byte[] ha1 = DigestUtil.calculateA1(agent.getLoginName(), digest.getRealm(), digest.getPassword().toCharArray());
        DigestCredentialStorage storage = new DigestCredentialStorage(ha1, digest.getRealm());
        if (effectiveDate != null) {
            storage.setEffectiveDate(effectiveDate);
        }
        storage.setExpiryDate(expiryDate);
        store.storeCredential(context, account, storage);
    }
}

