/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.credential.handler;

import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.picketlink.common.util.Base64;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.X509CertificateCredentials;
import org.picketlink.idm.credential.handler.AbstractCredentialHandler;
import org.picketlink.idm.credential.handler.annotations.SupportsCredentials;
import org.picketlink.idm.credential.storage.X509CertificateStorage;
import org.picketlink.idm.model.Account;
import org.picketlink.idm.model.sample.Agent;
import org.picketlink.idm.spi.CredentialStore;
import org.picketlink.idm.spi.IdentityContext;

@SupportsCredentials(value={X509CertificateCredentials.class, X509Certificate.class})
public class X509CertificateCredentialHandler<S, V, U>
extends AbstractCredentialHandler<CredentialStore<?>, X509CertificateCredentials, X509Certificate> {
    @Override
    public void setup(CredentialStore<?> identityStore) {
    }

    @Override
    public void validate(IdentityContext context, X509CertificateCredentials credentials, CredentialStore<?> store) {
        Agent agent = (Agent)this.getAccount(context, credentials.getUsername());
        credentials.setStatus(Credentials.Status.INVALID);
        credentials.setValidatedAccount(null);
        if (agent != null) {
            if (agent.isEnabled()) {
                X509CertificateStorage storage;
                boolean isValid = credentials.isTrusted();
                if (!credentials.isTrusted() && (storage = store.retrieveCurrentCredential(context, agent, X509CertificateStorage.class)) != null) {
                    String base64Cert = storage.getBase64Cert();
                    byte[] certBytes = Base64.decode((String)base64Cert);
                    try {
                        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
                        X509Certificate storedCert = (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(certBytes));
                        X509Certificate providedCert = credentials.getCertificate();
                        isValid = storedCert.equals(providedCert);
                    }
                    catch (Exception e) {
                        throw new IdentityManagementException("Error while checking user's certificate.", e);
                    }
                }
                if (isValid) {
                    credentials.setStatus(Credentials.Status.VALID);
                    credentials.setValidatedAccount(agent);
                }
            } else {
                credentials.setStatus(Credentials.Status.ACCOUNT_DISABLED);
            }
        }
    }

    @Override
    public void update(IdentityContext context, Account account, X509Certificate cert, CredentialStore<?> store, Date effectiveDate, Date expiryDate) {
        X509CertificateStorage storage = new X509CertificateStorage(cert);
        store.storeCredential(context, account, storage);
    }
}

