/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.spi;

import java.util.Collections;
import java.util.Set;
import org.picketlink.idm.model.Relationship;

public class RelationshipPolicy {
    private final Set<Class<? extends Relationship>> selfManagedRelationships;
    private final Set<Class<? extends Relationship>> globalManagedRelationships;

    public RelationshipPolicy(Set<Class<? extends Relationship>> selfManagedRelationships, Set<Class<? extends Relationship>> globalManagedRelationships) {
        this.selfManagedRelationships = Collections.unmodifiableSet(selfManagedRelationships);
        this.globalManagedRelationships = Collections.unmodifiableSet(globalManagedRelationships);
    }

    public boolean isSelfRelationshipSupported(Class<? extends Relationship> relationshipClass) {
        for (Class<? extends Relationship> cls : this.selfManagedRelationships) {
            if (!cls.isAssignableFrom(relationshipClass)) continue;
            return true;
        }
        return false;
    }

    public boolean isGlobalRelationshipSupported(Class<? extends Relationship> relationshipClass) {
        for (Class<? extends Relationship> cls : this.globalManagedRelationships) {
            if (!cls.isAssignableFrom(relationshipClass)) continue;
            return true;
        }
        return false;
    }
}

