/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.credential.handler;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Map;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.config.SecurityConfigurationException;
import org.picketlink.idm.credential.Password;
import org.picketlink.idm.credential.UsernamePasswordCredentials;
import org.picketlink.idm.credential.encoder.PasswordEncoder;
import org.picketlink.idm.credential.encoder.SHAPasswordEncoder;
import org.picketlink.idm.credential.handler.AbstractCredentialHandler;
import org.picketlink.idm.credential.handler.annotations.SupportsCredentials;
import org.picketlink.idm.credential.storage.CredentialStorage;
import org.picketlink.idm.credential.storage.EncodedPasswordStorage;
import org.picketlink.idm.model.Account;
import org.picketlink.idm.spi.CredentialStore;
import org.picketlink.idm.spi.IdentityContext;

@SupportsCredentials(value={UsernamePasswordCredentials.class, Password.class})
public class PasswordCredentialHandler<S extends CredentialStore<?>, V extends UsernamePasswordCredentials, U extends Password>
extends AbstractCredentialHandler<S, V, U> {
    private static final String DEFAULT_SALT_ALGORITHM = "SHA1PRNG";
    public static final String PASSWORD_ENCODER = "PASSWORD_ENCODER";
    private PasswordEncoder passwordEncoder = new SHAPasswordEncoder(512);

    @Override
    public void setup(S store) {
        Object providedEncoder;
        Map<String, Object> options = store.getConfig().getCredentialHandlerProperties();
        if (options != null && (providedEncoder = options.get(PASSWORD_ENCODER)) != null) {
            if (PasswordEncoder.class.isInstance(providedEncoder)) {
                this.passwordEncoder = (PasswordEncoder)providedEncoder;
            } else {
                throw new SecurityConfigurationException("The password encoder [" + providedEncoder + "] must be an instance of " + PasswordEncoder.class.getName());
            }
        }
    }

    @Override
    protected Account getAccount(IdentityContext context, V credentials) {
        return this.getAccount(context, (V)((UsernamePasswordCredentials)credentials).getUsername());
    }

    @Override
    protected CredentialStorage getCredentialStorage(IdentityContext context, Account account, V credentials, S store) {
        return store.retrieveCurrentCredential(context, account, EncodedPasswordStorage.class);
    }

    @Override
    protected boolean validateCredential(CredentialStorage storage, V credentials) {
        EncodedPasswordStorage hash = (EncodedPasswordStorage)storage;
        if (hash != null) {
            String rawPassword = new String(((UsernamePasswordCredentials)credentials).getPassword().getValue());
            return this.passwordEncoder.verify(this.saltPassword(rawPassword, hash.getSalt()), hash.getEncodedHash());
        }
        return false;
    }

    @Override
    public void update(IdentityContext context, Account account, U password, S store, Date effectiveDate, Date expiryDate) {
        EncodedPasswordStorage hash = new EncodedPasswordStorage();
        String rawPassword = new String(((Password)password).getValue());
        String passwordSalt = this.generateSalt();
        hash.setSalt(passwordSalt);
        hash.setEncodedHash(this.passwordEncoder.encode(this.saltPassword(rawPassword, passwordSalt)));
        if (effectiveDate != null) {
            hash.setEffectiveDate(effectiveDate);
        }
        hash.setExpiryDate(expiryDate);
        store.storeCredential(context, account, hash);
    }

    private String saltPassword(String rawPassword, String salt) {
        return salt + rawPassword;
    }

    private String generateSalt() {
        SecureRandom pseudoRandom = null;
        try {
            pseudoRandom = SecureRandom.getInstance(DEFAULT_SALT_ALGORITHM);
            pseudoRandom.setSeed(1024L);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IdentityManagementException("Error getting SecureRandom instance: SHA1PRNG", e);
        }
        return String.valueOf(pseudoRandom.nextLong());
    }
}

