/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.credential.handler;

import java.io.ByteArrayInputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.picketlink.common.util.Base64;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.credential.X509CertificateCredentials;
import org.picketlink.idm.credential.handler.AbstractCredentialHandler;
import org.picketlink.idm.credential.handler.annotations.SupportsCredentials;
import org.picketlink.idm.credential.storage.CredentialStorage;
import org.picketlink.idm.credential.storage.X509CertificateStorage;
import org.picketlink.idm.model.Account;
import org.picketlink.idm.spi.CredentialStore;
import org.picketlink.idm.spi.IdentityContext;

@SupportsCredentials(credentialClass={X509CertificateCredentials.class, X509Certificate.class}, credentialStorage=X509CertificateStorage.class)
public class X509CertificateCredentialHandler<S, V, U>
extends AbstractCredentialHandler<CredentialStore<?>, X509CertificateCredentials, X509Certificate> {
    protected X509CertificateStorage getCredentialStorage(IdentityContext context, Account account, X509CertificateCredentials credentials, CredentialStore<?> store) {
        return store.retrieveCurrentCredential(context, account, X509CertificateStorage.class);
    }

    @Override
    protected boolean validateCredential(IdentityContext context, CredentialStorage storage, X509CertificateCredentials credentials) {
        X509CertificateStorage certificateStorage = (X509CertificateStorage)storage;
        if (!credentials.isTrusted()) {
            try {
                byte[] certBytes = Base64.decode((String)certificateStorage.getBase64Cert());
                CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
                X509Certificate storedCert = (X509Certificate)certFactory.generateCertificate(new ByteArrayInputStream(certBytes));
                X509Certificate providedCert = credentials.getCertificate();
                return storedCert.equals(providedCert);
            }
            catch (Exception e) {
                throw new IdentityManagementException("Error while checking user's certificate.", e);
            }
        }
        return true;
    }

    @Override
    protected Account getAccount(IdentityContext context, X509CertificateCredentials credentials) {
        return this.getAccount(context, credentials.getUsername());
    }

    @Override
    public void update(IdentityContext context, Account account, X509Certificate cert, CredentialStore<?> store, Date effectiveDate, Date expiryDate) {
        X509CertificateStorage storage = new X509CertificateStorage(cert);
        if (effectiveDate != null) {
            storage.setEffectiveDate(effectiveDate);
        }
        storage.setExpiryDate(expiryDate);
        store.storeCredential(context, account, storage);
    }
}

