/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.credential.util;

import java.util.Date;
import org.picketlink.idm.credential.storage.CredentialStorage;
import org.picketlink.idm.model.Account;
import org.picketlink.idm.spi.CredentialStore;
import org.picketlink.idm.spi.IdentityContext;

public final class CredentialUtils {
    public static boolean isCurrentCredential(CredentialStorage credential) {
        Date actualDate = new Date();
        return credential.getEffectiveDate() != null && credential.getEffectiveDate().compareTo(actualDate) <= 0;
    }

    public static boolean isLastCredentialExpired(IdentityContext context, Account agent, CredentialStore<?> store, Class<? extends CredentialStorage> storageClass) {
        return CredentialUtils.isCredentialExpired(CredentialUtils.getCurrentCredential(context, agent, store, storageClass));
    }

    public static <T extends CredentialStorage> T getCurrentCredential(IdentityContext context, Account agent, CredentialStore<?> store, Class<T> storageClass) {
        CredentialStorage lastCredential = null;
        Date actualDate = new Date();
        for (CredentialStorage storedCredential : store.retrieveCredentials(context, agent, storageClass)) {
            if (storedCredential.getEffectiveDate().compareTo(actualDate) > 0 || lastCredential != null && lastCredential.getEffectiveDate().compareTo(storedCredential.getEffectiveDate()) > 0) continue;
            lastCredential = storedCredential;
        }
        return (T)lastCredential;
    }

    public static boolean isCredentialExpired(CredentialStorage credentialStorage) {
        return credentialStorage != null && credentialStorage.getExpiryDate() != null && new Date().compareTo(credentialStorage.getExpiryDate()) > 0;
    }
}

