/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.credential.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.picketlink.idm.IdentityManagementException;
import org.picketlink.idm.config.SecurityConfigurationException;
import org.picketlink.idm.credential.Token;
import org.picketlink.idm.credential.TokenCredential;
import org.picketlink.idm.credential.handler.AbstractCredentialHandler;
import org.picketlink.idm.credential.handler.annotations.SupportsCredentials;
import org.picketlink.idm.credential.storage.AbstractCredentialStorage;
import org.picketlink.idm.credential.storage.CredentialStorage;
import org.picketlink.idm.credential.storage.TokenCredentialStorage;
import org.picketlink.idm.model.Account;
import org.picketlink.idm.spi.CredentialStore;
import org.picketlink.idm.spi.IdentityContext;

@SupportsCredentials(credentialClass={TokenCredential.class, Token.class}, credentialStorage=TokenCredentialStorage.class)
public class TokenCredentialHandler<S extends CredentialStore<?>, V extends TokenCredential, U extends Token>
extends AbstractCredentialHandler<S, V, U> {
    public static final String TOKEN_PROVIDER = "TOKEN_PROVIDER";
    private final List<Token.Provider> tokenProvider = new ArrayList<Token.Provider>();

    @Override
    public void setup(S store) {
        super.setup(store);
        Object configuredTokenProviders = store.getConfig().getCredentialHandlerProperties().get(TOKEN_PROVIDER);
        if (configuredTokenProviders != null) {
            try {
                if (Token.Provider.class.isInstance(configuredTokenProviders)) {
                    this.tokenProvider.add((Token.Provider)configuredTokenProviders);
                } else if (configuredTokenProviders.getClass().isArray()) {
                    this.tokenProvider.addAll(Arrays.asList((Token.Provider[])configuredTokenProviders));
                } else if (List.class.isInstance(configuredTokenProviders)) {
                    this.tokenProvider.addAll((List)configuredTokenProviders);
                }
            }
            catch (ClassCastException cce) {
                throw new SecurityConfigurationException("Token provider is not a " + Token.Provider.class.getName() + " instance. You provided " + configuredTokenProviders);
            }
        }
    }

    @Override
    protected boolean validateCredential(IdentityContext context, CredentialStorage credentialStorage, V credentials) {
        return this.getTokenProvider(((TokenCredential)credentials).getToken()).validate(((TokenCredential)credentials).getToken());
    }

    @Override
    protected Account getAccount(IdentityContext context, V credentials) {
        Token token = ((TokenCredential)credentials).getToken();
        return this.getTokenProvider(token).getAccount(token);
    }

    @Override
    protected CredentialStorage getCredentialStorage(IdentityContext context, Account account, V credentials, S store) {
        return store.retrieveCurrentCredential(context, account, TokenCredentialStorage.class);
    }

    @Override
    public void update(IdentityContext context, Account account, U credential, S store, Date effectiveDate, Date expiryDate) {
        Object tokenStorage = this.getTokenProvider((Token)credential).getTokenStorage(account, (Token)credential);
        if (tokenStorage == null) {
            tokenStorage = new TokenCredentialStorage();
            ((TokenCredentialStorage)tokenStorage).setType(((Token)credential).getType());
            ((TokenCredentialStorage)tokenStorage).setValue(((Token)credential).getToken());
        }
        if (effectiveDate != null) {
            ((AbstractCredentialStorage)tokenStorage).setEffectiveDate(effectiveDate);
        }
        if (((AbstractCredentialStorage)tokenStorage).getExpiryDate() == null) {
            ((AbstractCredentialStorage)tokenStorage).setExpiryDate(expiryDate);
        }
        if (((TokenCredentialStorage)tokenStorage).getType() == null) {
            throw new IdentityManagementException("TokenCredentialStorage can not have a null type.");
        }
        store.storeCredential(context, account, (CredentialStorage)tokenStorage);
    }

    private Token.Provider getTokenProvider(Token token) {
        if (this.tokenProvider.isEmpty()) {
            throw new SecurityConfigurationException("You must provide one or more(Array or List) " + Token.Provider.class.getName() + " instances using the following credential property: " + TokenCredentialHandler.class.getName() + ".TOKEN_PROVIDER");
        }
        for (Token.Provider selectedProvider : this.tokenProvider) {
            if (!selectedProvider.supports(token)) continue;
            return selectedProvider;
        }
        throw new SecurityConfigurationException("There is no " + Token.Provider.class.getName() + " that supports this token [" + token + "]");
    }
}

