/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.picketlink.idm.model.IdentityType;

public abstract class AbstractIdentityType
implements IdentityType,
Serializable {
    private static final long serialVersionUID = 1L;
    private boolean enabled = true;
    private Date createdDate = null;
    private Date expiryDate = null;
    private Map<String, String[]> attributes = new HashMap<String, String[]>();

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public Date getExpiryDate() {
        return this.expiryDate;
    }

    @Override
    public Date getCreatedDate() {
        return this.createdDate;
    }

    @Override
    public void setAttribute(String name, String value) {
        this.attributes.put(name, new String[]{value});
    }

    @Override
    public void setAttribute(String name, String[] values) {
        this.attributes.put(name, values);
    }

    @Override
    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    @Override
    public String getAttribute(String name) {
        String[] vals = this.attributes.get(name);
        return null == vals ? null : (vals.length != 0 ? vals[0] : null);
    }

    @Override
    public String[] getAttributeValues(String name) {
        return this.attributes.get(name);
    }

    @Override
    public Map<String, String[]> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }
}

