/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.picketlink.idm.SecurityConfigurationException;
import org.picketlink.idm.model.Grant;
import org.picketlink.idm.model.GroupMembership;
import org.picketlink.idm.model.GroupRole;
import org.picketlink.idm.model.Relationship;

public class FeatureSet {
    private final Map<FeatureGroup, Set<FeatureOperation>> supportedFeatures = new HashMap<FeatureGroup, Set<FeatureOperation>>();
    private final Map<Class<? extends Relationship>, Set<FeatureOperation>> supportedRelationships = new HashMap<Class<? extends Relationship>, Set<FeatureOperation>>();
    private boolean supportsCustomRelationships = false;
    private boolean supportsMultiRealm = false;
    private boolean locked = false;

    public void addFeature(FeatureGroup feature, FeatureOperation operation) throws SecurityConfigurationException {
        this.checkIfFeatureSetIsLocked();
        this.getFeatureOperations(feature).add(operation);
    }

    public void removeFeature(FeatureGroup feature, FeatureOperation operation) throws SecurityConfigurationException {
        this.checkIfFeatureSetIsLocked();
        this.getFeatureOperations(feature).remove((Object)operation);
        if (FeatureGroup.relationship.equals((Object)feature)) {
            Set<Map.Entry<Class<? extends Relationship>, Set<FeatureOperation>>> relationShipsEntrySet = this.supportedRelationships.entrySet();
            for (Map.Entry<Class<? extends Relationship>, Set<FeatureOperation>> entry : relationShipsEntrySet) {
                this.getRelationshipOperations(entry.getKey()).remove((Object)operation);
            }
        }
    }

    public void removeFeature(FeatureGroup feature) throws SecurityConfigurationException {
        this.checkIfFeatureSetIsLocked();
        this.supportedFeatures.remove((Object)feature);
        if (FeatureGroup.relationship.equals((Object)feature)) {
            this.supportedRelationships.clear();
        }
    }

    public boolean supports(FeatureGroup feature, FeatureOperation operation) {
        return this.getFeatureOperations(feature).contains((Object)operation);
    }

    public boolean supports(FeatureGroup feature) {
        return !this.getFeatureOperations(feature).isEmpty();
    }

    public void addRelationshipFeature(Class<? extends Relationship> relationshipClass, FeatureOperation operation) {
        this.checkIfFeatureSetIsLocked();
        this.getRelationshipOperations(relationshipClass).add(operation);
    }

    public void removeRelationshipFeature(Class<? extends Relationship> relationshipClass, FeatureOperation operation) {
        this.checkIfFeatureSetIsLocked();
        if (!FeatureSet.getDefaultRelationshipClasses().contains(relationshipClass) && !this.supportsCustomRelationships) {
            throw new SecurityConfigurationException("Custom relationships are disabled. You can not add this FeatureOperation to relationship type [" + relationshipClass + "].");
        }
        if (this.supportedRelationships.containsKey(relationshipClass)) {
            this.supportedRelationships.get(relationshipClass).remove((Object)operation);
        }
    }

    public boolean supportsRelationshipFeature(Class<? extends Relationship> relationshipClass, FeatureOperation operation) {
        return this.getRelationshipOperations(relationshipClass).contains((Object)operation);
    }

    public boolean supportsRelationship(Class<? extends Relationship> relationshipClass) {
        if (FeatureSet.getDefaultRelationshipClasses().contains(relationshipClass)) {
            return this.supportedRelationships.containsKey(relationshipClass);
        }
        return this.supportsCustomRelationships && this.supportedRelationships.containsKey(relationshipClass);
    }

    public boolean supportsMultiRealm() {
        return this.supportsMultiRealm;
    }

    public void setSupportsCustomRelationships(boolean value) {
        this.checkIfFeatureSetIsLocked();
        this.supportsCustomRelationships = value;
    }

    public void setSupportsMultiRealm(boolean value) {
        this.checkIfFeatureSetIsLocked();
        this.supportsMultiRealm = value;
    }

    protected void lock() {
        this.locked = true;
    }

    public static void addFeatureSupport(FeatureSet featureSet, FeatureGroup ... groups) {
        FeatureGroup[] features;
        block11: for (FeatureGroup feature : features = groups != null && groups.length > 0 ? groups : FeatureGroup.values()) {
            switch (feature) {
                case agent: {
                    FeatureSet.addBasicOperations(featureSet, feature);
                    continue block11;
                }
                case user: {
                    FeatureSet.addBasicOperations(featureSet, feature);
                    continue block11;
                }
                case group: {
                    FeatureSet.addBasicOperations(featureSet, feature);
                    continue block11;
                }
                case role: {
                    FeatureSet.addBasicOperations(featureSet, feature);
                    continue block11;
                }
                case relationship: {
                    FeatureSet.addRelationshipSupport(featureSet, null);
                    FeatureSet.addBasicOperations(featureSet, feature);
                    continue block11;
                }
                case attribute: {
                    FeatureSet.addBasicOperations(featureSet, feature);
                    continue block11;
                }
                case realm: {
                    FeatureSet.addBasicOperations(featureSet, feature);
                    continue block11;
                }
                case tier: {
                    FeatureSet.addBasicOperations(featureSet, feature);
                    continue block11;
                }
                case credential: {
                    featureSet.addFeature(feature, FeatureOperation.update);
                    featureSet.addFeature(feature, FeatureOperation.validate);
                }
            }
        }
    }

    public static void addRelationshipSupport(FeatureSet featureSet, Class<? extends Relationship> ... relationshipClass) {
        List<Class<? extends Relationship>> classes = relationshipClass != null && relationshipClass.length > 0 ? Arrays.asList(relationshipClass) : FeatureSet.getDefaultRelationshipClasses();
        for (Class<? extends Relationship> cls : classes) {
            featureSet.addRelationshipFeature(cls, FeatureOperation.create);
            featureSet.addRelationshipFeature(cls, FeatureOperation.read);
            featureSet.addRelationshipFeature(cls, FeatureOperation.update);
            featureSet.addRelationshipFeature(cls, FeatureOperation.delete);
        }
    }

    public static void removeRelationshipSupport(FeatureSet featureSet, Class<? extends Relationship> ... relationshipClasses) {
        if (relationshipClasses != null) {
            for (Class<? extends Relationship> relationshipClass : relationshipClasses) {
                featureSet.removeRelationshipFeature(relationshipClass, FeatureOperation.create);
                featureSet.removeRelationshipFeature(relationshipClass, FeatureOperation.read);
                featureSet.removeRelationshipFeature(relationshipClass, FeatureOperation.update);
                featureSet.removeRelationshipFeature(relationshipClass, FeatureOperation.delete);
            }
        }
    }

    private static List<Class<? extends Relationship>> getDefaultRelationshipClasses() {
        ArrayList<Class<? extends Relationship>> classes = new ArrayList<Class<? extends Relationship>>();
        classes.add(Relationship.class);
        classes.add(Grant.class);
        classes.add(GroupMembership.class);
        classes.add(GroupRole.class);
        return classes;
    }

    private static void addBasicOperations(FeatureSet featureSet, FeatureGroup feature) {
        featureSet.addFeature(feature, FeatureOperation.create);
        featureSet.addFeature(feature, FeatureOperation.read);
        featureSet.addFeature(feature, FeatureOperation.update);
        featureSet.addFeature(feature, FeatureOperation.delete);
    }

    private Set<FeatureOperation> getFeatureOperations(FeatureGroup group) {
        if (!this.supportedFeatures.containsKey((Object)group)) {
            this.supportedFeatures.put(group, new HashSet());
        }
        return this.supportedFeatures.get((Object)group);
    }

    private Set<FeatureOperation> getRelationshipOperations(Class<? extends Relationship> relationshipClass) {
        if (!this.supportedRelationships.containsKey(relationshipClass)) {
            this.supportedRelationships.put(relationshipClass, new HashSet());
        }
        return this.supportedRelationships.get(relationshipClass);
    }

    private void checkIfFeatureSetIsLocked() {
        if (this.locked) {
            throw new SecurityConfigurationException("Feature set has already been locked, no additional features may be added.");
        }
    }

    public static enum FeatureOperation {
        create,
        read,
        update,
        delete,
        validate;

    }

    public static enum FeatureGroup {
        agent,
        user,
        group,
        role,
        relationship,
        attribute,
        credential,
        realm,
        tier;

    }
}

