/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.spi;

import java.util.HashMap;
import java.util.Map;
import org.picketlink.idm.IdGenerator;
import org.picketlink.idm.IdentityCache;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.credential.Credentials;
import org.picketlink.idm.credential.spi.CredentialHandler;
import org.picketlink.idm.credential.spi.CredentialHandlerFactory;
import org.picketlink.idm.event.EventBridge;
import org.picketlink.idm.model.AbstractPartition;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Realm;
import org.picketlink.idm.model.Tier;
import org.picketlink.idm.spi.IdentityStore;

public class IdentityStoreInvocationContext {
    private IdentityCache cache;
    private EventBridge eventBridge;
    private Realm realm;
    private Tier tier;
    private CredentialHandlerFactory credentialHandlerFactory;
    private IdGenerator idGenerator;
    private Map<String, Object> parameters = new HashMap<String, Object>();
    private IdentityManager identityManager;

    public IdentityStoreInvocationContext(IdentityManager identityManager, IdentityCache cache, EventBridge eventBridge, CredentialHandlerFactory factory, IdGenerator idGenerator) {
        this.identityManager = identityManager;
        this.cache = cache;
        this.eventBridge = eventBridge;
        this.credentialHandlerFactory = factory;
        this.idGenerator = idGenerator;
    }

    public CredentialHandler getCredentialValidator(Class<? extends Credentials> credentialsClass, IdentityStore identityStore) {
        return this.credentialHandlerFactory.getCredentialValidator(credentialsClass, identityStore.getClass());
    }

    public CredentialHandler getCredentialUpdater(Class<?> credentialClass, IdentityStore identityStore) {
        return this.credentialHandlerFactory.getCredentialUpdater(credentialClass, identityStore.getClass());
    }

    public IdentityCache getCache() {
        return this.cache;
    }

    public Object getParameter(String paramName) {
        return this.parameters.get(paramName);
    }

    public boolean isParameterSet(String paramName) {
        return this.parameters.containsKey(paramName);
    }

    public void setParameter(String paramName, Object value) {
        this.parameters.put(paramName, value);
    }

    public EventBridge getEventBridge() {
        return this.eventBridge;
    }

    public IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    public Realm getRealm() {
        return this.realm;
    }

    public void setRealm(Realm realm) {
        this.realm = realm;
    }

    public Tier getTier() {
        return this.tier;
    }

    public void setTier(Tier tier) {
        this.tier = tier;
    }

    public Partition getPartition() {
        AbstractPartition partition = this.getTier();
        if (partition == null) {
            partition = this.getRealm();
        }
        return partition;
    }

    public IdentityManager getIdentityManager() {
        return this.identityManager;
    }
}

