/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.picketlink.idm.IDMLogger;
import org.picketlink.idm.IdentityManagerFactory;
import org.picketlink.idm.SecurityConfigurationException;
import org.picketlink.idm.config.FeatureSet;
import org.picketlink.idm.config.FileIdentityStoreConfiguration;
import org.picketlink.idm.config.IdentityConfiguration;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.config.JPAIdentityStoreConfiguration;
import org.picketlink.idm.config.LDAPIdentityStoreConfiguration;
import org.picketlink.idm.model.Relationship;
import org.picketlink.idm.spi.ContextInitializer;
import org.picketlink.idm.spi.SecurityContextFactory;
import org.picketlink.idm.spi.StoreFactory;

public abstract class BaseAbstractStoreConfiguration<C extends BaseAbstractStoreConfiguration<?>>
implements IdentityStoreConfiguration<C> {
    private final FeatureSet featureSet = new FeatureSet();
    private final Set<String> realms = new HashSet<String>();
    private final Set<String> tiers = new HashSet<String>();
    private List<ContextInitializer> contextInitializers = new ArrayList<ContextInitializer>();
    private IdentityConfiguration identityConfiguration;

    public BaseAbstractStoreConfiguration() {
    }

    public BaseAbstractStoreConfiguration(IdentityConfiguration configuration) {
        this.identityConfiguration = configuration;
    }

    @Override
    public final void init() throws SecurityConfigurationException {
        this.initConfig();
        this.featureSet.lock();
        if (IDMLogger.LOGGER.isDebugEnabled()) {
            IDMLogger.LOGGER.debugf("FeatureSet for %s", this);
            IDMLogger.LOGGER.debug("Features [");
            for (Map.Entry<FeatureSet.FeatureGroup, Set<FeatureSet.FeatureOperation>> entry : this.featureSet.getSupportedFeatures().entrySet()) {
                IDMLogger.LOGGER.debugf("%s.%s", (Object)entry.getKey(), entry.getValue());
            }
            IDMLogger.LOGGER.debug("]");
            IDMLogger.LOGGER.debug("Relationships [");
            for (Map.Entry<Object, Set<FeatureSet.FeatureOperation>> entry : this.featureSet.getSupportedRelationships().entrySet()) {
                IDMLogger.LOGGER.debugf("%s.%s", entry.getKey(), entry.getValue());
            }
            IDMLogger.LOGGER.debug("]");
        }
    }

    protected abstract void initConfig();

    @Override
    public List<ContextInitializer> getContextInitializers() {
        return this.contextInitializers;
    }

    @Override
    public C addContextInitializer(ContextInitializer contextInitializer) {
        this.contextInitializers.add(contextInitializer);
        return (C)this;
    }

    @Override
    public C supportFeature(FeatureSet.FeatureGroup ... feature) {
        FeatureSet.addFeatureSupport(this.getFeatureSet(), feature);
        return (C)this;
    }

    @Override
    public C supportRelationshipType(Class<? extends Relationship> ... types) {
        FeatureSet.addRelationshipSupport(this.getFeatureSet(), types);
        if (types != null) {
            for (Class<? extends Relationship> relationshipType : types) {
                if (FeatureSet.getDefaultRelationshipClasses().contains(relationshipType)) continue;
                this.getFeatureSet().setSupportsCustomRelationships(true);
            }
        }
        return (C)this;
    }

    @Override
    public C supportAllFeatures() {
        FeatureSet.addFeatureSupport(this.getFeatureSet(), new FeatureSet.FeatureGroup[0]);
        return (C)this;
    }

    @Override
    public FeatureSet getFeatureSet() {
        return this.featureSet;
    }

    @Override
    public C addRealm(String ... realmNames) {
        if (realmNames != null) {
            this.realms.addAll(Arrays.asList(realmNames));
        }
        return (C)this;
    }

    @Override
    public C addTier(String ... tierNames) {
        if (tierNames != null) {
            this.tiers.addAll(Arrays.asList(tierNames));
        }
        return (C)this;
    }

    @Override
    public Set<String> getRealms() {
        if (this.realms.isEmpty()) {
            this.realms.add("default");
        }
        return Collections.unmodifiableSet(this.realms);
    }

    @Override
    public Set<String> getTiers() {
        return Collections.unmodifiableSet(this.tiers);
    }

    public FileIdentityStoreConfiguration fileStore() {
        return this.identityConfiguration.fileStore();
    }

    public JPAIdentityStoreConfiguration jpaStore() {
        return this.identityConfiguration.jpaStore();
    }

    public LDAPIdentityStoreConfiguration ldapStore() {
        return this.identityConfiguration.ldapStore();
    }

    public IdentityConfiguration contextFactory(SecurityContextFactory securityContextFactory) {
        return this.identityConfiguration.contextFactory(securityContextFactory);
    }

    public IdentityConfiguration storeFactory(StoreFactory storeFactory) {
        return this.identityConfiguration.storeFactory(storeFactory);
    }

    public List<IdentityStoreConfiguration<?>> getConfiguredStores() {
        return this.identityConfiguration.getConfiguredStores();
    }

    public void addConfig(IdentityStoreConfiguration<?> config) {
        this.identityConfiguration.addConfig(config);
    }

    public IdentityManagerFactory buildIdentityManagerFactory() {
        return this.identityConfiguration.buildIdentityManagerFactory();
    }
}

