/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.idm.config;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.picketlink.idm.IDMMessages;
import org.picketlink.idm.IdentityManagerFactory;
import org.picketlink.idm.SecurityConfigurationException;
import org.picketlink.idm.config.FileIdentityStoreConfiguration;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.config.JPAIdentityStoreConfiguration;
import org.picketlink.idm.config.LDAPIdentityStoreConfiguration;
import org.picketlink.idm.spi.SecurityContextFactory;
import org.picketlink.idm.spi.StoreFactory;

public class IdentityConfiguration {
    private static final String DEFAULT_IDENTITY_MANAGER_FACTORY_IMPL = "org.picketlink.idm.internal.DefaultIdentityManagerFactory";
    private List<IdentityStoreConfiguration<?>> configuredStores = new ArrayList();
    private SecurityContextFactory securityContextFactory;
    private StoreFactory storeFactory;

    public FileIdentityStoreConfiguration fileStore() {
        FileIdentityStoreConfiguration storeConfig = new FileIdentityStoreConfiguration(this);
        this.addConfig(storeConfig);
        return storeConfig;
    }

    public JPAIdentityStoreConfiguration jpaStore() {
        JPAIdentityStoreConfiguration storeConfig = new JPAIdentityStoreConfiguration(this);
        this.addConfig(storeConfig);
        return storeConfig;
    }

    public LDAPIdentityStoreConfiguration ldapStore() {
        LDAPIdentityStoreConfiguration storeConfig = new LDAPIdentityStoreConfiguration(this);
        this.addConfig(storeConfig);
        return storeConfig;
    }

    public IdentityConfiguration contextFactory(SecurityContextFactory securityContextFactory) {
        this.securityContextFactory = securityContextFactory;
        return this;
    }

    public IdentityConfiguration storeFactory(StoreFactory storeFactory) {
        this.storeFactory = storeFactory;
        return this;
    }

    public List<IdentityStoreConfiguration<?>> getConfiguredStores() {
        return Collections.unmodifiableList(this.configuredStores);
    }

    public void addConfig(IdentityStoreConfiguration<?> config) {
        this.configuredStores.add(config);
    }

    public IdentityManagerFactory buildIdentityManagerFactory() throws SecurityConfigurationException {
        IdentityManagerFactory identityManagerFactory = null;
        try {
            Class<?> implementationClass = Class.forName(DEFAULT_IDENTITY_MANAGER_FACTORY_IMPL);
            identityManagerFactory = this.securityContextFactory != null && this.storeFactory != null ? (IdentityManagerFactory)implementationClass.getConstructor(IdentityConfiguration.class, SecurityContextFactory.class, StoreFactory.class).newInstance(this, this.securityContextFactory, this.storeFactory) : (this.securityContextFactory != null ? (IdentityManagerFactory)implementationClass.getConstructor(IdentityConfiguration.class, SecurityContextFactory.class).newInstance(this, this.securityContextFactory) : (this.storeFactory != null ? (IdentityManagerFactory)implementationClass.getConstructor(IdentityConfiguration.class, StoreFactory.class).newInstance(this, this.storeFactory) : (IdentityManagerFactory)implementationClass.getConstructor(IdentityConfiguration.class).newInstance(this)));
        }
        catch (InvocationTargetException e) {
            throw IDMMessages.MESSAGES.configurationCouldNotCreateIdentityManagerFactoryImpl(DEFAULT_IDENTITY_MANAGER_FACTORY_IMPL, e.getTargetException());
        }
        catch (Exception e) {
            throw IDMMessages.MESSAGES.configurationCouldNotCreateIdentityManagerFactoryImpl(DEFAULT_IDENTITY_MANAGER_FACTORY_IMPL, e);
        }
        return identityManagerFactory;
    }
}

