/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.producer;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.picketlink.IdentityConfigurationEvent;
import org.picketlink.annotations.PicketLink;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.config.IdentityConfiguration;
import org.picketlink.idm.config.IdentityConfigurationBuilder;
import org.picketlink.idm.config.JPAIdentityStoreConfiguration;
import org.picketlink.idm.config.SecurityConfigurationException;
import org.picketlink.idm.internal.IdentityManagerFactory;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.Realm;
import org.picketlink.idm.spi.ContextInitializer;
import org.picketlink.idm.spi.SecurityContextFactory;
import org.picketlink.internal.EEJPAContextInitializer;
import org.picketlink.internal.EESecurityContextFactory;
import org.picketlink.internal.IdentityStoreAutoConfiguration;
import org.picketlink.internal.SecuredIdentityManager;
import org.picketlink.internal.util.Strings;

@ApplicationScoped
public class IdentityManagerProducer {
    @Inject
    Instance<IdentityConfiguration> identityConfigInstance;
    @Inject
    Event<IdentityConfigurationEvent> identityConfigEvent;
    @Inject
    EESecurityContextFactory icf;
    @Inject
    EEJPAContextInitializer jpaContextInitializer;
    @Inject
    IdentityStoreAutoConfiguration autoConfig;
    @Inject
    @PicketLink
    Instance<Realm> defaultRealm;
    private IdentityManagerFactory factory;

    @Inject
    public void init() {
        IdentityConfigurationBuilder builder;
        if (!this.identityConfigInstance.isUnsatisfied()) {
            IdentityConfiguration identityConfiguration = (IdentityConfiguration)this.identityConfigInstance.get();
            builder = new IdentityConfigurationBuilder(identityConfiguration);
        } else {
            if (this.identityConfigInstance.isAmbiguous()) {
                throw new SecurityConfigurationException("Multiple IdentityConfiguration beans found, can not configure IdentityManagerFactory");
            }
            builder = new IdentityConfigurationBuilder();
        }
        this.identityConfigEvent.fire((Object)new IdentityConfigurationEvent(builder));
        if (builder.stores().isEmpty()) {
            this.loadAutoConfig(builder);
        }
        if (builder.stores().isConfigured(JPAIdentityStoreConfiguration.class)) {
            builder.stores().jpa().addContextInitializer((ContextInitializer)this.jpaContextInitializer);
        }
        builder.contextFactory((SecurityContextFactory)this.icf);
        this.factory = new IdentityManagerFactory(builder.build());
    }

    private void loadAutoConfig(IdentityConfigurationBuilder builder) {
        if (this.autoConfig.isConfigured()) {
            builder.stores().jpa().readFrom(this.autoConfig.getJPAConfiguration().create()).supportAllFeatures();
        } else {
            builder.stores().file().supportAllFeatures();
        }
    }

    @Produces
    public IdentityManagerFactory createIdentityManagerFactory() {
        return this.factory;
    }

    @Produces
    @Dependent
    public IdentityManager createIdentityManager() {
        if (this.defaultRealm.isUnsatisfied() || Strings.isEmpty(((Realm)this.defaultRealm.get()).getId())) {
            return new SecuredIdentityManager(this.factory.createIdentityManager());
        }
        return new SecuredIdentityManager(this.factory.createIdentityManager((Partition)this.defaultRealm.get()));
    }
}

