/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.internal;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.persistence.Entity;
import org.picketlink.idm.config.IdentityConfigurationBuilder;
import org.picketlink.idm.config.JPAStoreConfigurationBuilder;
import org.picketlink.idm.jpa.annotations.CredentialAttribute;
import org.picketlink.idm.jpa.annotations.IdentityAttribute;
import org.picketlink.idm.jpa.annotations.IdentityCredential;
import org.picketlink.idm.jpa.annotations.IdentityType;
import org.picketlink.idm.jpa.annotations.Partition;
import org.picketlink.idm.jpa.annotations.Relationship;
import org.picketlink.idm.jpa.annotations.RelationshipAttribute;
import org.picketlink.idm.jpa.annotations.RelationshipIdentity;

@ApplicationScoped
public class IdentityStoreAutoConfiguration
implements Extension {
    private JPAStoreConfigurationBuilder jpaConfig = new IdentityConfigurationBuilder().stores().jpa();
    private boolean configured;

    public <X> void processAnnotatedType(@Observes ProcessAnnotatedType<X> event, BeanManager beanManager) {
        if (event.getAnnotatedType().isAnnotationPresent(Entity.class)) {
            AnnotatedType type = event.getAnnotatedType();
            if (type.isAnnotationPresent(IdentityType.class)) {
                this.jpaConfig.identityClass(type.getJavaClass());
                this.configured = true;
            } else if (type.isAnnotationPresent(IdentityCredential.class)) {
                this.jpaConfig.credentialClass(type.getJavaClass());
            } else if (type.isAnnotationPresent(CredentialAttribute.class)) {
                this.jpaConfig.credentialAttributeClass(type.getJavaClass());
            } else if (type.isAnnotationPresent(IdentityAttribute.class)) {
                this.jpaConfig.attributeClass(type.getJavaClass());
            } else if (type.isAnnotationPresent(Relationship.class)) {
                this.jpaConfig.relationshipClass(type.getJavaClass());
            } else if (type.isAnnotationPresent(RelationshipIdentity.class)) {
                this.jpaConfig.relationshipIdentityClass(type.getJavaClass());
            } else if (type.isAnnotationPresent(RelationshipAttribute.class)) {
                this.jpaConfig.relationshipAttributeClass(type.getJavaClass());
            } else if (type.isAnnotationPresent(Partition.class)) {
                this.jpaConfig.partitionClass(type.getJavaClass());
            }
        }
    }

    public JPAStoreConfigurationBuilder getJPAConfiguration() {
        return this.jpaConfig;
    }

    public boolean isConfigured() {
        return this.configured;
    }
}

