/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.permission.internal;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.Dependent;
import org.picketlink.permission.annotations.PermissionsHandledBy;
import org.picketlink.permission.internal.BaseAbstractPermissionHandler;
import org.picketlink.permission.spi.PermissionHandler;

@Dependent
public class ClassPermissionHandler
extends BaseAbstractPermissionHandler
implements PermissionHandler {
    private Map<Class<?>, String> identifierNames = new ConcurrentHashMap();

    public boolean canHandle(Class<?> resourceClass) {
        return Class.class.equals(resourceClass);
    }

    public String getGeneratedIdentifier(Object resource) {
        if (!(resource instanceof Class)) {
            throw new IllegalArgumentException("Resource [" + resource + "] must be instance of Class");
        }
        return this.getIdentifierName((Class)resource);
    }

    public Serializable getNaturalIdentifier(Object resource) {
        return this.getGeneratedIdentifier(resource);
    }

    private String getIdentifierName(Class<?> cls) {
        if (!this.identifierNames.containsKey(cls)) {
            PermissionsHandledBy handledBy;
            String name = null;
            if (cls.isAnnotationPresent(PermissionsHandledBy.class) && (handledBy = cls.getAnnotation(PermissionsHandledBy.class)).name() != null && !"".equals(handledBy.name().trim())) {
                name = handledBy.name();
            }
            if (name == null) {
                name = cls.getName().substring(cls.getName().lastIndexOf(46) + 1);
            }
            this.identifierNames.put(cls, name);
            return name;
        }
        return this.identifierNames.get(cls);
    }

    public boolean canLoadResource(String identifier) {
        return false;
    }

    public Object lookupResource(String identifier) {
        return null;
    }
}

