/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.producer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.picketlink.IdentityConfigurationEvent;
import org.picketlink.PartitionManagerCreateEvent;
import org.picketlink.annotations.PicketLink;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.PartitionManager;
import org.picketlink.idm.PermissionManager;
import org.picketlink.idm.RelationshipManager;
import org.picketlink.idm.config.IdentityConfiguration;
import org.picketlink.idm.config.IdentityConfigurationBuilder;
import org.picketlink.idm.config.IdentityStoreConfiguration;
import org.picketlink.idm.event.EventBridge;
import org.picketlink.idm.internal.DefaultPartitionManager;
import org.picketlink.idm.model.Partition;
import org.picketlink.idm.model.basic.Realm;
import org.picketlink.internal.CDIEventBridge;
import org.picketlink.internal.IdentityStoreAutoConfiguration;
import org.picketlink.internal.SecuredIdentityManager;

@ApplicationScoped
public class IdentityManagerProducer {
    @Inject
    private Instance<IdentityConfiguration> identityConfigInstance;
    @Inject
    private Event<IdentityConfigurationEvent> identityConfigEvent;
    @Inject
    private Event<PartitionManagerCreateEvent> partitionManagerCreateEvent;
    @Inject
    @PicketLink
    private Instance<PartitionManager> partitionManagerInstance;
    @Inject
    private CDIEventBridge eventBridge;
    @Inject
    private IdentityStoreAutoConfiguration autoConfig;
    @Inject
    @PicketLink
    private Instance<Partition> defaultPartition;
    private PartitionManager partitionManager;

    @Inject
    public void init() {
        this.partitionManager = this.isPartitionManagerProduced() ? (PartitionManager)this.partitionManagerInstance.get() : this.createEmbeddedPartitionManager();
    }

    @Produces
    public PartitionManager createPartitionManager() {
        return this.partitionManager;
    }

    @Produces
    @RequestScoped
    public IdentityManager createIdentityManager() {
        if (this.defaultPartition.isUnsatisfied() || this.defaultPartition.get() == null) {
            return new SecuredIdentityManager(this.partitionManager.createIdentityManager());
        }
        return new SecuredIdentityManager(this.partitionManager.createIdentityManager((Partition)this.defaultPartition.get()));
    }

    @Produces
    @RequestScoped
    public RelationshipManager createRelationshipManager() {
        return this.partitionManager.createRelationshipManager();
    }

    @Produces
    @RequestScoped
    public PermissionManager createPermissionManager() {
        return this.partitionManager.createPermissionManager();
    }

    private boolean isPartitionManagerProduced() {
        return !this.partitionManagerInstance.isUnsatisfied();
    }

    private IdentityConfigurationBuilder createIdentityConfigurationBuilder() {
        List<IdentityConfiguration> configurations = this.getIdentityConfiguration();
        IdentityConfigurationBuilder builder = configurations.isEmpty() ? new IdentityConfigurationBuilder() : new IdentityConfigurationBuilder(configurations);
        this.identityConfigEvent.fire((Object)new IdentityConfigurationEvent(builder));
        if (!builder.isConfigured()) {
            this.configureDefaults(builder);
        }
        return builder;
    }

    private List<IdentityConfiguration> getIdentityConfiguration() {
        ArrayList<IdentityConfiguration> configurations = new ArrayList<IdentityConfiguration>();
        if (!this.identityConfigInstance.isUnsatisfied()) {
            Iterator iterator = this.identityConfigInstance.iterator();
            while (iterator.hasNext()) {
                configurations.add((IdentityConfiguration)iterator.next());
            }
        }
        return configurations;
    }

    private void configureDefaults(IdentityConfigurationBuilder builder) {
        this.autoConfig.configure(builder);
    }

    private PartitionManager createEmbeddedPartitionManager() {
        IdentityConfigurationBuilder builder = this.createIdentityConfigurationBuilder();
        DefaultPartitionManager partitionManager = new DefaultPartitionManager((Collection)builder.buildAll(), (EventBridge)this.eventBridge);
        this.partitionManagerCreateEvent.fire((Object)new PartitionManagerCreateEvent((PartitionManager)partitionManager));
        this.createDefaultPartition((PartitionManager)partitionManager);
        return partitionManager;
    }

    private void createDefaultPartition(PartitionManager partitionManager) {
        if (this.isPartitionSupported(partitionManager) && partitionManager.getPartitions(Partition.class).isEmpty()) {
            partitionManager.add((Partition)new Realm("default"));
        }
    }

    private boolean isPartitionSupported(PartitionManager partitionManager) {
        for (IdentityConfiguration configuration : partitionManager.getConfigurations()) {
            if (!configuration.supportsPartition()) continue;
            for (IdentityStoreConfiguration storeConfig : configuration.getStoreConfiguration()) {
                if (!storeConfig.supportsType(Realm.class, IdentityStoreConfiguration.IdentityOperation.create)) continue;
                return true;
            }
        }
        return false;
    }
}

