/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.extension;

import java.lang.annotation.Annotation;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import org.picketlink.Identity;
import org.picketlink.config.SecurityConfiguration;
import org.picketlink.event.SecurityConfigurationEvent;
import org.picketlink.internal.IdentityBeanDefinition;
import org.picketlink.log.BaseLog;

@ApplicationScoped
public class PicketLinkExtension
implements Extension {
    private SecurityConfiguration securityConfiguration;

    public SecurityConfiguration getSecurityConfiguration() {
        return this.securityConfiguration;
    }

    <T> void vetoIdentityImplementations(@Observes ProcessAnnotatedType<T> pat) {
        AnnotatedType annotatedType = pat.getAnnotatedType();
        Class javaClass = annotatedType.getJavaClass();
        if (!Identity.class.equals((Object)javaClass) && Identity.class.isAssignableFrom(javaClass)) {
            pat.veto();
        }
    }

    void initializeConfiguration(@Observes AfterBeanDiscovery abd, BeanManager beanManager) {
        BaseLog.ROOT_LOGGER.picketlinkBootstrap();
        SecurityConfigurationEvent securityConfigurationEvent = new SecurityConfigurationEvent();
        beanManager.fireEvent((Object)securityConfigurationEvent, new Annotation[0]);
        this.securityConfiguration = securityConfigurationEvent.getBuilder().build();
        abd.addBean((Bean)new IdentityBeanDefinition(this.securityConfiguration, beanManager));
    }
}

