/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.http.internal;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.picketlink.Identity;
import org.picketlink.annotations.PicketLink;
import org.picketlink.authentication.AuthenticationException;
import org.picketlink.config.SecurityConfiguration;
import org.picketlink.config.SecurityConfigurationBuilder;
import org.picketlink.config.http.AuthenticationConfiguration;
import org.picketlink.config.http.AuthenticationSchemeConfiguration;
import org.picketlink.config.http.AuthorizationConfiguration;
import org.picketlink.config.http.BasicAuthenticationConfiguration;
import org.picketlink.config.http.CustomAuthenticationConfiguration;
import org.picketlink.config.http.DigestAuthenticationConfiguration;
import org.picketlink.config.http.FormAuthenticationConfiguration;
import org.picketlink.config.http.HttpSecurityConfiguration;
import org.picketlink.config.http.HttpSecurityConfigurationException;
import org.picketlink.config.http.OutboundRedirectConfiguration;
import org.picketlink.config.http.PathConfiguration;
import org.picketlink.config.http.TokenAuthenticationConfiguration;
import org.picketlink.config.http.X509AuthenticationConfiguration;
import org.picketlink.credential.DefaultLoginCredentials;
import org.picketlink.extension.PicketLinkExtension;
import org.picketlink.http.AccessDeniedException;
import org.picketlink.http.AuthenticationRequiredException;
import org.picketlink.http.HttpMethod;
import org.picketlink.http.MethodNotAllowedException;
import org.picketlink.http.authentication.HttpAuthenticationScheme;
import org.picketlink.http.authorization.PathAuthorizer;
import org.picketlink.http.internal.PathMatcher;
import org.picketlink.http.internal.authentication.schemes.BasicAuthenticationScheme;
import org.picketlink.http.internal.authentication.schemes.DigestAuthenticationScheme;
import org.picketlink.http.internal.authentication.schemes.FormAuthenticationScheme;
import org.picketlink.http.internal.authentication.schemes.TokenAuthenticationScheme;
import org.picketlink.http.internal.authentication.schemes.X509AuthenticationScheme;
import org.picketlink.http.internal.authorization.ExpressionPathAuthorizer;
import org.picketlink.http.internal.authorization.GroupPathAuthorizer;
import org.picketlink.http.internal.authorization.RealmPathAuthorizer;
import org.picketlink.http.internal.authorization.RolePathAuthorizer;
import org.picketlink.idm.PartitionManager;
import org.picketlink.internal.el.ELProcessor;
import org.picketlink.log.BaseLog;

public class SecurityFilter
implements Filter {
    public static final String AUTHENTICATION_ORIGINAL_PATH = SecurityFilter.class.getName() + ".authc.original.path";
    @Inject
    private PicketLinkExtension picketLinkExtension;
    @Inject
    private Instance<PartitionManager> partitionManager;
    @Inject
    private Instance<Identity> identityInstance;
    @Inject
    private Instance<DefaultLoginCredentials> credentialsInstance;
    @Inject
    @Any
    private Instance<HttpAuthenticationScheme> authenticationSchemesInstance;
    @Inject
    @Any
    private Instance<PathAuthorizer> pathAuthorizerInstance;
    @Inject
    @PicketLink
    private Instance<HttpServletRequest> picketLinkHttpServletRequest;
    @Inject
    private ELProcessor elProcessor;
    private HttpSecurityConfiguration configuration;
    private Map<PathConfiguration, HttpAuthenticationScheme> authenticationSchemes = new HashMap<PathConfiguration, HttpAuthenticationScheme>();
    private PathMatcher pathMatcher;
    private Map<PathConfiguration, List<PathAuthorizer>> pathAuthorizers = new HashMap<PathConfiguration, List<PathAuthorizer>>();

    public void init(FilterConfig config) throws ServletException {
        SecurityConfigurationBuilder configurationBuilder = this.picketLinkExtension.getSecurityConfigurationBuilder();
        SecurityConfiguration securityConfiguration = configurationBuilder.build();
        this.configuration = securityConfiguration.getHttpSecurityConfiguration();
        if (this.configuration == null) {
            throw new HttpSecurityConfigurationException("No configuration provided.");
        }
        this.initializePathMatcher();
        this.initializeAuthenticationSchemes();
        this.initializePathAuthorizers();
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        if (!HttpServletRequest.class.isInstance(servletRequest)) {
            throw new ServletException("This filter can only process HttpServletRequest requests.");
        }
        HttpServletRequest request = null;
        HttpServletResponse response = null;
        PathConfiguration pathConfiguration = null;
        try {
            request = (HttpServletRequest)this.picketLinkHttpServletRequest.get();
            if (BaseLog.HTTP_LOGGER.isDebugEnabled()) {
                BaseLog.HTTP_LOGGER.debugf("Processing request to path [%s].", (Object)request.getRequestURI());
            }
            response = (HttpServletResponse)servletResponse;
            pathConfiguration = this.pathMatcher.matches(request);
            this.performAuthenticationIfRequired(pathConfiguration, request, response);
            if (this.isSecured(pathConfiguration)) {
                if (!this.isMethodAllowed(pathConfiguration, request)) {
                    throw new MethodNotAllowedException("The given method is not allowed [" + request.getMethod() + "] for path [" + pathConfiguration.getUri() + "].");
                }
                if (!response.isCommitted()) {
                    Identity identity = this.getIdentity();
                    if (!identity.isLoggedIn()) {
                        this.challengeClientForCredentials(pathConfiguration, request, response);
                    } else if (this.isLogoutPath(pathConfiguration)) {
                        this.performLogout(request, response, identity, pathConfiguration);
                    } else if (!this.isAuthorized(pathConfiguration, request, response)) {
                        throw new AccessDeniedException("The request for the given path [" + pathConfiguration.getUri() + "] was forbidden.");
                    }
                }
            }
            this.performOutboundProcessing(pathConfiguration, request, response, chain);
        }
        catch (Exception e) {
            this.handleException(pathConfiguration, request, response, e);
        }
    }

    private boolean isSecured(PathConfiguration pathConfiguration) {
        return pathConfiguration != null && pathConfiguration.isSecured();
    }

    private boolean isMethodAllowed(PathConfiguration pathConfiguration, HttpServletRequest request) {
        Set methods = pathConfiguration.getMethods();
        return methods.contains(HttpMethod.valueOf((String)request.getMethod().toUpperCase()));
    }

    private void performOutboundProcessing(PathConfiguration pathConfiguration, HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (response.isCommitted()) {
            if (BaseLog.HTTP_LOGGER.isDebugEnabled()) {
                BaseLog.HTTP_LOGGER.debugf("Response already commited. Ignoring outbound processing for path [%s].", (Object)pathConfiguration);
            }
            return;
        }
        if (this.isSecured(pathConfiguration)) {
            String redirectUrl = pathConfiguration.getRedirectUrl(OutboundRedirectConfiguration.Condition.OK);
            if (redirectUrl == null && this.isLogoutPath(pathConfiguration)) {
                redirectUrl = request.getContextPath();
            }
            if (redirectUrl != null) {
                this.redirect(redirectUrl, request, response);
            } else {
                this.processRequest(pathConfiguration, request, response, chain);
            }
        } else if (this.configuration.isPermissive()) {
            this.processRequest(pathConfiguration, request, response, chain);
        } else if (pathConfiguration == null) {
            response.sendError(403, "No configuration found for the given path [" + request.getRequestURI() + "] ");
        }
    }

    private void redirect(String redirectUrl, HttpServletRequest request, HttpServletResponse response) throws IOException {
        redirectUrl = this.formatRedirectUrl(request, redirectUrl);
        if (BaseLog.HTTP_LOGGER.isDebugEnabled()) {
            BaseLog.HTTP_LOGGER.debugf("Redirecting to [%s].", (Object)redirectUrl);
        }
        response.sendRedirect(redirectUrl);
    }

    private void handleException(PathConfiguration pathConfiguration, HttpServletRequest request, HttpServletResponse response, Throwable exception) throws IOException {
        int statusCode;
        String redirectUrl = null;
        if (BaseLog.HTTP_LOGGER.isDebugEnabled()) {
            BaseLog.HTTP_LOGGER.debugf("Handling exception [%s] for path [%s].", (Object)exception, (Object)request.getRequestURI());
        }
        if (AuthenticationRequiredException.class.isInstance(exception)) {
            statusCode = 401;
        } else if (AccessDeniedException.class.isInstance(exception)) {
            statusCode = 403;
            if (this.isSecured(pathConfiguration)) {
                redirectUrl = pathConfiguration.getRedirectUrl(OutboundRedirectConfiguration.Condition.FORBIDDEN);
            }
        } else if (MethodNotAllowedException.class.isInstance(exception)) {
            statusCode = 405;
        } else {
            statusCode = 500;
            if (this.isSecured(pathConfiguration)) {
                redirectUrl = pathConfiguration.getRedirectUrl(OutboundRedirectConfiguration.Condition.ERROR);
            }
        }
        if (redirectUrl != null) {
            this.redirect(redirectUrl, request, response);
        } else {
            String message = exception.getMessage();
            if (message == null) {
                message = "The server could not process your request.";
            }
            if (BaseLog.HTTP_LOGGER.isDebugEnabled()) {
                BaseLog.HTTP_LOGGER.errorf("Exception [%s] thrown during processing for path [%s]. Sending error with status code [%s].", (Object)exception, (Object)request.getRequestURI(), (Object)statusCode);
            }
            response.sendError(statusCode, message);
        }
    }

    private String formatRedirectUrl(HttpServletRequest request, String redirectUrl) {
        if (redirectUrl.startsWith("/") && !redirectUrl.startsWith(request.getContextPath())) {
            redirectUrl = request.getContextPath() + redirectUrl;
        }
        return redirectUrl;
    }

    private void performLogout(HttpServletRequest request, HttpServletResponse response, Identity identity, PathConfiguration pathConfiguration) throws IOException {
        if (identity.isLoggedIn()) {
            identity.logout();
        }
    }

    private boolean isLogoutPath(PathConfiguration pathConfiguration) {
        return pathConfiguration != null && pathConfiguration.getLogoutConfiguration() != null;
    }

    private boolean isAuthorized(PathConfiguration pathConfiguration, HttpServletRequest request, HttpServletResponse response) {
        List<PathAuthorizer> authorizers = this.pathAuthorizers.get(pathConfiguration);
        if (authorizers != null) {
            for (PathAuthorizer authorizer : authorizers) {
                if (authorizer.authorize(pathConfiguration, request, response)) continue;
                return false;
            }
        }
        return true;
    }

    private void processRequest(PathConfiguration pathConfiguration, HttpServletRequest request, HttpServletResponse response, FilterChain chain) {
        try {
            if (BaseLog.HTTP_LOGGER.isDebugEnabled()) {
                BaseLog.HTTP_LOGGER.debugf("Continuing to process request for path [%s].", (Object)request.getRequestURI());
            }
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not process request.", e);
        }
    }

    private void challengeClientForCredentials(PathConfiguration pathConfiguration, HttpServletRequest request, HttpServletResponse response) {
        HttpAuthenticationScheme authenticationScheme = this.getAuthenticationScheme(pathConfiguration, request);
        if (authenticationScheme != null) {
            PathConfiguration authenticationOriginalPath;
            if (BaseLog.HTTP_LOGGER.isDebugEnabled()) {
                BaseLog.HTTP_LOGGER.debugf("Challenging client using authentication scheme [%s].", (Object)authenticationScheme);
            }
            try {
                authenticationScheme.challengeClient(request, response);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not challenge client for credentials.", e);
            }
            HttpSession session = request.getSession(false);
            if (!(session == null || (authenticationOriginalPath = (PathConfiguration)session.getAttribute(AUTHENTICATION_ORIGINAL_PATH)) != null && authenticationOriginalPath.equals(pathConfiguration))) {
                session.setAttribute(AUTHENTICATION_ORIGINAL_PATH, (Object)pathConfiguration);
            }
        }
    }

    private void performAuthenticationIfRequired(PathConfiguration pathConfiguration, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Identity identity = this.getIdentity();
        HttpAuthenticationScheme authenticationScheme = this.getAuthenticationScheme(pathConfiguration, request);
        if (authenticationScheme != null) {
            DefaultLoginCredentials creds = this.extractCredentials(request, authenticationScheme);
            if (BaseLog.HTTP_LOGGER.isDebugEnabled()) {
                BaseLog.HTTP_LOGGER.debugf("Credentials extracted from request [%s]", creds.getCredential());
            }
            if (creds.getCredential() != null) {
                if (identity.isLoggedIn()) {
                    if (BaseLog.HTTP_LOGGER.isDebugEnabled()) {
                        BaseLog.HTTP_LOGGER.debugf("Forcing re-authentication. Logging out current user [%s]", (Object)identity.getAccount());
                    }
                    identity.logout();
                }
                creds = this.extractCredentials(request, authenticationScheme);
            }
            if (creds.getCredential() != null) {
                try {
                    if (BaseLog.HTTP_LOGGER.isDebugEnabled()) {
                        BaseLog.HTTP_LOGGER.debugf("Authenticating using credentials [%s]", creds.getCredential());
                    }
                    identity.login();
                    authenticationScheme.onPostAuthentication(request, response);
                }
                catch (AuthenticationException ae) {
                    BaseLog.HTTP_LOGGER.authenticationFailed(creds.getUserId(), (Throwable)ae);
                }
            }
        } else if (!identity.isLoggedIn() && pathConfiguration != null && pathConfiguration.getAuthorizationConfiguration() != null) {
            throw new AuthenticationRequiredException("The given path [" + pathConfiguration.getUri() + "] requires authentication.");
        }
    }

    private HttpAuthenticationScheme getAuthenticationScheme(PathConfiguration pathConfiguration, HttpServletRequest request) {
        HttpAuthenticationScheme authenticationScheme = null;
        if (pathConfiguration != null) {
            AuthenticationConfiguration authcConfiguration = pathConfiguration.getAuthenticationConfiguration();
            if (authcConfiguration != null) {
                AuthenticationSchemeConfiguration authSchemeConfiguration = authcConfiguration.getAuthenticationSchemeConfiguration();
                authenticationScheme = this.authenticationSchemes.get(pathConfiguration);
                if (authenticationScheme == null) {
                    Class authcSchemeType;
                    if (FormAuthenticationConfiguration.class.isInstance(authSchemeConfiguration)) {
                        authcSchemeType = FormAuthenticationScheme.class;
                    } else if (DigestAuthenticationConfiguration.class.isInstance(authSchemeConfiguration)) {
                        authcSchemeType = DigestAuthenticationScheme.class;
                    } else if (BasicAuthenticationConfiguration.class.isInstance(authSchemeConfiguration)) {
                        authcSchemeType = BasicAuthenticationScheme.class;
                    } else if (X509AuthenticationConfiguration.class.isInstance(authSchemeConfiguration)) {
                        authcSchemeType = X509AuthenticationScheme.class;
                    } else if (TokenAuthenticationConfiguration.class.isInstance(authSchemeConfiguration)) {
                        authcSchemeType = TokenAuthenticationScheme.class;
                    } else if (CustomAuthenticationConfiguration.class.isInstance(authSchemeConfiguration)) {
                        CustomAuthenticationConfiguration customAuthcConfig = (CustomAuthenticationConfiguration)authSchemeConfiguration;
                        authcSchemeType = customAuthcConfig.getSchemeType();
                    } else {
                        throw new HttpSecurityConfigurationException("Unexpected Authentication Scheme configuration [" + authSchemeConfiguration + "].");
                    }
                    authenticationScheme = this.resolveInstance(this.authenticationSchemesInstance, authcSchemeType);
                    this.authenticationSchemes.put(pathConfiguration, authenticationScheme);
                }
            }
        } else {
            authenticationScheme = this.restorePreviousAuthenticationScheme(request);
        }
        return authenticationScheme;
    }

    public void destroy() {
    }

    private HttpAuthenticationScheme restorePreviousAuthenticationScheme(HttpServletRequest request) {
        for (Map.Entry<PathConfiguration, HttpAuthenticationScheme> entry : this.authenticationSchemes.entrySet()) {
            PathConfiguration originalAuthcPath;
            HttpSession session;
            DefaultLoginCredentials creds = this.extractCredentials(request, entry.getValue());
            if (creds.getCredential() == null || (session = request.getSession(false)) == null || (originalAuthcPath = (PathConfiguration)session.getAttribute(AUTHENTICATION_ORIGINAL_PATH)) == null || !originalAuthcPath.equals(entry.getKey())) continue;
            session.removeAttribute(AUTHENTICATION_ORIGINAL_PATH);
            return entry.getValue();
        }
        return null;
    }

    private DefaultLoginCredentials extractCredentials(HttpServletRequest request, HttpAuthenticationScheme authenticationScheme) {
        DefaultLoginCredentials creds = this.getCredentials();
        authenticationScheme.extractCredential(request, creds);
        return creds;
    }

    private DefaultLoginCredentials getCredentials() {
        return this.resolveInstance(this.credentialsInstance);
    }

    private Identity getIdentity() {
        return this.resolveInstance(this.identityInstance);
    }

    private <I> I resolveInstance(Instance<I> instance) {
        return this.resolveInstance(instance, null);
    }

    private <I> I resolveInstance(Instance<I> fromInstance, Class<? extends I> type) {
        try {
            Instance instance = type != null ? fromInstance.select(type, new Annotation[0]) : fromInstance;
            if (instance.isUnsatisfied()) {
                throw new IllegalStateException("Instance [" + instance + "] not found.");
            }
            if (instance.isAmbiguous()) {
                throw new IllegalStateException("Instance [" + instance + "] is ambiguous.");
            }
            return (I)instance.get();
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not retrieve fromInstance [" + fromInstance + "].", e);
        }
    }

    private void initializeAuthenticationSchemes() {
        for (List configurations : this.configuration.getPaths().values()) {
            for (PathConfiguration pathConfiguration : configurations) {
                AuthenticationConfiguration authcConfig;
                AuthenticationSchemeConfiguration authcSchemeConfig;
                HttpAuthenticationScheme authenticationScheme;
                if (!pathConfiguration.isSecured() || (authenticationScheme = this.getAuthenticationScheme(pathConfiguration, null)) == null || CustomAuthenticationConfiguration.class.isInstance(authcSchemeConfig = (authcConfig = pathConfiguration.getAuthenticationConfiguration()).getAuthenticationSchemeConfiguration())) continue;
                try {
                    authenticationScheme.initialize(authcSchemeConfig);
                }
                catch (Exception e) {
                    throw new HttpSecurityConfigurationException("Could not initialize Http Authentication Scheme [" + authenticationScheme + "].", (Throwable)e);
                }
            }
        }
    }

    private void initializePathAuthorizers() {
        for (List configurations : this.configuration.getPaths().values()) {
            for (PathConfiguration pathConfiguration : configurations) {
                AuthorizationConfiguration authorizationConfiguration;
                if (!pathConfiguration.isSecured() || (authorizationConfiguration = pathConfiguration.getAuthorizationConfiguration()) == null) continue;
                ArrayList<PathAuthorizer> pathAuthorizers = new ArrayList<PathAuthorizer>();
                ArrayList<Class<? extends PathAuthorizer>> pathAuthorizerTypes = new ArrayList<Class<? extends PathAuthorizer>>(authorizationConfiguration.getAuthorizers());
                pathAuthorizerTypes.addAll(this.getDefaultPathAuthorizers());
                for (Class clazz : pathAuthorizerTypes) {
                    try {
                        pathAuthorizers.add(this.resolveInstance(this.pathAuthorizerInstance, clazz));
                    }
                    catch (Exception e) {
                        throw new HttpSecurityConfigurationException("Could not resolve PathAuthorizer [" + clazz + "].", (Throwable)e);
                    }
                }
                this.pathAuthorizers.put(pathConfiguration, pathAuthorizers);
            }
        }
    }

    private Set<Class<? extends PathAuthorizer>> getDefaultPathAuthorizers() {
        HashSet<Class<? extends PathAuthorizer>> defaultAuthorizers = new HashSet<Class<? extends PathAuthorizer>>();
        defaultAuthorizers.add(RolePathAuthorizer.class);
        defaultAuthorizers.add(GroupPathAuthorizer.class);
        defaultAuthorizers.add(RealmPathAuthorizer.class);
        defaultAuthorizers.add(ExpressionPathAuthorizer.class);
        return defaultAuthorizers;
    }

    private void initializePathMatcher() {
        this.pathMatcher = new PathMatcher(this.configuration.getPaths(), this.elProcessor);
    }
}

