/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.http.internal;

import java.util.EnumSet;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.picketlink.config.SecurityConfiguration;
import org.picketlink.extension.PicketLinkExtension;
import org.picketlink.http.internal.SecurityFilter;

@ApplicationScoped
@WebListener
public class PicketLinkServletContextListener
implements ServletContextListener {
    public static final String PICKETLINK_SECURITY_FILTER_NAME = "PicketLink Security Filter";
    @Inject
    private PicketLinkExtension picketLinkExtension;
    @Inject
    private SecurityFilter securityFilter;

    public void contextInitialized(ServletContextEvent sce) {
        if (this.isHttpSecurityEnabled()) {
            this.addSecurityFilter(sce);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }

    private void addSecurityFilter(ServletContextEvent sce) {
        ServletContext servletContext = sce.getServletContext();
        FilterRegistration.Dynamic filter = servletContext.addFilter(PICKETLINK_SECURITY_FILTER_NAME, (Filter)this.securityFilter);
        filter.addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), false, new String[]{"/*"});
    }

    private boolean isHttpSecurityEnabled() {
        SecurityConfiguration securityConfiguration = this.picketLinkExtension.getSecurityConfiguration();
        return securityConfiguration.getHttpSecurityConfiguration() != null;
    }
}

