/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.http.internal.authentication.schemes;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.picketlink.common.util.Base64;
import org.picketlink.common.util.StringUtil;
import org.picketlink.config.http.BasicAuthenticationConfiguration;
import org.picketlink.credential.DefaultLoginCredentials;
import org.picketlink.http.authentication.HttpAuthenticationScheme;

public class BasicAuthenticationScheme
implements HttpAuthenticationScheme<BasicAuthenticationConfiguration> {
    public static final String DEFAULT_REALM_NAME = "PicketLink Default Realm";
    private String realm = "PicketLink Default Realm";

    public void initialize(BasicAuthenticationConfiguration config) {
        String providedRealm = config.getRealmName();
        if (providedRealm != null) {
            this.realm = providedRealm;
        }
    }

    public void extractCredential(HttpServletRequest request, DefaultLoginCredentials creds) {
        if (this.isBasicAuthentication(request)) {
            String[] usernameAndPassword = this.extractUsernameAndPassword(request);
            String username = usernameAndPassword[0];
            String password = usernameAndPassword[1];
            if (!StringUtil.isNullOrEmpty((String)username) || !StringUtil.isNullOrEmpty((String)password)) {
                creds.setUserId(username);
                creds.setPassword(password);
            }
        }
    }

    public void challengeClient(HttpServletRequest request, HttpServletResponse response) {
        try {
            response.setHeader("WWW-Authenticate", "Basic realm=\"" + this.realm + "\"");
            if (this.isAjaxRequest(request)) {
                response.sendError(403);
            } else {
                response.sendError(401);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not challenge client credentials.", e);
        }
    }

    public void onPostAuthentication(HttpServletRequest request, HttpServletResponse response) {
    }

    private boolean isBasicAuthentication(HttpServletRequest request) {
        return this.getAuthorizationHeader(request) != null && this.getAuthorizationHeader(request).startsWith("Basic ");
    }

    private String getAuthorizationHeader(HttpServletRequest request) {
        return request.getHeader("Authorization");
    }

    public String[] extractUsernameAndPassword(HttpServletRequest request) {
        String authorizationHeader = this.getAuthorizationHeader(request);
        String base64Token = authorizationHeader.substring(6);
        String token = new String(Base64.decode((String)base64Token));
        String username = "";
        String password = "";
        int delim = token.indexOf(":");
        if (delim != -1) {
            username = token.substring(0, delim);
            password = token.substring(delim + 1);
        }
        return new String[]{username, password};
    }

    private boolean isAjaxRequest(HttpServletRequest request) {
        String requestedWith = request.getHeader("X-Requested-With");
        return requestedWith != null && "XMLHttpRequest".equalsIgnoreCase(requestedWith);
    }
}

