/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.subsystem.federation.model;

import java.util.List;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.picketlink.as.subsystem.federation.service.FederationService;
import org.picketlink.as.subsystem.model.AbstractResourceAddStepHandler;
import org.picketlink.as.subsystem.model.ModelElement;

public class FederationAddHandler
extends AbstractResourceAddStepHandler {
    public static final FederationAddHandler INSTANCE = new FederationAddHandler();

    private FederationAddHandler() {
        super(ModelElement.FEDERATION);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        PathAddress pathAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
        this.createFederationService(pathAddress.getLastElement().getValue(), context, verificationHandler, newControllers);
    }

    private void createFederationService(String alias, OperationContext context, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        FederationService service = new FederationService();
        ServiceName serviceName = FederationService.createServiceName(alias);
        ServiceController controller = context.getServiceTarget().addService(serviceName, (Service)service).addListener((ServiceListener)verificationHandler).setInitialMode(ServiceController.Mode.ACTIVE).install();
        newControllers.add(controller);
    }
}

