/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.subsystem.federation.model.handlers;

import java.util.List;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.ServiceController;
import org.picketlink.as.subsystem.federation.service.AbstractEntityProviderService;
import org.picketlink.as.subsystem.federation.service.IdentityProviderService;
import org.picketlink.as.subsystem.federation.service.ServiceProviderService;
import org.picketlink.as.subsystem.model.AbstractResourceAddStepHandler;
import org.picketlink.as.subsystem.model.ModelElement;
import org.picketlink.config.federation.handler.Handler;
import org.picketlink.config.federation.handler.Handlers;

public class HandlerAddHandler
extends AbstractResourceAddStepHandler {
    public static final HandlerAddHandler INSTANCE = new HandlerAddHandler();

    private HandlerAddHandler() {
        super(ModelElement.COMMON_HANDLER);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        String providerAlias = ((Property)operation.get("address").asPropertyList().get(2)).getValue().asString();
        String className = operation.get(ModelElement.COMMON_CLASS.getName()).asString();
        AbstractEntityProviderService providerService = this.getParentProviderService(context, providerAlias);
        Handlers handlerChain = providerService.getPicketLinkType().getHandlers();
        Handler newHandler = new Handler();
        newHandler.setClazz(className);
        handlerChain.add(newHandler);
    }

    private AbstractEntityProviderService getParentProviderService(OperationContext context, String providerAlias) {
        AbstractEntityProviderService providerService = IdentityProviderService.getService(context.getServiceRegistry(true), providerAlias);
        if (providerService == null) {
            providerService = ServiceProviderService.getService(context.getServiceRegistry(true), providerAlias);
        }
        return providerService;
    }
}

