/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.subsystem.federation.service;

import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.picketlink.as.subsystem.federation.service.IdentityProviderService;
import org.picketlink.as.subsystem.model.ModelUtils;
import org.picketlink.config.federation.KeyProviderType;
import org.picketlink.identity.federation.core.config.STSConfiguration;

public class FederationService
implements Service<FederationService> {
    private static final String SERVICE_NAME = "FederationService";
    private KeyProviderType keyProvider;
    private STSConfiguration samlConfig;
    private IdentityProviderService identityProviderService;

    public FederationService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public void start(StartContext context) throws StartException {
    }

    public void stop(StopContext context) {
    }

    public static FederationService getService(ServiceRegistry registry, ModelNode model) {
        ServiceController container = registry.getService(FederationService.createServiceName(ModelUtils.getFederationAlias(model)));
        if (container != null) {
            return (FederationService)container.getValue();
        }
        return null;
    }

    public KeyProviderType getKeyProvider() {
        return this.keyProvider;
    }

    public void setKeyProvider(KeyProviderType keyProviderType) {
        this.keyProvider = keyProviderType;
    }

    public STSConfiguration getSamlConfig() {
        return this.samlConfig;
    }

    public void setSamlConfig(STSConfiguration samlConfig) {
        this.samlConfig = samlConfig;
    }

    public static ServiceName createServiceName(String alias) {
        return ServiceName.JBOSS.append(new String[]{SERVICE_NAME, alias});
    }

    public void setIdentityProviderService(IdentityProviderService identityProviderService) {
        this.identityProviderService = identityProviderService;
    }

    public IdentityProviderService getIdentityProviderService() {
        return this.identityProviderService;
    }
}

