/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.as.subsystem.idm.deployment;

import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.Phase;
import org.picketlink.as.subsystem.PicketLinkLogger;
import org.picketlink.as.subsystem.deployment.AbstractCDIDeploymentUnitProcessor;
import org.picketlink.as.subsystem.deployment.PicketLinkStructureDeploymentProcessor;
import org.picketlink.as.subsystem.idm.PicketLinkIDMSubsystemExtension;

public class PicketLinkIDMDeploymentProcessor
extends AbstractCDIDeploymentUnitProcessor {
    public static final Phase PHASE = Phase.POST_MODULE;
    public static final int PRIORITY = 3328;

    @Override
    public void doDeploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deployment = phaseContext.getDeploymentUnit();
        if (PicketLinkStructureDeploymentProcessor.isIDMDeployment(deployment)) {
            if (deployment.getParent() != null) {
                deployment = deployment.getParent();
            }
            this.addExtension(deployment, new PicketLinkIDMSubsystemExtension());
            PicketLinkLogger.ROOT_LOGGER.configuringDeployment("PicketLink IDM CDI Extension", deployment.getName());
        }
    }

    @Override
    protected boolean isAlreadyConfigured(DeploymentUnit deployment) {
        return this.hasExtension(deployment, PicketLinkIDMSubsystemExtension.class);
    }

    public void undeploy(DeploymentUnit context) {
    }
}

